/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.project.callstack.RuntimeCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.userinterface.UIPage;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallstackTable
extends DATableComposite {
    public CallstackTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(TimelineTableView.tabID, null));
                GridItem[] sels = CallstackTable.this.table.getSelection();
                if (sels.length <= 0) {
                    return;
                }
                CallstackTable.this.table.setFocusItem(sels[0]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.applyFilterImage();
    }

    @Override
    public void updateTable() {
    }

    public void updateCallstackTable(DASelectionData selData) {
        this.table.removeAll();
        if (selData == null) {
            return;
        }
        String viewId = selData.getViewID();
        if (viewId == null || viewId.isEmpty() || viewId.equals(FilePage.chartViewID) || viewId.equals(UIPage.profilingViewID) || viewId.equals(GLPage.chartViewID) || viewId.equals(GLPage.contextViewID) || viewId.equals("contextHistoryID.id") || viewId.equals(GLPage.programViewID) || viewId.equals(GLPage.statisticsViewID) || viewId.equals(GLPage.redundantViewID) || viewId.equals(GLPage.textureViewID) || viewId.equals(UIPage.profilingViewID) || viewId.equals(RangePage.profilingViewID) || viewId.equals(SummaryPage.profilingViewID)) {
            return;
        }
        Object obj = selData.getData();
        if (obj instanceof GridItem[]) {
            GridItem[] items = (GridItem[])obj;
            if (items.length <= 0) {
                return;
            }
            DATableDataFormat tableData = (DATableDataFormat)items[0].getData();
            long seqNum = -1L;
            int pid = -1;
            long time = -1L;
            if (tableData.getType() == 2) {
                List<Object> failedData = tableData.getData();
                seqNum = (Long)failedData.get(0);
                pid = (Integer)failedData.get(7);
                time = (Long)failedData.get(1);
            } else if (tableData.getType() == 4) {
                List<Object> leakData = tableData.getData();
                seqNum = (Long)leakData.get(0);
                pid = (Integer)leakData.get(2);
                time = (Long)leakData.get(4);
            } else if (tableData.getType() == 32) {
                List<Object> calltraceData = tableData.getData();
                seqNum = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.index);
                pid = (Integer)calltraceData.get(FunctionEntryDBTable.COLUMN.PID.index);
                time = (Long)calltraceData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
            } else {
                if (tableData.getType() == 2048) {
                    return;
                }
                LogData logData = tableData.getLogData();
                seqNum = logData.getSeq();
                pid = logData.getPid();
                time = logData.getTime();
            }
            RuntimeCallstackManager callstackManager = Global.getRuntimeCallstackManager();
            Map<Long, CallStackUnit> addrMap = callstackManager.getCallStackApiAddrByPidMap(pid);
            if (addrMap == null) {
                return;
            }
            List<Long> addrs = null;
            addrs = callstackManager.getCallstackAddrListFromSeq(seqNum);
            if (addrs == null) {
                return;
            }
            int size = addrs.size();
            int i = 0;
            while (i < size) {
                String hexAddr = Formatter.toHexString(addrs.get(i).toString());
                CallStackUnit api = addrMap.get(addrs.get(i));
                if (api == null) {
                    Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                    return;
                }
                String path = api.getPath();
                if (path == null) {
                    Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                    return;
                }
                GridItem gridItem = new GridItem(this.table, 0);
                long address = addrs.get(i);
                DATableDataFormat callstackTableData = new DATableDataFormat(address);
                callstackTableData.setType(1);
                callstackTableData.setObject(address);
                gridItem.setData((Object)callstackTableData);
                gridItem.setData("address", (Object)address);
                gridItem.setData("pid", (Object)pid);
                gridItem.setData("time", (Object)time);
                gridItem.setData("libName", (Object)path);
                String addrInput = addrs.get(i) == 0L ? "" : hexAddr;
                gridItem.setText(1, addrInput);
                String fName = api.getFunctionName();
                gridItem.setText(0, fName);
                gridItem.setText(2, path);
                ++i;
            }
        }
    }

    @Override
    protected List<TableInput> makeTableInput() {
        return null;
    }
}

