/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.chart;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.InteractivePageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.common.SetRangeMarkerMouseMoveListener;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChart;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChartRenderer;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveEditItemsDialog;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveValue;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.AddChartMenuComposite;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class InteractiveChartView
extends DAViewComposite {
    private DAChartBoard chartBoard;
    private final RangeDataManager rangeDataManager = RangeDataManager.getInstance();
    private final LifecycleLogParser lifecycleLogParser = LifecycleLogParser.getInstance();
    private List<InteractiveChart> chartList = new ArrayList<InteractiveChart>();

    public InteractiveChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.chartBoard = new DAChartBoard(contents, InteractivePageLabels.INTERACTIVE_CHART);
        this.chartBoard.setItemHeight(65);
        this.chartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        ScrollBar hScrollBar = this.chartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InteractiveChartView.this.chartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(InteractivePage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(InteractivePage.pageID, false);
                }
            }
        });
        StackLayout stackLayout = new StackLayout();
        stackLayout.topControl = this.chartBoard;
        contents.setLayout((Layout)stackLayout);
        this.initializeCharts();
        AddChartMenuComposite addChartComposite = new AddChartMenuComposite(this.chartBoard.getTitleComp());
        addChartComposite.setAddItemListButtonListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                InteractiveEditItemsDialog dialog = new InteractiveEditItemsDialog(shell, InteractiveChartView.this);
                if (!dialog.isRunningDialog()) {
                    dialog.open();
                }
            }
        });
        addChartComposite.createAddMenuComp();
        this.setBackground(ColorResources.VIEW_BG_COLOR);
        DATimeline timeline = this.chartBoard.getTimeline();
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        this.lifecycleLogParser.registerLifecycleBar(this.chartBoard.getLifecycleBar());
        this.lifecycleLogParser.registerTimeline(timeline);
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        timeline.addMouseMoveListener((MouseMoveListener)new SetRangeMarkerMouseMoveListener(this.rangeDataManager, this.chartBoard, timeline));
        InteractiveDataManager.getInstance().setChartView(this);
    }

    private void initializeCharts() {
        this.initIntervalMarkers(this.chartBoard);
        List<TimelineChart> timelineChartList = InteractiveDataManager.getInstance().getTimelineChartList();
        int i = 0;
        while (i < timelineChartList.size()) {
            TimelineChart timelineChart = timelineChartList.get(i);
            DAChartBoardItem item = timelineChart.createBoardItem(this.chartBoard);
            item.setHeight(80);
            DAChart chartWidget = item.getChart();
            chartWidget.getPlot().setAxisRangeX(this.chartBoard.getVisibleStartTime(), this.chartBoard.getVisibleEndTime());
            chartWidget.getPlot().setMarkers(this.chartBoard.getMarkers());
            InteractiveChartMouseEventListener chartMouseEventListener = new InteractiveChartMouseEventListener(timelineChart.getPopupMenu(), this.chartBoard.getTimeline(), this.chartBoard);
            chartWidget.addMouseListener((MouseListener)chartMouseEventListener);
            chartWidget.addMouseMoveListener((MouseMoveListener)chartMouseEventListener);
            chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.chartBoard.getTimeline()));
            TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this.chartBoard);
            chartWidget.addKeyListener((KeyListener)timelineKeyListener);
            List<TimelineChart> showChartList = InteractiveDataManager.getInstance().getShowTimelineChartList();
            this.chartBoard.hideItem(i);
            int ii = 0;
            while (ii < showChartList.size()) {
                if (showChartList.get(ii).getChartType() == timelineChart.getChartType()) {
                    this.chartBoard.showItem(i);
                }
                ++ii;
            }
            ++i;
        }
        List<InteractiveInfo> interactiveList = InteractiveDataManager.getInstance().getVariableInfoList();
        int i2 = 0;
        while (i2 < interactiveList.size()) {
            InteractiveChart chart = new InteractiveChart(interactiveList.get(i2));
            this.chartList.add(chart);
            DAChartBoardItem boardItem = chart.createBoardItem(this.chartBoard);
            DAChart chartWidget = boardItem.getChart();
            chartWidget.setChartRenderer((DAChartRenderer)new InteractiveChartRenderer());
            String chartInfo = interactiveList.get(i2).getDescription();
            chartWidget.setInformation(chartInfo);
            chartWidget.getPlot().setMarkers(this.chartBoard.getMarkers());
            InteractiveChartMouseEventListener chartMouseEventListener = new InteractiveChartMouseEventListener(chart.getPopupMenu(), this.chartBoard.getTimeline(), this.chartBoard);
            chartWidget.addMouseListener((MouseListener)chartMouseEventListener);
            chartWidget.addMouseMoveListener((MouseMoveListener)chartMouseEventListener);
            chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.chartBoard.getTimeline()));
            ++i2;
        }
    }

    private void initIntervalMarkers(DAChartBoard board) {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.SELECTION_LINE);
        rangeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }

    public void updateView() {
        InteractiveDataManager.getInstance().makeChartSeries(AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleStartTime()), AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleEndTime()));
        long time = Toolbar.INSTANCE.getTime();
        if (AnalyzerUtil.isLatestTraceMode(InteractivePage.pageID)) {
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(0);
            intervalMarker.setInterval((double)time / 1000000.0, (double)time / 1000000.0);
            this.chartBoard.updateVisibleStartTime();
            this.chartBoard.setTotalEndTime(time, true);
        } else {
            this.chartBoard.setTotalEndTime(time, false);
        }
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(1)).setInterval((double)this.rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)this.rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(2)).setInterval((double)this.rangeDataManager.getMarkerStartTime() / 1000000.0, (double)this.rangeDataManager.getMarkerEndTime() / 1000000.0);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            Double startTime = Formatter.longTimeToDoubleTime(start);
            Double endTime = Formatter.longTimeToDoubleTime(end);
            double middleTime = (startTime + endTime) / 2.0;
            if (startTime.equals(endTime)) {
                middleTime = startTime;
            }
            this.chartBoard.setVisibleMiddleTime(middleTime);
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(0);
            intervalMarker.setInterval(startTime.doubleValue(), endTime.doubleValue());
            InteractiveDataManager.getInstance().makeChartSeries(AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleStartTime()), AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleEndTime()));
        }
    }

    public void clear() {
        this.chartBoard.contentsClear();
        this.chartBoard.clear();
        this.chartList.clear();
        for (TimelineChart timelineChart : InteractiveDataManager.getInstance().getTimelineChartList()) {
            timelineChart.clear();
        }
        this.initializeCharts();
    }

    public Control getControl() {
        return this.chartBoard;
    }

    public void setRangeMarker(double starttime, double endtime) {
        ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(2)).setInterval(starttime, endtime);
    }

    public void inputChartSeries(ResultSet rs) {
        Map<Long, List<InteractiveValue>> valueInfoMap = InteractiveDataManager.getInstance().makeInteractiveValueMap(rs);
        if (valueInfoMap == null) {
            return;
        }
        int i = 0;
        while (i < this.chartList.size()) {
            InteractiveInfo rootInteractiveInfo = this.chartList.get(i).getInteractiveInfo();
            ArrayList<InteractiveUIData> beforeUIDataList = new ArrayList<InteractiveUIData>();
            ArrayList<InteractiveUIData> afterUIDataList = new ArrayList<InteractiveUIData>();
            boolean result = InteractiveDataManager.getInstance().makeInteractiveUIData(rootInteractiveInfo, valueInfoMap, beforeUIDataList, afterUIDataList);
            if (result) {
                this.chartList.get(i).inputChartSeries(beforeUIDataList, afterUIDataList);
            }
            ++i;
        }
    }

    public void reArrangeChart(List<Integer> order, List<Boolean> showInfo) {
        if (order != null) {
            int lastIndex = order.size();
            int i = 0;
            while (i < this.chartList.size()) {
                order.add(lastIndex++);
                ++i;
            }
            this.chartBoard.reArrangeItem(order.toArray(new Integer[order.size()]));
        }
        int i = 0;
        while (i < showInfo.size()) {
            if (showInfo.get(i).booleanValue()) {
                this.chartBoard.showItem(i);
            } else {
                this.chartBoard.hideItem(i);
            }
            ++i;
        }
    }
}

