/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.KernelPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.common.SetRangeMarkerMouseMoveListener;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChart;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class ContextSwitchingChartView
extends DAViewComposite {
    public static final int KERNEL_CHART_HEIGHT = 40;
    public static final int KERNEL_COMBO_ITEM_HEIGHT = 24;
    private final Composite contents;
    private ContextSwitchingChart contextChart;
    private DACustomCombo contextCombo;
    private final StackLayout stackLayout;
    public static final int[] kernelScaleValue = new int[]{100, 200, 400, 800, 1600};

    public ContextSwitchingChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(KernelPageLabels.CONTEXT_SWITCH_CHART_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.contextChart = new ContextSwitchingChart(this.contents, KernelPageLabels.CONTEXT_SWITCH_CHART_TITLE, kernelScaleValue);
        this.contextChart.setNameFont(FontResources.CHART_NAME_FONT);
        this.contextChart.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                ContextSwitchingChartView.this.handleSelection(item);
            }
        });
        ScrollBar hScrollBar = this.contextChart.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ContextSwitchingChartView.this.contextChart.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(KernelPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(KernelPage.pageID, false);
                }
            }
        });
        this.initIntervalMarkers(this.contextChart);
        this.stackLayout.topControl = this.contextChart;
        this.contextCombo = new DACustomCombo(this.contextChart.getTitleComp(), 0);
        this.contextCombo.setComboGradation(ColorResources.FRAME_RATE_COMBO_NORMAL_START, ColorResources.FRAME_RATE_COMBO_NORMAL_END, ColorResources.FRAME_RATE_COMBO_PUSH_START, ColorResources.FRAME_RATE_COMBO_PUSH_END, ColorResources.FRAME_RATE_COMBO_HOVER_START, ColorResources.FRAME_RATE_COMBO_HOVER_END, ColorResources.FRAME_RATE_COMBO_DISABLE_START, ColorResources.FRAME_RATE_COMBO_DISABLE_END);
        this.contextCombo.setOutlineColors(ColorResources.FRAME_RATE_COMBO_OUTLINE_NORMAL, ColorResources.FRAME_RATE_COMBO_OUTLINE_PUSH, ColorResources.FRAME_RATE_COMBO_OUTLINE_HOVER, ColorResources.FRAME_RATE_COMBO_OUTLINE_DISABLE);
        this.contextCombo.add(KernelPageLabels.CONTEXT_SWITCH_CHART_TITLE);
        this.contextCombo.select(0);
        this.contextCombo.setEnabled(false);
        this.contextCombo.setTextAlign(16384);
        this.contextCombo.setComboFont(FontResources.FRAME_RATE_COMBO);
        this.contextCombo.setFontColors(ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR);
        this.contextCombo.setItemFont(FontResources.FRAME_RATE_DROPDOWN);
        this.contextCombo.setItemFontColor(ColorResources.ADD_CHART_FONT_COLOR);
        this.contextCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        DATimeline threadTimeline = this.contextChart.getTimeline();
        threadTimeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        threadTimeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.contextChart.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(threadTimeline);
        threadTimeline.addMouseMoveListener((MouseMoveListener)new SetRangeMarkerMouseMoveListener(RangeDataManager.getInstance(), this.contextChart, threadTimeline));
    }

    private void handleSelection(DAChartBoardItem selectItem) {
        if (selectItem == null) {
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(KernelPage.contextViewID, (long)(((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(0)).getStartVal() * 1000000.0), (long)(((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(0)).getEndVal() * 1000000.0), new Integer(0), null));
        } else {
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(KernelPage.contextViewID, (long)(((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(0)).getStartVal() * 1000000.0), (long)(((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(0)).getEndVal() * 1000000.0), selectItem.getData(), null));
        }
    }

    public void updateView() {
        this.contextChart.updateChart();
        if (AnalyzerUtil.isLatestTraceMode(KernelPage.pageID)) {
            this.contextChart.updateVisibleStartTime();
            this.contextChart.setTotalEndTime(Toolbar.INSTANCE.getTime(), true);
        } else {
            this.contextChart.setTotalEndTime(Toolbar.INSTANCE.getTime(), false);
        }
        RangeDataManager rangeDataManager = RangeDataManager.getInstance();
        if (rangeDataManager.isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(1)).setInterval((double)rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.contextChart.getMarkers().get(2)).setInterval((double)rangeDataManager.getMarkerStartTime() / 1000000.0, (double)rangeDataManager.getMarkerEndTime() / 1000000.0);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            double startTime = (double)start / 1000000.0;
            double endTime = (double)end / 1000000.0;
            DAChartBoard chartBoard = (DAChartBoard)this.stackLayout.topControl;
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)chartBoard.getMarkers().get(0);
            intervalMarker.setInterval(startTime, endTime);
        }
    }

    public void clear() {
        this.contextChart.clear();
        this.initIntervalMarkers(this.contextChart);
    }

    public Control getControl() {
        return this.contextChart;
    }

    private void initIntervalMarkers(DAChartBoard board) {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.RED);
        rangeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }
}

