/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.memory.MemoryAllocationTraceTableView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryCallStackView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryChartView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryDetailsTableView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryMapView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryStatisticsTableView;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemoryDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class MemoryPage
extends DAPageComposite {
    public static final String pageID = MemoryPage.class.getName();
    public static final String chartViewID = MemoryChartView.class.getName();
    public static final String detailsViewID = MemoryDetailsTableView.class.getName();
    public static final String mapViewID = MemoryMapView.class.getName();
    SashForm baseForm;
    SashForm topForm;
    SashForm bottomForm;
    SashForm bottomRightForm;
    SashForm bottomLeftForm;
    private DATabComposite memoryTabView = null;
    MemoryChartView memoryChartView;
    MemoryDetailsTableView memoryDetailsTableView;
    MemoryStatisticsTableView memoryStatisticsTableView;
    MemoryAllocationTraceTableView memoryAllocationTraceTableView;
    MemoryMapView memoryMapView;
    MemoryCallStackView memoryCallStackView;
    boolean isDetailMode = true;
    int tableHeight = -1;
    int tableWeight = 65;
    boolean wasSashCreated = false;

    public MemoryPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_MEMORY);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_GRAPHICS_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.WHITE);
        this.baseForm.setBackground(ColorResources.WHITE);
        this.topForm = new SashForm((Composite)this.baseForm, 512);
        this.memoryChartView = new MemoryChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)this.memoryChartView);
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        this.bottomLeftForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomLeftForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        this.bottomLeftForm.setLayout((Layout)new FillLayout());
        this.bottomRightForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomRightForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        this.bottomRightForm.setLayout((Layout)new FillLayout());
        this.memoryTabView = new DATabComposite((Composite)this.bottomLeftForm, 0, false, true);
        this.memoryDetailsTableView = new MemoryDetailsTableView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryDetailsTableView, false);
        this.addView((DABaseComposite)this.memoryDetailsTableView);
        this.memoryStatisticsTableView = new MemoryStatisticsTableView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryStatisticsTableView, false);
        this.addView((DABaseComposite)this.memoryStatisticsTableView);
        this.memoryAllocationTraceTableView = new MemoryAllocationTraceTableView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryAllocationTraceTableView, false);
        this.addView((DABaseComposite)this.memoryAllocationTraceTableView);
        this.addView((DABaseComposite)this.memoryTabView);
        DATabComposite memoryMapCallStackView = new DATabComposite((Composite)this.bottomRightForm, 0, false, true);
        this.memoryMapView = new MemoryMapView(memoryMapCallStackView.getContentComposite(), 0);
        this.addView((DABaseComposite)this.memoryMapView);
        memoryMapCallStackView.addView((DABaseComposite)this.memoryMapView, false);
        this.addView((DABaseComposite)memoryMapCallStackView);
        this.baseForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        this.bottomLeftForm.setSashWidth(2);
        this.bottomRightForm.setSashWidth(2);
        this.bottomForm.setWeights(new int[]{this.tableWeight, 100 - this.tableWeight});
        this.addTableWeightListener();
    }

    private void addHeightWeightListener() {
        if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    MemoryPage.this.tableHeight = (int)((double)MemoryPage.this.baseForm.getWeights()[0] / (double)MemoryPage.this.baseForm.getWeights()[0] + (double)MemoryPage.this.baseForm.getWeights()[1]) * MemoryPage.this.baseForm.getSize().y * 1 / 1000;
                }
            });
            this.wasSashCreated = true;
        }
    }

    private void addTableWeightListener() {
        ((SashForm)this.bottomForm.getChildren()[0]).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MemoryPage.this.resizeTableButton();
            }
        });
    }

    public Composite getTopTable() {
        DAViewComposite view = (DAViewComposite)this.memoryTabView.getTopComposite();
        Composite comp = (Composite)view.getControl();
        Logger.debug((Object)comp.toString());
        return comp;
    }

    public SashForm getBaseForm() {
        return this.baseForm;
    }

    public void setDetailMode(boolean mode) {
        this.isDetailMode = mode;
    }

    protected void onResized(int width, int height) {
        if (!this.wasSashCreated) {
            this.addHeightWeightListener();
        }
        this.resizePageButton();
        this.resizeTableButton();
        if (!this.isDetailMode) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.baseForm.setWeights(nArray);
        } else {
            int hrate;
            int n = hrate = this.tableHeight == -1 ? (int)(23500.0 / (double)height) : this.tableHeight * 100 / height;
            if (hrate > 100) {
                return;
            }
            this.baseForm.setWeights(new int[]{100 - hrate, hrate});
        }
    }

    private void resizePageButton() {
        int width = WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width;
        int pageCount = PageInfoRegistry.getPageNamesByTarget(SettingDataManager.INSTANCE.getConnectedTarget().getTargetName()).size();
        int newWidth = width / pageCount > 190 ? 190 : width / pageCount;
        ((BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).getMainTab().updateTabButtonsWidth(newWidth);
    }

    private void resizeTableButton() {
        int tabCount;
        double weight = (double)this.bottomForm.getWeights()[0] / 1000.0;
        int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
        int newWidth = width / (tabCount = this.memoryTabView.getTabButtons().size()) > 190 ? 190 : width / tabCount;
        this.memoryTabView.updateTabButtonsWidth(newWidth);
    }

    public void clear() {
        super.clear();
        MemoryDataManager.getInstance().clear();
        HeapDataManager.getInstance().clear();
    }

    public void updateView() {
        for (Map.Entry entry : this.childMap.entrySet()) {
            ((DABaseComposite)entry.getValue()).updateView();
        }
        if (!this.isDetailMode) {
            if (this.baseForm.getChildren().length > 2) {
                ((Sash)this.baseForm.getChildren()[2]).setVisible(false);
            }
        } else if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).setVisible(true);
        }
    }
}

