/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryStatisticsTableView
extends DAViewComposite {
    public static final String ID = MemoryStatisticsTableView.class.getName();
    public static final int PATH_TABLE_INDEX = 0;
    public static final int PERSISTENT_BYTE_TABLE_INDEX = 1;
    public static final int PERSISTENT_TABLE_INDEX = 0;
    public static final int FREED_TABLE_INDEX = 0;
    public static final int TOTAL_BYTE_TABLE_INDEX = 0;
    public static final int TOTAL_TABLE_INDEX = 0;
    private boolean tableUpdate;
    private boolean firstUpdate;
    private boolean tableVisible;
    private MemoryStatisticsTable tableComp = null;
    private boolean[] columnVisibilityEnable;
    private boolean[] columnVisibilityDisable;

    public MemoryStatisticsTableView(Composite parent, int style) {
        super(parent, style, false);
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        this.columnVisibilityEnable = blArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[7] = true;
        this.columnVisibilityDisable = blArray2;
        this.setLayout((Layout)new FillLayout());
        this.setTitle(MemoryPageLabels.MEMORY_STATISTICS_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new MemoryStatisticsTable(contents, 0, 68354);
        this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
        this.tableUpdate = false;
        this.tableVisible = false;
        this.firstUpdate = true;
    }

    public void updateView() {
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableComp == null) {
            return;
        }
        if (!DAState.isRunning() && this.firstUpdate) {
            this.firstUpdate = false;
            this.tableUpdate = true;
            this.tableVisible = true;
        }
        if (this.tableVisible) {
            this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
        } else {
            this.tableComp.clear();
            this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
        }
        if (this.tableUpdate) {
            this.tableComp.updateTable();
            this.tableUpdate = false;
        }
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)vdata;
        if (selData.getStartTime() == selData.getEndTime()) {
            this.tableComp.setSelectionRange(0L, 0L);
            boolean bl = this.tableUpdate = !DAState.isRunning();
            if (DAState.isRunning()) {
                this.tableVisible = false;
                this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
                return;
            }
        } else {
            this.tableComp.setSelectionRange(selData.getStartTime(), selData.getEndTime());
            this.tableUpdate = true;
            this.tableVisible = true;
        }
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableVisible) {
            this.tableComp.setColumnVisibility(this.columnVisibilityEnable);
        } else {
            this.tableComp.clear();
            this.tableComp.setColumnVisibility(this.columnVisibilityDisable);
        }
        this.tableComp.updateTable();
        this.tableUpdate = false;
    }

    public void clear() {
        this.tableComp.clear();
        this.tableUpdate = false;
        this.firstUpdate = true;
        this.tableVisible = false;
    }

    public Control getControl() {
        return this.tableComp;
    }
}

