/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemHeapDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class HeapDataManager
extends PageDataManager {
    private static HeapDataManager instance = new HeapDataManager();
    private final int MEM_API_TYPE_ALLOC = 0;
    private final int MEM_API_TYPE_FREE = 1;
    private final int PRESISTENT_SIZE_INDEX = 0;
    private final int PRESISTENT_COUNT_INDEX = 1;
    private final int FREE_COUNT_INDEX = 2;
    private final int TOTAL_SIZE_INDEX = 3;
    private int REALLOC_ID;
    private MemAllocDBTable allocateDBTable = null;
    private MemFreeDBTable freeDBTable = null;
    private MemHeapDBTable heapDBTable = null;
    private DBInserter allocateDBInserter = null;
    private DBInserter freeDBInserter = null;
    private ArrayList<List<Object>> memoryAllocDataList = new ArrayList();
    private ArrayList<List<Object>> memoryfreeDataList = new ArrayList();
    private List<TableInput> allocationTraceTreeInput = new ArrayList<TableInput>();
    private List<TableInput> statisticsTreeInput = new ArrayList<TableInput>();
    private List<List<Object>> preAllocDataList = new ArrayList<List<Object>>();
    private List<List<Object>> preFreeDataList = new ArrayList<List<Object>>();
    private HashSet<Long> addressMap = new HashSet();
    private List<Object> preQueryTime = new ArrayList<Object>();
    private Object lockAllocationCal = new Object();
    private Object lockStatisticsCal = new Object();

    public HeapDataManager() {
        this.allocateDBTable = new MemAllocDBTable();
        this.freeDBTable = new MemFreeDBTable();
        this.heapDBTable = new MemHeapDBTable();
        this.allocateDBInserter = this.makeInserter(this.allocateDBTable);
        this.freeDBInserter = this.makeInserter(this.freeDBTable);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add("");
    }

    public static HeapDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.memoryAllocDataList.clear();
        this.memoryfreeDataList.clear();
        this.addressMap.clear();
        this.allocationTraceTreeInput.clear();
        this.statisticsTreeInput.clear();
        this.preAllocDataList.clear();
        this.preFreeDataList.clear();
        this.preQueryTime.clear();
        this.preQueryTime.add(-1L);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add("");
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.REALLOC_ID = Global.getFunctionID("realloc");
        Logs allocatedlogs = this.getLogsFromLogPackage(pack, 257);
        this.makeHeapData(allocatedlogs);
    }

    public List<List<Object>> getHeapStaticData(long start, long end, String targetIds) {
        List<List<Object>> output = new ArrayList<List<Object>>();
        String where = this.getTimeWhereQuery(start, end, targetIds, MemHeapDBTable.COLUMN.CALL_TIME.name);
        List<List<Object>> queryResult = this.heapDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + MemHeapDBTable.COLUMN.SEQUENCE_NUMBER.name);
        if (queryResult == null) {
            return output;
        }
        output = queryResult;
        return output;
    }

    public List<List<Object>> getAllocationDataFromDB(long start, long end, String targetPIDs) {
        List<List<Object>> allocatedResult = new ArrayList<List<Object>>();
        String where = this.getTimeWhereQuery(start, end, targetPIDs, MemAllocDBTable.COLUMN.ALLOCATED_TIME.name);
        List<List<Object>> queryResult = this.allocateDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + MemAllocDBTable.COLUMN.SEQUENCE_NUMBER.name);
        if (queryResult == null) {
            return allocatedResult;
        }
        allocatedResult = queryResult;
        return allocatedResult;
    }

    public List<List<Object>> getFreeDataFromDB(long start, long end, String targetPIDs) {
        List<List<Object>> freeResult = new ArrayList<List<Object>>();
        String where = this.getTimeWhereQuery(start, end, targetPIDs, MemFreeDBTable.COLUMN.FREE_TIME.name);
        List<List<Object>> queryResult = this.freeDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + MemFreeDBTable.COLUMN.SEQUENCE_NUMBER.name);
        if (queryResult == null) {
            return freeResult;
        }
        freeResult = queryResult;
        return freeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeWholeAllocationTraceData() {
        if (DAState.isRunning()) {
            return;
        }
        List<List<Object>> allocDataList = null;
        String pidliststring = this.getTargetPIDString();
        allocDataList = this.remainedAllocatedListForRange(0L, 0L, pidliststring);
        if (allocDataList == null || allocDataList.size() == 0) {
            return;
        }
        int index = 0;
        int size = allocDataList.size();
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput alloInput = this.makeTreeInputForLeakData(iAllocData, index++);
            if (alloInput != null) {
                output.add(alloInput);
            }
            ++j;
        }
        Object object = this.lockAllocationCal;
        synchronized (object) {
            this.allocationTraceTreeInput = output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeWholeStatisticsData() {
        if (DAState.isRunning()) {
            return;
        }
        String pidliststring = this.getTargetPIDString();
        Map<Integer, List<Object>> staticdatas = this.remainedAllocStaticData(0L, 0L, pidliststring);
        long persistentSize = 0L;
        long persistentCount = 0L;
        long freecount = 0L;
        long totalSize = 0L;
        int index = 0;
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        for (Map.Entry<Integer, List<Object>> elem : staticdatas.entrySet()) {
            Long cfr_ignored_0 = (Long)elem.getValue().get(1);
            String apiName = Global.getLibraryName(elem.getKey());
            TableInput staticInput = this.makeTreeInputForDatas(apiName, elem.getValue(), index++);
            if (staticInput != null) {
                output.add(staticInput);
            }
            persistentSize += ((Long)elem.getValue().get(0)).longValue();
            persistentCount += ((Long)elem.getValue().get(1)).longValue();
            freecount += ((Long)elem.getValue().get(2)).longValue();
            totalSize += ((Long)elem.getValue().get(3)).longValue();
        }
        ArrayList<Object> total = new ArrayList<Object>();
        total.add(persistentSize);
        total.add(persistentCount);
        total.add(freecount);
        total.add(totalSize);
        total.add(persistentCount + freecount);
        TableInput totalInput = this.makeTreeInputForDatas("Total", total, index++);
        output.add(totalInput);
        Object object = this.lockStatisticsCal;
        synchronized (object) {
            this.statisticsTreeInput = output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableInput> getWholeAllocationTraceTreeInput() {
        List<TableInput> output = null;
        Object object = this.lockAllocationCal;
        synchronized (object) {
            if (this.allocationTraceTreeInput == null) {
                this.allocationTraceTreeInput = new ArrayList<TableInput>();
            }
            output = this.allocationTraceTreeInput;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableInput> getWholeStatisticsTreeInput() {
        List<TableInput> output = null;
        Object object = this.lockStatisticsCal;
        synchronized (object) {
            if (this.statisticsTreeInput == null) {
                this.statisticsTreeInput = new ArrayList<TableInput>();
            }
            output = this.statisticsTreeInput;
        }
        return output;
    }

    public Map<Integer, List<Object>> remainedAllocStaticData(long startTime, long endTime, String targetPIDs) {
        this.getAllocationFreeDatas(startTime, endTime, targetPIDs);
        Map<Integer, List<Object>> result = this.makeRemainedAllocatedStatic(this.preAllocDataList, this.preFreeDataList);
        return result;
    }

    public List<List<Object>> remainedAllocatedListForRange(long startTime, long endTime, String targetPIDs) {
        ArrayList<List<Object>> rangeDataList = new ArrayList<List<Object>>();
        this.getAllocationFreeDatas(startTime, endTime, targetPIDs);
        if (this.preAllocDataList != null) {
            if (this.preFreeDataList == null) {
                rangeDataList.addAll(this.preAllocDataList);
            } else {
                List<List<Object>> result = this.makeRemainedAllocatedList(this.preAllocDataList, this.preFreeDataList);
                if (result != null && !result.isEmpty()) {
                    rangeDataList.addAll(result);
                }
            }
        }
        return rangeDataList;
    }

    private Map<Integer, List<Object>> makeRemainedAllocatedStatic(List<List<Object>> allocData, List<List<Object>> freeData) {
        long address;
        HashMap addressMap = new HashMap();
        HashMap<Integer, List<Object>> libStatisticMap = new HashMap<Integer, List<Object>>();
        int allocDataSize = allocData.size();
        int j = 0;
        while (j < allocDataSize) {
            List<Object> iAllocData = allocData.get(j);
            address = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
            long allocSize = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.index);
            int binaryId = (Integer)iAllocData.get(MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            ArrayList<Number> onedata = new ArrayList<Number>();
            onedata.add(alloctime);
            onedata.add(allocSize);
            onedata.add(binaryId);
            ((List)addressMap.get(address)).add(onedata);
            if (libStatisticMap.containsKey(binaryId)) {
                List libstaticdata = (List)libStatisticMap.get(binaryId);
                libstaticdata.set(0, (Long)libstaticdata.get(0) + allocSize);
                libstaticdata.set(1, (Long)libstaticdata.get(1) + 1L);
                libstaticdata.set(3, (Long)libstaticdata.get(3) + allocSize);
                libStatisticMap.put(binaryId, libstaticdata);
            } else {
                ArrayList<Long> newbinary = new ArrayList<Long>();
                newbinary.add(allocSize);
                newbinary.add(1L);
                newbinary.add(0L);
                newbinary.add(allocSize);
                libStatisticMap.put(binaryId, newbinary);
            }
            ++j;
        }
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            address = (Long)iFreeData.get(MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.COLUMN.FREE_TIME.index);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int removeindex = 0;
                while (removeindex < size) {
                    List onedata = (List)((List)addressMap.get(address)).get(removeindex);
                    if ((Long)onedata.get(0) <= freetime) {
                        long freeSize = (Long)onedata.get(1);
                        int binaryId = (Integer)onedata.get(2);
                        if (libStatisticMap.containsKey(binaryId)) {
                            List libstaticdata = (List)libStatisticMap.get(binaryId);
                            libstaticdata.set(0, (Long)libstaticdata.get(0) - freeSize);
                            libstaticdata.set(1, (Long)libstaticdata.get(1) - 1L);
                            libstaticdata.set(2, (Long)libstaticdata.get(2) + 1L);
                            libStatisticMap.put(binaryId, libstaticdata);
                        }
                        ((List)addressMap.get(address)).remove(removeindex);
                        break;
                    }
                    ++removeindex;
                }
            }
            ++i;
        }
        return libStatisticMap;
    }

    private List<List<Object>> makeRemainedAllocatedList(List<List<Object>> allocData, List<List<Object>> freeData) {
        HashMap addressMap = new HashMap();
        ArrayList<List<Object>> output = new ArrayList<List<Object>>();
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.COLUMN.FREE_TIME.index);
            long address = (Long)iFreeData.get(MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            ((List)addressMap.get(address)).add(freetime);
            ++i;
        }
        int allocDataSize = allocData.size();
        int i2 = 0;
        while (i2 < allocDataSize) {
            List<Object> iAllocData = allocData.get(i2);
            boolean live = true;
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
            long address = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int j = 0;
                while (j < size) {
                    Long freetime = (Long)((List)addressMap.get(address)).get(j);
                    if (alloctime <= freetime) {
                        live = false;
                        ((List)addressMap.get(address)).remove(j);
                        break;
                    }
                    ++j;
                }
            }
            if (live) {
                output.add(iAllocData);
            }
            ++i2;
        }
        return output;
    }

    public TableInput makeTreeInputForDatas(String path, List<Object> staticdata, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (staticdata == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        String libname = path;
        if (path == Global.getProject().getApplicationInfo().getExecPath()) {
            libname = MemoryPageLabels.MEMORY_MAIN_EXCUTABLE;
        }
        text.add(libname);
        data.add(libname);
        Long PByte = (Long)staticdata.get(0);
        text.add(Formatter.toByteFormat(PByte));
        data.add(PByte);
        Long PCount = (Long)staticdata.get(1);
        text.add(String.format("%,d", PCount));
        data.add(PCount);
        Long FCount = (Long)staticdata.get(2);
        text.add(String.format("%,d", FCount));
        data.add(FCount);
        Long TotalByte = (Long)staticdata.get(3);
        text.add(Formatter.toByteFormat(TotalByte));
        data.add(TotalByte);
        Long TotalCount = PCount + FCount;
        text.add(String.format("%,d", TotalCount));
        data.add(TotalCount);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }

    public TableInput makeTreeInputForLeakData(List<Object> allocData, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (allocData == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        Long seq = (Long)allocData.get(MemAllocDBTable.COLUMN.SEQUENCE_NUMBER.index);
        text.add(Long.toString(seq));
        data.add(seq);
        long time = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
        data.add(time);
        try {
            text.add(Formatter.toTimeFormat(time));
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            text.add(Long.toString(time));
        }
        text.add("O");
        data.add("O");
        Long address = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
        text.add("0x" + Long.toHexString(address));
        data.add(address);
        Long size = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.index);
        text.add(Long.toString(size));
        data.add(size);
        String libName = Global.getLibraryName((Integer)allocData.get(MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.index));
        if (libName == null || libName.isEmpty()) {
            libName = "unknown";
        }
        text.add(libName);
        data.add(libName);
        int apiId = (Integer)allocData.get(MemAllocDBTable.COLUMN.API_ID.index);
        String apiName = Global.getFunctionName(apiId);
        text.add(apiName);
        data.add(apiName);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        String pidliststring = "(";
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring = String.valueOf(pidliststring) + Integer.toString((Integer)pidlist.get(i));
            if (i != pidlist.size() - 1) {
                pidliststring = String.valueOf(pidliststring) + ", ";
            }
            ++i;
        }
        pidliststring = String.valueOf(pidliststring) + ")";
        return pidliststring;
    }

    private Logs getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        return logs;
    }

    private void makeHeapData(Logs alloclogs) {
        List<LogData> memoryLogList;
        List<LogData> list = memoryLogList = alloclogs == null ? null : alloclogs.getRawLogs();
        if (memoryLogList == null) {
            return;
        }
        Collections.sort(memoryLogList, new AscCompare());
        int size = memoryLogList.size();
        int i = 0;
        while (i < size) {
            MemoryData logData = (MemoryData)memoryLogList.get(i);
            long errorNo = logData.getErrno();
            if (errorNo == 0L) {
                int memApiType = logData.getMemoryApiType();
                int pid = logData.getPid();
                long calleraddress = logData.getCallerPcAddr();
                int binaryid = Global.getBinaryID(pid, logData.getTime(), calleraddress);
                if (memApiType == 0) {
                    this.makeAllocData(logData, binaryid);
                } else if (1 == memApiType) {
                    this.makeFreeData(logData, binaryid);
                }
            }
            ++i;
        }
        if (this.memoryAllocDataList.size() > 0) {
            List mList = (List)this.memoryAllocDataList.clone();
            this.memoryAllocDataList.clear();
            this.allocateDBInserter.pushData(mList);
        }
        if (this.memoryfreeDataList.size() > 0) {
            List fList = (List)this.memoryfreeDataList.clone();
            this.memoryfreeDataList.clear();
            this.freeDBInserter.pushData(fList);
        }
    }

    private void makeAllocData(MemoryData mData, int binaryid) {
        ArrayList<Number> dbAllocData = new ArrayList<Number>();
        int pid = mData.getPid();
        long address = mData.getAddress();
        long mallocsize = mData.getSize();
        if (this.REALLOC_ID == mData.getApiId()) {
            try {
                Long freeaddress = Long.parseLong(mData.getArgs().replace("0x", "").split(",")[0], 16);
                this.makeFreeData(mData, freeaddress, binaryid);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning((String)"realloc address invalide : %s", (Object[])new Object[]{mData.getArgs()});
            }
        }
        dbAllocData.add(mData.getSeq());
        dbAllocData.add(pid);
        dbAllocData.add(mData.getApiId());
        dbAllocData.add(mData.getMemoryApiType());
        dbAllocData.add(address);
        dbAllocData.add(mData.getTime());
        dbAllocData.add(mData.getCallerPcAddr());
        dbAllocData.add(binaryid);
        dbAllocData.add(mData.getMsgID());
        dbAllocData.add(mallocsize);
        this.memoryAllocDataList.add(dbAllocData);
    }

    private void makeFreeData(MemoryData mData, int binaryid) {
        this.makeFreeData(mData, mData.getAddress(), binaryid);
    }

    private void makeFreeData(MemoryData mData, Long address, int binaryid) {
        ArrayList<Number> dbFreeData = new ArrayList<Number>();
        int pid = mData.getPid();
        dbFreeData.add(mData.getSeq());
        dbFreeData.add(pid);
        dbFreeData.add(mData.getMsgID());
        dbFreeData.add(mData.getTime());
        dbFreeData.add(address);
        dbFreeData.add(binaryid);
        this.memoryfreeDataList.add(dbFreeData);
    }

    private String getTimeWhereQuery(long start, long end, String targetIds, String timecolumn) {
        String where = "WHERE";
        if (start != 0L || end != 0L) {
            where = String.valueOf(where) + String.format(" %s BETWEEN %s AND %s AND", timecolumn, Long.toString(start), Long.toString(end));
        }
        where = String.valueOf(where) + String.format(" PID IN %s", targetIds);
        return where;
    }

    private void getAllocationFreeDatas(long start, long end, String targetIds) {
        if ((Long)this.preQueryTime.get(0) == start && (Long)this.preQueryTime.get(1) == end && ((String)this.preQueryTime.get(2)).equals(targetIds)) {
            return;
        }
        this.preAllocDataList = HeapDataManager.getInstance().getAllocationDataFromDB(start, end, targetIds);
        this.preFreeDataList = HeapDataManager.getInstance().getFreeDataFromDB(start, end, targetIds);
        this.preQueryTime.set(0, start);
        this.preQueryTime.set(1, end);
        this.preQueryTime.set(2, targetIds);
    }

    private static class AscCompare
    implements Comparator<LogData> {
        private AscCompare() {
        }

        @Override
        public int compare(LogData arg0, LogData arg1) {
            return Long.valueOf(arg0.getSeq()).compareTo(arg1.getSeq());
        }
    }
}

