/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;

public class MemoryMapTable
extends DATableComposite {
    private int[] columnSizes = new int[]{40, 60, 150, 80, 80, 5};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] columnAlignment = new int[]{0x1000000, 131072, 16384, 131072, 131072, 16384};
    private String[] columnNames = new String[]{MemoryPageLabels.MEMORY_MEMORYMAP_TYPE, MemoryPageLabels.MEMORY_MEMORYMAP_SIZE, MemoryPageLabels.MEMORY_MEMORYMAP_LIBNAME, MemoryPageLabels.MEMORY_MEMORYMAP_ADDRESS_LOW, MemoryPageLabels.MEMORY_MEMORYMAP_ADDRESS_HIGH, ""};
    int[] sortTypes;

    public MemoryMapTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        this.sortTypes = nArray;
        this.setTableName(MemoryPageLabels.MEMORY_MAP_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.setTableToolTipEnable(false);
        this.comparator.setType(1);
        this.comparator.setColumn(1);
        this.comparator.setDirection(false);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, this.columnSizes));
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        if (Global.getProject() == null) {
            return output;
        }
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        Project project = Global.getProject();
        int index = 0;
        int i = 0;
        while (i < pidlist.size()) {
            ProcessMemoryMap pmap = project.getProcessInformation((Integer)pidlist.get(i)).getLastProcessMemoryMap();
            Map<Integer, LibraryObject> binarymap = pmap.getAllLibraryID();
            for (Map.Entry<Integer, LibraryObject> entry : binarymap.entrySet()) {
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(entry.getValue().getBinaryID()).getTargetBinaryPath();
                TableInput mapInput = this.makeTreeInput(binPath, entry.getValue().getLowestAddress(), entry.getValue().getHighestAddress(), index++);
                if (mapInput == null || output.contains(mapInput)) continue;
                output.add(mapInput);
            }
            ++i;
        }
        return output;
    }

    private TableInput makeTreeInput(String binarypath, long low, long high, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        Long Low = low;
        Long High = high;
        Long size = High - Low;
        text.add("r-x-");
        data.add("r-x-");
        text.add(Long.toString(size));
        data.add(size);
        text.add(binarypath);
        data.add(binarypath);
        text.add("0x" + Long.toHexString(Low));
        data.add(Low);
        text.add("0x" + Long.toHexString(High));
        data.add(High);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }
}

