/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.NetworkPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.network.NetworkTable;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSelectionType;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class NetworkAPIListView
extends DAAdvancedViewComposite {
    public static final String ID = NetworkAPIListView.class.getName();
    private long preAnalysisStartTime = 0L;
    private long preAnalysisEndTime = 0L;
    private boolean isChangedSelected = true;
    private int preSelectionPId = 1;
    NetworkSelectionType netSelection = null;
    private String[] columnNames = new String[]{NetworkPageLabels.NETWORK_API_LIST_VIEW_INDEX, NetworkPageLabels.NETWORK_API_LIST_VIEW_START_TIME, NetworkPageLabels.NETWORK_API_LIST_VIEW_ELAPSED_TIME, NetworkPageLabels.NETWORK_API_LIST_VIEW_PID, NetworkPageLabels.NETWORK_API_LIST_VIEW_THREAD_ID, NetworkPageLabels.NETWORK_API_LIST_VIEW_API, NetworkPageLabels.NETWORK_API_LIST_VIEW_PARAMETER, NetworkPageLabels.NETWORK_API_LIST_VIEW_RETURN, NetworkPageLabels.NETWORK_API_LIST_VIEW_BYTE_SIZE, NetworkPageLabels.NETWORK_API_LIST_VIEW_MESSAGE, NetworkPageLabels.NETWORK_API_LIST_VIEW_ERRNO};
    private int[] columnSizes = new int[]{40, 70, 100, 40, 40, 200, 100, 70, 100, 100, 100};
    private int[] columnAlignment = new int[]{131072, 131072, 131072, 131072, 131072, 16384, 16384, 16384, 131072, 131072, 16384};
    int[] sortTypes = new int[]{1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2};
    NetworkTable tableComp = null;

    public NetworkAPIListView(Composite parent, int style) {
        super(parent, style, false, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(NetworkPageLabels.NETWORK_API_LIST_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new NetworkTable(contents, 0, 68354);
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.tableComp.setTableName(NetworkPageLabels.NETWORK_API_LIST_VIEW_TITLE);
        contents.addControlListener((ControlListener)new TableColumnSizePackListener(this.tableComp, this.columnSizes));
        this.setTable(this.tableComp);
    }

    public void updateView() {
        if (this.tableComp == null || this.netSelection == null) {
            return;
        }
        if (this.isUpdateTable()) {
            this.tableComp.updateTable();
        }
    }

    private boolean isUpdateTable() {
        boolean isUpdate = false;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPId == selectedPid) {
            isUpdate = true;
        }
        this.preSelectionPId = selectedPid;
        long newAnalysisStartTime = 0L;
        long newAnalysisEndTime = 0L;
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            newAnalysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
            newAnalysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
        } else {
            newAnalysisStartTime = 0L;
            newAnalysisEndTime = 0L;
        }
        if (newAnalysisStartTime != this.preAnalysisStartTime || newAnalysisEndTime != this.preAnalysisEndTime) {
            this.preAnalysisStartTime = newAnalysisStartTime;
            this.preAnalysisEndTime = newAnalysisEndTime;
            isUpdate = true;
        }
        if (this.isChangedSelected) {
            this.isChangedSelected = false;
            isUpdate = true;
        }
        return isUpdate;
    }

    public void updateView(DAViewData data) {
        try {
            if (data instanceof DASelectionData) {
                DASelectionData selData = (DASelectionData)data;
                long selectionStartTime = selData.getStartTime();
                long selectionEndTime = selData.getEndTime();
                if (!(selData.getData() instanceof NetworkSelectionType)) {
                    return;
                }
                this.netSelection = (NetworkSelectionType)selData.getData();
                if (this.netSelection == null) {
                    return;
                }
                NetworkDataManager.getInstance().setSelectedData(this.netSelection);
                NetworkDataManager.getInstance().setSelectedTableAPIList(NetworkDataManager.getInstance().getAPIDBManger().selectAPITable(this.netSelection.getAddress(), this.netSelection.getFd(), this.netSelection.isParentChart(), null));
                this.tableComp.updateTable();
                this.tableComp.setSelectionByTime(selectionStartTime, selectionEndTime);
                this.isChangedSelected = true;
            }
        }
        catch (Exception exception) {
            Logger.error((Object)"exception network updateView(DAViewData data)");
        }
    }

    public Control getControl() {
        return this.tableComp;
    }

    public void clear() {
        this.tableComp.getTable().removeAll();
        this.netSelection = null;
    }

    public long getRangeStartTime() {
        return this.preAnalysisStartTime;
    }

    public long getRangeEndTime() {
        return this.preAnalysisEndTime;
    }

    public static enum COLUMN {
        INDEX(0, NetworkPageLabels.NETWORK_API_LIST_VIEW_INDEX),
        START_TIME(1, NetworkPageLabels.NETWORK_API_LIST_VIEW_START_TIME),
        ELASPSED_TIME(2, NetworkPageLabels.NETWORK_API_LIST_VIEW_ELAPSED_TIME),
        PID(3, NetworkPageLabels.NETWORK_API_LIST_VIEW_PID),
        TID(4, NetworkPageLabels.NETWORK_API_LIST_VIEW_THREAD_ID),
        API(5, NetworkPageLabels.NETWORK_API_LIST_VIEW_API),
        PARAMETER(6, NetworkPageLabels.NETWORK_API_LIST_VIEW_PARAMETER),
        RETURN(7, NetworkPageLabels.NETWORK_API_LIST_VIEW_RETURN),
        BYTE_SIZE(8, NetworkPageLabels.NETWORK_API_LIST_VIEW_BYTE_SIZE),
        MESSAGE(9, NetworkPageLabels.NETWORK_API_LIST_VIEW_MESSAGE),
        ERRNO(10, NetworkPageLabels.NETWORK_API_LIST_VIEW_ERRNO);

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

