/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.error.ErrorCodeManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.network.NetworkAPIListView;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSelectionType;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAApiListTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class NetworkTable
extends DAApiListTableComposite {
    public NetworkTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = NetworkTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                long startTime = 0L;
                long endTime = 0L;
                DATableDataFormat dataFormat = null;
                int i = 0;
                while (i < items.length) {
                    dataFormat = (DATableDataFormat)items[i].getData();
                    long itemTime = dataFormat.getLogData().getTime();
                    if (0L == startTime) {
                        startTime = itemTime;
                    }
                    if (startTime > itemTime) {
                        startTime = itemTime;
                    }
                    if (endTime < itemTime) {
                        endTime = itemTime;
                    }
                    ++i;
                }
                DASelectionData selData = new DASelectionData(NetworkAPIListView.ID, startTime, endTime, items, (Control)NetworkTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = Long.parseLong((String)markerData.get(1));
                AnalyzerUtil.addMarker(markerTime);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<TableInput> makeTableInput() {
        NetworkAPIListView view = (NetworkAPIListView)AnalyzerManager.getCurrentPage().getView(NetworkAPIListView.ID);
        if (view == null) {
            return null;
        }
        List<FilterProperty> filterList = this.getFilterPropertyList();
        List<NetworkAPIType> contentList = null;
        NetworkSelectionType selectedData = NetworkDataManager.getInstance().getSelectedData();
        if (!filterList.isEmpty()) {
            List<String> whereClause = this.convertFilterProperty2Query(filterList);
            contentList = NetworkDataManager.getInstance().getAPIDBManger().selectAPITable(selectedData.getAddress(), selectedData.getFd(), selectedData.isParentChart(), whereClause);
        } else {
            contentList = NetworkDataManager.getInstance().getAPIDBManger().selectAPITable(selectedData.getAddress(), selectedData.getFd(), selectedData.isParentChart(), null);
        }
        if (contentList == null) {
            return null;
        }
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        LinkedHashMap<String, Integer> findStartAPITableIndexHashMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<Integer, Long> findStartTimeMap = new LinkedHashMap<Integer, Long>();
        int i = 0;
        while (i < contentList.size()) {
            block22: {
                NetworkAPIType contentTemp = contentList.get(i);
                int selectedPid = Toolbar.INSTANCE.getSelectedPid();
                if (selectedPid != contentTemp.getPid()) {
                    String elapsedTime = "";
                    String strStartTime = "";
                    String byteSize = "";
                    String apiName = contentTemp.getApiName();
                    String argument = contentTemp.getArgs();
                    String returnValue = contentTemp.getReturn();
                    String payload = this.getPayload(contentTemp);
                    String errMessage = this.getErrorMessage(contentTemp);
                    String apiType = Integer.toString(contentTemp.getFdApiType());
                    String key = this.apiEqualsKey(contentTemp);
                    if (this.isStartAPI(apiType)) {
                        findStartAPITableIndexHashMap.put(key, i);
                        findStartTimeMap.put(i, contentTemp.getTime());
                    } else {
                        if (this.isEndAPI(apiType)) {
                            int startIndex = (Integer)findStartAPITableIndexHashMap.get(key);
                            long startTime = (Long)findStartTimeMap.get(startIndex);
                            strStartTime = Formatter.toTimeFormat(startTime);
                            String timeFormat = Formatter.toTimeFormat(contentTemp.getTime() - startTime);
                            elapsedTime = timeFormat.replace("00:", "");
                            byteSize = this.getMessageSize(contentTemp);
                            findStartAPITableIndexHashMap.remove(key);
                            findStartTimeMap.remove(startIndex);
                        } else {
                            strStartTime = Formatter.toTimeFormat(contentTemp.getTime());
                            elapsedTime = "00.000";
                        }
                        int j = 0;
                        while (j < filterList.size()) {
                            switch (filterList.get(j).getColumnIndex()) {
                                case 1: {
                                    if (strStartTime.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 2: {
                                    if (elapsedTime.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 5: {
                                    if (apiName.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 6: {
                                    if (argument.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 7: {
                                    if (returnValue.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 8: {
                                    if (byteSize.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 9: {
                                    if (payload.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                                    break block22;
                                }
                                case 10: {
                                    if (!errMessage.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break block22;
                                }
                            }
                            ++j;
                        }
                        ArrayList<String> contentText = new ArrayList<String>();
                        contentText.add(Long.toString(contentTemp.getSeq()));
                        contentText.add(strStartTime);
                        contentText.add(elapsedTime);
                        contentText.add(Integer.toString(contentTemp.getPid()));
                        contentText.add(Integer.toString(contentTemp.getTid()));
                        contentText.add(contentTemp.getApiName());
                        contentText.add(contentTemp.getArgs());
                        contentText.add(returnValue);
                        contentText.add(byteSize);
                        contentText.add(payload);
                        contentText.add(errMessage);
                        DATableDataFormat tableData = new DATableDataFormat(contentTemp.getSeq());
                        tableData.setLogData(contentTemp);
                        tableData.getData().addAll(this.getCompareData(contentText, contentTemp));
                        TableInput tableInput = new TableInput();
                        tableInput.setText(contentText);
                        tableInput.setData(tableData);
                        tableInput.setFailed(this.setFailed(contentTemp));
                        input.add(tableInput);
                        tableInput.setInRange(this.setRange(contentTemp, view));
                    }
                }
            }
            ++i;
        }
        return input;
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 3: {
                columnName = "PID";
                break;
            }
            case 4: {
                columnName = "TID";
                break;
            }
        }
        return columnName;
    }

    @Override
    public boolean[] getColumnVisibility() {
        if (this.table == null) {
            return null;
        }
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        boolean[] columnsVisibility = new boolean[size];
        int i = 1;
        while (i < size) {
            columnsVisibility[i] = columns[i].getVisible();
            ++i;
        }
        return columnsVisibility;
    }

    private boolean isStartAPI(String fdApiType) {
        return fdApiType.equals(Integer.toString(2)) || fdApiType.equals(Integer.toString(4)) || fdApiType.equals(Integer.toString(9)) || fdApiType.equals(Integer.toString(11));
    }

    private boolean isEndAPI(String fdApiType) {
        return fdApiType.equals(Integer.toString(3)) || fdApiType.equals(Integer.toString(5)) || fdApiType.equals(Integer.toString(10)) || fdApiType.equals(Integer.toString(12));
    }

    private List<String> getCompareData(List<String> contentText, NetworkAPIType contentTemp) {
        ArrayList<String> contentData = new ArrayList<String>();
        int j = 0;
        while (j < contentText.size()) {
            if (j == NetworkAPIListView.COLUMN.START_TIME.ordinal()) {
                contentData.add(Long.toString(contentTemp.getTime()));
            } else if (j == NetworkAPIListView.COLUMN.ELASPSED_TIME.ordinal()) {
                contentData.add("0");
            } else {
                contentData.add(contentText.get(j));
            }
            ++j;
        }
        return contentData;
    }

    private String apiEqualsKey(NetworkAPIType contentTemp) {
        return String.valueOf(Global.getFunctionName(contentTemp.getApiId())) + contentTemp.getPid() + contentTemp.getTid();
    }

    private String getMessageSize(NetworkAPIType contentTemp) {
        int apiType = contentTemp.getFdApiType();
        if (apiType == 5 || apiType == 3 || apiType == 20 || apiType == 21) {
            return Integer.toString(contentTemp.getPacketMessageSize());
        }
        return "";
    }

    private String getPayload(NetworkAPIType contentTemp) {
        StringBuffer payloadInfo = new StringBuffer(contentTemp.getPacketMessage());
        if (payloadInfo.length() > 20) {
            payloadInfo.replace(10, payloadInfo.length(), "");
            payloadInfo.insert(payloadInfo.length(), "...");
        }
        return payloadInfo.toString();
    }

    private String getErrorMessage(NetworkAPIType contentTemp) {
        String errMsg = ErrorCodeManager.getInatance().getErrorCode(Long.toString(contentTemp.getErrno()));
        if (errMsg == null) {
            errMsg = "undefined error code";
        }
        return errMsg;
    }

    private boolean setFailed(NetworkAPIType contentTemp) {
        return !this.getErrorMessage(contentTemp).contains("SUCCESS");
    }

    private boolean setRange(NetworkAPIType contentTemp, NetworkAPIListView view) {
        long rangeStartTime = view.getRangeStartTime();
        long rangeEndTime = view.getRangeEndTime();
        long time = contentTemp.getTime();
        return time >= rangeStartTime && time <= rangeEndTime;
    }
}

