/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network.data.type;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.swap.model.data.NetworkData;

public class NetworkAPIType
extends NetworkData {
    private String destinationAddress = "";
    private String fdStr = "";
    private int binaryId = 0;

    public NetworkAPIType() {
    }

    public NetworkAPIType(long sequenceNumber, String destinationAddress, String fdValue, long apiTime, int apiNameID, long errno, int pID, int tID, String arg, String returnValue, int byteSize, String payLoad, int apiType, long callerAddress, String libName) {
        this.setSeq(sequenceNumber);
        this.setDestinationAddress(destinationAddress);
        this.setFdStr(fdValue);
        this.setTime(apiTime);
        this.setApiId(apiNameID);
        this.setErrNo(errno);
        this.setPid(pID);
        this.setTid(tID);
        this.setArgs(arg);
        this.setReturn(returnValue);
        this.setPacketMessageSize(byteSize);
        this.setPacketMessage(payLoad);
        this.setFdApiType(apiType);
        this.setCallerAddress(callerAddress);
        this.setBinaryID(libName);
    }

    @Override
    public String getDestinationAddress() {
        return this.destinationAddress.trim();
    }

    public void setDestinationAddress(String destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public String getFdStr() {
        return this.fdStr.trim();
    }

    public void setFdStr(String fdValue) {
        this.fdStr = fdValue;
    }

    public void setPacketMessageSize(int byteSize) {
        this.messageSize = byteSize;
    }

    public void setPacketMessage(String payload) {
        this.packetMessage = payload;
    }

    @Override
    public void setFdApiType(int apiType) {
        this.fdApiType = apiType;
    }

    public int getBinaryId() {
        return this.binaryId;
    }

    public void setBinaryId(int binaryId) {
        this.binaryId = binaryId;
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(this.getBinaryId());
        this.libName = binInfo.getTargetBinaryPath();
    }

    public void setBinaryID(String binaryPath) {
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryPath);
        this.binaryId = binInfo.getID();
        this.libName = binInfo.getTargetBinaryPath();
    }

    public List<Object> getDBInsertData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.getSeq());
        data.add(this.getDestinationAddress());
        data.add(this.getFdStr());
        data.add(this.getTime());
        data.add(this.getApiId());
        data.add(this.getErrno());
        data.add(this.getPid());
        data.add(this.getTid());
        data.add(this.getArgs());
        data.add(this.getReturn());
        data.add(this.getPacketMessageSize());
        data.add(this.getPacketMessage());
        data.add(this.getFdApiType());
        data.add(this.getCallerPcAddr());
        data.add(this.getBinaryId());
        return data;
    }
}

