/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.GLExtractUniformDataMaker;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLBufferSizeType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLCurrentFrameDataManger;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLES20ErrorDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateShaderType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLDetailsView
extends DAViewComposite {
    private final String PROGRAM_PUNCTUATION = "#";
    private Composite contents = null;
    private StyledText detailText;
    private static final String leftFormAttachment = "  ";
    private static final String heightFormAttachment = "\n\n";
    private GLExtractUniformDataMaker uniformDataMaker = new GLExtractUniformDataMaker();
    private long preSelectedContextId = -1L;
    private ExtendedModifyListener programExtendedModifyListener = new ExtendedModifyListener(){

        public void modifyText(ExtendedModifyEvent event) {
            int end = event.start + event.length - 1;
            if (event.start > end) {
                return;
            }
            String text = GLDetailsView.this.detailText.getText(event.start, end);
            String[] lineStr = text.split("\n");
            int lineSize = lineStr.length;
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            ArrayList<String> containChar = new ArrayList<String>();
            int i = 0;
            while (i < lineSize) {
                String lineText = lineStr[i];
                if (lineText.contains("#")) {
                    containChar.add(lineText);
                }
                ++i;
            }
            int containCharIndex = 0;
            int i2 = 0;
            int n = text.length();
            while (i2 < n) {
                if (containCharIndex > 2) break;
                if ("#".indexOf(text.charAt(i2)) > -1) {
                    ranges.add(new StyleRange(event.start + i2, ((String)containChar.get(containCharIndex)).length(), ColorResources.NAVY, null, 2));
                    ++containCharIndex;
                }
                ++i2;
            }
            if (ranges.isEmpty()) {
                return;
            }
            GLDetailsView.this.detailText.replaceStyleRanges(event.start, event.length, ranges.toArray(new StyleRange[0]));
        }
    };

    private void init() {
        this.detailText.setText("");
    }

    public GLDetailsView(Composite parent, int style) {
        super(parent, style, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(GLPageLabels.GL_DETAILS_VIEW_TITLE);
        Composite detailCom = this.getContentArea();
        detailCom.setBackground(ColorResources.VIEW_BG_COLOR);
        detailCom.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.bottom = new FormAttachment(100, 0);
        detailCom.setLayoutData((Object)labelData);
        Composite contents = detailCom;
        contents.setBackground(ColorResources.VIEW_BG_COLOR);
        contents.setLayout((Layout)new FormLayout());
        this.detailText = new StyledText(contents, 2824);
        this.detailText.setBackground(ColorResources.VIEW_BG_COLOR);
        this.detailText.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.detailText.setFont(FontResources.DETAIL_INFO_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 0);
        buttonData.left = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.detailText.setLayoutData((Object)buttonData);
    }

    public void updateView() {
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof GLSelectionData)) {
            return;
        }
        GLSelectionData data = (GLSelectionData)vdata;
        String id = vdata.getViewID();
        this.setContextIDForChart(data);
        if (id.equals(GLPage.chartViewID)) {
            this.updateTableInfo(data);
        } else if (id.equals(GLPage.apiListViewID)) {
            this.updateAPITableInfo(data);
        } else if (id.equals(GLPage.contextViewID)) {
            this.updateContextTableInfo(data);
        } else if (id.equals(GLPage.programViewID)) {
            this.updateProgramTableInfo(data);
        } else if (id.equals(GLPage.redundantViewID)) {
            this.updateRedundantTableInfo(data);
        } else if (id.equals(GLPage.statisticsViewID)) {
            this.updateStatisticsTableInfo(data);
        }
    }

    private void setContextIDForChart(GLSelectionData data) {
        if (data.getContextId() > -1L) {
            this.preSelectedContextId = data.getContextId();
        } else {
            data.setContextId(this.preSelectedContextId);
        }
    }

    private void updateTableInfo(GLSelectionData data) {
        List<GLAPIData> apiList = GLDataManager.getInstance().getCurrentAPITableData();
        if (apiList == null || apiList.size() == 0) {
            return;
        }
        GLCurrentFrameDataManger glFrameData = new GLCurrentFrameDataManger();
        for (GLAPIData listItem : apiList) {
            glFrameData.addAPIData(listItem);
        }
        StringBuffer strDetailView = new StringBuffer();
        strDetailView.append("\n");
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_FRAME + this.getSelectedFrameIndex(data) + heightFormAttachment);
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_ELAPSED_TIME + glFrameData.getFrametime() + "(\ufffd\ufffds)" + heightFormAttachment);
        strDetailView.append(leftFormAttachment + glFrameData.getAPIDataList().size() + GLPageLabels.GL_DETAILS_VIEW_ELAPSED_TIME_APIS + heightFormAttachment);
        strDetailView.append(leftFormAttachment + glFrameData.getErrorCount() + GLPageLabels.GL_DETAILS_VIEW_ELAPSED_TIME_ERROR + heightFormAttachment);
        strDetailView.append(this.printBufferSize(data.getContextId(), glFrameData.getEndSeq()));
        this.detailText.setText(strDetailView.toString());
    }

    private String printBufferSize(long contextID, long selectedSeq) {
        if (contextID < 0L) {
            return "";
        }
        StringBuffer strDetailView = new StringBuffer();
        GLBufferSizeType bufferData = GLDataManager.getInstance().getBufferSizeDBTable().getBufferSize(contextID, selectedSeq);
        if (bufferData == null) {
            return "";
        }
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_ARRAY_BUFFER_SIZE + bufferData.getArraryMemorySize() + heightFormAttachment);
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_ARRAY_BUFFER_USAGE + bufferData.getArraryUsageSize() + heightFormAttachment);
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_ELEMENT_ARRAY_BUFFER_SIZE + bufferData.getElementArraryMemorySize() + heightFormAttachment);
        strDetailView.append(leftFormAttachment + GLPageLabels.GL_DETAILS_VIEW_ELEMENT_ARRAY_BUFFER_USAGE + bufferData.getElementArraryUsageSize() + heightFormAttachment);
        return strDetailView.toString();
    }

    private String getSelectedFrameIndex(GLSelectionData data) {
        int endFrameIndex;
        int startFrameIndex = data.getFrameTimeIndex();
        if (startFrameIndex == (endFrameIndex = data.getSecondFrameIndex())) {
            return String.valueOf(startFrameIndex);
        }
        return String.format("%d - %d", startFrameIndex, endFrameIndex);
    }

    private void updateAPITableInfo(GLSelectionData data) {
        GridItem[] gridItems = (GridItem[])data.getData();
        DATableDataFormat tableDataFormat = (DATableDataFormat)gridItems[0].getData();
        GLES20LogData logData = (GLES20LogData)tableDataFormat.getLogData();
        StringBuffer strDetailView = new StringBuffer();
        strDetailView.append(this.getDetailInfoOfAPI(logData.getApiName(), logData.getErrno(), logData.getArgs()));
        strDetailView.append(this.printBufferSize(data.getContextId(), logData.getSeq()));
        this.detailText.setText(strDetailView.toString());
    }

    private void updateRedundantTableInfo(GLSelectionData data) {
        GridItem[] gridItems = (GridItem[])data.getData();
        DATableDataFormat tableDataFormat = (DATableDataFormat)gridItems[0].getData();
        this.detailText.setText(this.getDetailInfoOfAPI((String)tableDataFormat.getData().get(2), 0L, (String)tableDataFormat.getData().get(3)));
    }

    private void updateStatisticsTableInfo(GLSelectionData data) {
        GridItem[] gridItems = (GridItem[])data.getData();
        DATableDataFormat tableDataFormat = (DATableDataFormat)gridItems[0].getData();
        StringBuffer strDetailView = new StringBuffer();
        strDetailView.append("\n");
        strDetailView.append(leftFormAttachment + (String)tableDataFormat.getData().get(0) + heightFormAttachment);
        strDetailView.append(leftFormAttachment + (String)tableDataFormat.getData().get(3) + heightFormAttachment);
        this.detailText.setText(strDetailView.toString());
    }

    private String getDetailInfoOfAPI(String apiName, long error, String args) {
        StringBuffer strDetailView = new StringBuffer();
        strDetailView.append("\n");
        strDetailView.append(leftFormAttachment + apiName + heightFormAttachment);
        if (error == 0L) {
            strDetailView.append(leftFormAttachment + GLES20ErrorDefine.getErrorDescription(String.valueOf(error)) + heightFormAttachment);
        } else {
            strDetailView.append(leftFormAttachment + this.getErrorDescription(apiName, GLES20ErrorDefine.getError(error)) + heightFormAttachment);
        }
        if (!this.uniformDataMaker.isUniformAPI(apiName)) {
            return strDetailView.toString();
        }
        String uniformValue = this.uniformDataMaker.getUniformData(apiName, args);
        if (uniformValue != null) {
            strDetailView.append("  #uniform value\n\n");
            strDetailView.append(String.valueOf(this.uniformDataMaker.getUniformData(apiName, args)) + heightFormAttachment);
        }
        return strDetailView.toString();
    }

    private void updateContextTableInfo(GLSelectionData data) {
        StringBuffer strDetailView = new StringBuffer();
        GridItem[] items = (GridItem[])data.getData();
        if (items == null) {
            return;
        }
        strDetailView.append("\n");
        strDetailView.append(leftFormAttachment + items[0].getText(0) + heightFormAttachment);
        this.detailText.setText(strDetailView.toString());
    }

    private void updateProgramTableInfo(GLSelectionData data) {
        this.detailText.addExtendedModifyListener(this.programExtendedModifyListener);
        GridItem[] items = (GridItem[])data.getData();
        if (items == null) {
            return;
        }
        String contextId = items[0].getText(1);
        if (contextId.contains(GLPageLabels.GL_CONTEXT)) {
            contextId = contextId.replace(String.valueOf(GLPageLabels.GL_CONTEXT) + "_", "");
        }
        String vertexShaderID = items[0].getText(2).replace(GLPageLabels.GL_SHADER, "").trim();
        String fragmentID = items[0].getText(3).replace(GLPageLabels.GL_SHADER, "").trim();
        String vertexSrc = "";
        String fragmentSrc = "";
        List<GLStateShaderType> shaderList = GLDataManager.getInstance().getStateDataManager().getProgramMakeObject().getShaderList();
        int i = 0;
        while (i < shaderList.size()) {
            if (shaderList.get(i).getContextId() == Long.parseLong(contextId) && shaderList.get(i).getId() == Integer.parseInt(vertexShaderID)) {
                vertexSrc = DownloadContentfileManager.getFileContents(shaderList.get(i).getShaderSrc());
            } else if (shaderList.get(i).getId() == Integer.parseInt(fragmentID)) {
                fragmentSrc = DownloadContentfileManager.getFileContents(shaderList.get(i).getShaderSrc());
            }
            ++i;
        }
        StringBuffer strDetailView = new StringBuffer();
        strDetailView.append("\n");
        strDetailView.append("#" + items[0].getText(1) + heightFormAttachment);
        strDetailView.append("#" + GLPageLabels.GL_VERTEX + " " + items[0].getText(2) + heightFormAttachment);
        strDetailView.append(String.valueOf(vertexSrc) + heightFormAttachment);
        strDetailView.append("#" + GLPageLabels.GL_FRAGMENT + " " + items[0].getText(3) + heightFormAttachment);
        strDetailView.append(String.valueOf(fragmentSrc) + heightFormAttachment);
        this.detailText.setText(strDetailView.toString());
        this.detailText.removeExtendedModifyListener(this.programExtendedModifyListener);
    }

    private String getErrorDescription(String apiName, String errorName) {
        if (apiName.equals("glDisable")) {
            apiName.equals("glEnable");
        } else if (apiName.equals("glDisableVertexAttribArray")) {
            apiName = "glEnableVertexAttribArray";
        } else if (apiName.equals("glGetBooleanv") || apiName.equals("glGetFloatv") || apiName.equals("glGetIntegerv")) {
            apiName = "glGet";
        } else if (apiName.startsWith("glGetTexParameter")) {
            apiName = "glGetTexParameter";
        } else if (apiName.startsWith("glGetUniform") && !apiName.endsWith("n")) {
            apiName = "glGetUniform";
        } else if (apiName.startsWith("glGetVertexAttrib") && !apiName.endsWith("rv")) {
            apiName = "glGetVertexAttrib";
        } else if (apiName.startsWith("glTexParameter")) {
            apiName = "glTexParameter";
        } else if (apiName.startsWith("glUniform")) {
            apiName = "glUniform";
        } else if (apiName.startsWith("glVertexAttrib") && (apiName.endsWith("f") || apiName.endsWith("v"))) {
            apiName = "glVertexAttrib";
        }
        String errorDescription = GLES20ErrorDefine.getErrorDescription(String.valueOf(apiName) + errorName);
        if (errorDescription == null) {
            return errorName;
        }
        return errorDescription;
    }

    public Control getControl() {
        return this.contents;
    }

    public void clear() {
        this.init();
    }
}

