/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.common.SetRangeMarkerMouseMoveListener;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLFrameRateChart;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLFrameRateChartBoard;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLFrameTimeChartBoard;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardHeightChangeableItem;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class GLChartView
extends DAViewComposite {
    public static final String ID = GLChartView.class.getName();
    private final Composite contents;
    private GLFrameTimeChartBoard frameTimeChartBoard;
    private GLFrameRateChartBoard frameRateChartBoard;
    private DACustomCombo frameTimeCombo;
    private DACustomCombo frameRateCombo;
    private final StackLayout stackLayout;
    private DAToolBarCustomCombo frameRateProcessCombo;
    private DAToolBarCustomCombo frameTimeProcessCombo;
    private DACustomButton frameRateDimensionSwitchButton;
    private DACustomButton frameTimeDimensionSwitchButton;

    public GLChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        AnalyzerUtil.setLatestTraceMode(GLPage.pageID, true);
        this.setTitle(ThreadPageLabels.THREAD_CHART_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.initFrameTimeChart();
        this.initFrameRateChart();
        this.stackLayout.topControl = this.frameRateChartBoard;
        this.frameTimeChartBoard.setSelectable(false);
        this.frameRateChartBoard.setSelectable(false);
        this.initializeCharts();
        DATimeline frameTimeline = this.frameTimeChartBoard.getTimeline();
        frameTimeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        frameTimeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        frameTimeline.addMouseMoveListener((MouseMoveListener)new SetRangeMarkerMouseMoveListener(RangeDataManager.getInstance(), this.frameTimeChartBoard, frameTimeline));
        DATimeline frameRateline = this.frameRateChartBoard.getTimeline();
        frameRateline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        frameRateline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.frameRateChartBoard.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(frameRateline);
        SetRangeMarkerMouseMoveListener listener = new SetRangeMarkerMouseMoveListener(RangeDataManager.getInstance(), this.frameRateChartBoard, frameRateline);
        frameRateline.addMouseMoveListener((MouseMoveListener)listener);
        frameRateline.addMouseListener((MouseListener)listener);
        this.frameRateChartBoard.getTitleComp().setLayout((Layout)new FormLayout());
        this.frameTimeChartBoard.getTitleComp().setLayout((Layout)new FormLayout());
        this.frameRateProcessCombo = this.makeProcessCombo(this.frameRateChartBoard.getTitleComp());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = 167;
        data.height = 25;
        this.frameRateProcessCombo.setLayoutData(data);
        this.frameTimeProcessCombo = this.makeProcessCombo(this.frameTimeChartBoard.getTitleComp());
        this.frameTimeProcessCombo.setLayoutData(data);
        this.frameRateDimensionSwitchButton = new DACustomButton(this.frameRateChartBoard.getTitleComp(), ImageResources.DIMENSION_IC_NOR, ImageResources.DIMENSION_IC_NOR, ImageResources.DIMENSION_IC_NOR, ImageResources.DIMENSION_IC_NOR);
        this.frameTimeDimensionSwitchButton = new DACustomButton(this.frameTimeChartBoard.getTitleComp(), ImageResources.DIMENSION_IC_SEL, ImageResources.DIMENSION_IC_SEL, ImageResources.DIMENSION_IC_SEL, ImageResources.DIMENSION_IC_SEL);
        this.frameRateDimensionSwitchButton.setBackground(ColorResources.WHITE);
        this.frameTimeDimensionSwitchButton.setBackground(ColorResources.WHITE);
        this.frameRateDimensionSwitchButton.setForeground(ColorResources.GRAY_170);
        this.frameTimeDimensionSwitchButton.setForeground(ColorResources.GRAY_170);
        this.frameRateDimensionSwitchButton.setRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer(){

            public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
                Rectangle rect = canvas.getClientArea();
                if (attr.getDrawType() == 0) {
                    this.drawImageButton(gc, rect, state, attr);
                } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
                    this.drawButton(gc, rect, state, attr);
                }
                this.drawButtonImage(gc, rect, attr, state);
                this.drawIcon(gc, rect, attr);
                gc.drawLine(0, 0, 25, 0);
                gc.drawLine(0, 24, 25, 24);
                gc.drawLine(24, 0, 24, 24);
            }
        });
        this.frameTimeDimensionSwitchButton.setRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer(){

            public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
                Rectangle rect = canvas.getClientArea();
                if (attr.getDrawType() == 0) {
                    this.drawImageButton(gc, rect, state, attr);
                } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
                    this.drawButton(gc, rect, state, attr);
                }
                this.drawButtonImage(gc, rect, attr, state);
                this.drawIcon(gc, rect, attr);
                gc.drawLine(0, 0, 25, 0);
                gc.drawLine(0, 24, 25, 24);
                gc.drawLine(24, 0, 24, 24);
            }
        });
        this.frameRateDimensionSwitchButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleEvent(Event event) {
                GLChartView.this.changeBoardTimeToRate();
            }

            public void handleClickEvent(DACustomButton button) {
            }
        });
        this.frameTimeDimensionSwitchButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleEvent(Event event) {
                GLChartView.this.changeBoardRateToTime();
            }

            public void handleClickEvent(DACustomButton button) {
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.frameRateProcessCombo, 0);
        data.width = 25;
        data.height = 25;
        this.frameRateDimensionSwitchButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.frameTimeProcessCombo, 0);
        data.width = 25;
        data.height = 25;
        this.frameTimeDimensionSwitchButton.setLayoutData((Object)data);
        this.initProcessCombo(this.frameRateProcessCombo);
        this.initProcessCombo(this.frameTimeProcessCombo);
        this.updateScale();
        this.frameTimeChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(GLChartView.this.frameTimeChartBoard.getScale().getSelection());
                GLChartView.this.updateScale();
            }
        });
        this.frameRateChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(GLChartView.this.frameRateChartBoard.getScale().getSelection());
                GLChartView.this.updateScale();
            }
        });
        this.frameTimeChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(GLChartView.this.frameTimeChartBoard.getScale().getSelection());
            }
        });
        this.frameRateChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(GLChartView.this.frameRateChartBoard.getScale().getSelection());
            }
        });
    }

    private void updateScale() {
        int scaleSelection = Toolbar.INSTANCE.getScaleSelection();
        this.frameTimeChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.frameTimeChartBoard.setScaleVal(scaleSelection);
        this.frameRateChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.frameRateChartBoard.setScaleVal(scaleSelection);
    }

    private DAToolBarCustomCombo makeProcessCombo(Composite parent) {
        int PROCESS_COMBO = 2;
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(135, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        returnCombo.setDeviceCombo(PROCESS_COMBO);
        return returnCombo;
    }

    public void initProcessCombo(final DAToolBarCustomCombo combo) {
        combo.initCombo();
        combo.add("All Processes");
        combo.select(0);
        combo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                int i = 0;
                while (i < Toolbar.INSTANCE.getProcessCombo().getItems().size()) {
                    if (combo.getText().equals(Toolbar.INSTANCE.getProcessCombo().getItem(i))) {
                        Toolbar.INSTANCE.getProcessCombo().select(i);
                    }
                    ++i;
                }
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        combo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                combo.initCombo();
                combo.add("All Processes");
                Toolbar.INSTANCE.getProcessCombo().initCombo();
                Toolbar.INSTANCE.getProcessCombo().add("All Processes");
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(" : ");
                    buffer.append(binName);
                    combo.add(buffer.toString());
                    Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
                    ++i;
                }
            }
        });
    }

    private void initFrameTimeChart() {
        this.frameTimeChartBoard = new GLFrameTimeChartBoard(this.contents, GLPageLabels.GL_CHART_TITLE_FRAME_TIME, 1);
        this.frameTimeChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        ScrollBar hScrollBar = this.frameTimeChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GLChartView.this.frameTimeChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(GLPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(GLPage.pageID, false);
                }
            }
        });
    }

    private void initFrameRateChart() {
        this.frameRateChartBoard = new GLFrameRateChartBoard(this.contents, GLPageLabels.GL_CHART_TITLE_FRAME_RATE, 0);
        this.frameRateChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        ScrollBar hScrollBar = this.frameRateChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GLChartView.this.frameRateChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(GLPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(GLPage.pageID, false);
                }
            }
        });
    }

    private DACustomCombo makeDACustomCombo(Composite parent) {
        DACustomCombo returnCombo = new DACustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(160, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return returnCombo;
    }

    private void changeComboRateToTime() {
        this.stackLayout.topControl = this.frameRateChartBoard;
        GLDataManager.getInstance().setSelectFrameRateChart(true);
        this.contents.layout();
        this.frameRateCombo.setText(GLPageLabels.GL_CHART_TITLE_FRAME_RATE);
        this.frameRateChartBoard.setScaleVal(this.frameTimeChartBoard.getScaleVal());
        this.frameRateChartBoard.setVisibleStart(this.frameTimeChartBoard.getVisibleStart());
        this.frameRateChartBoard.setItemsHeightMode(this.frameTimeChartBoard.isItemMinimized());
        this.updateView();
    }

    private void changeComboTimeToRate() {
        this.stackLayout.topControl = this.frameTimeChartBoard;
        GLDataManager.getInstance().setSelectFrameRateChart(false);
        this.contents.layout();
        this.frameTimeCombo.setText(GLPageLabels.GL_CHART_TITLE_FRAME_TIME);
        this.frameTimeChartBoard.setScaleVal(this.frameRateChartBoard.getScaleVal());
        this.frameTimeChartBoard.setVisibleStart(this.frameRateChartBoard.getVisibleStart());
        this.frameTimeChartBoard.setItemsHeightMode(this.frameRateChartBoard.isItemMinimized());
        this.updateView();
    }

    private void changeBoardRateToTime() {
        this.stackLayout.topControl = this.frameRateChartBoard;
        GLDataManager.getInstance().setSelectFrameRateChart(true);
        this.contents.layout();
        this.frameRateChartBoard.setScaleVal(this.frameTimeChartBoard.getScaleVal());
        this.frameRateChartBoard.setVisibleStart(this.frameTimeChartBoard.getVisibleStart());
        this.frameRateChartBoard.setItemsHeightMode(this.frameTimeChartBoard.isItemMinimized());
        this.updateView();
    }

    private void changeBoardTimeToRate() {
        this.stackLayout.topControl = this.frameTimeChartBoard;
        GLDataManager.getInstance().setSelectFrameRateChart(false);
        this.contents.layout();
        this.frameTimeChartBoard.setScaleVal(this.frameRateChartBoard.getScaleVal());
        this.frameTimeChartBoard.setVisibleStart(this.frameRateChartBoard.getVisibleStart());
        this.frameTimeChartBoard.setItemsHeightMode(this.frameRateChartBoard.isItemMinimized());
        this.updateView();
    }

    private void updateProcessCombo() {
        int index = Toolbar.INSTANCE.getProcessCombo().getSelectionIndex();
        if (index + 1 > this.frameRateProcessCombo.getItems().size()) {
            this.addProcessListToProcessCombo();
        }
        this.frameRateProcessCombo.select(index);
    }

    private void addProcessListToProcessCombo() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        int[] pids = project.getProcessIDs();
        int pcount = pids.length;
        int i = 0;
        while (i < pcount) {
            ProcessMemoryMap map;
            ProcessInformation process = project.getProcessInformation(pids[i]);
            String binName = process.getProcessName();
            if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                int bid = map.getMainbinary().getBinaryID();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                if (binPath != null && !binPath.isEmpty()) {
                    int index = binPath.lastIndexOf("/");
                    binName = binPath.substring(index + 1, binPath.length());
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(process.getPid()).append(" : ");
            buffer.append(binName);
            this.frameRateProcessCombo.add(buffer.toString());
            Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
            ++i;
        }
    }

    public void updateMarker() {
        List<Double> markerTimeList = Toolbar.INSTANCE.getMarkerTimeList();
        List<TimelineChart> chartList = this.frameRateChartBoard.getChartList();
        for (TimelineChart chart : chartList) {
            DAChartBoardHeightChangeableItem proceeChart;
            chart.getChart().getPlot().clearMarkerTime();
            if (!(chart instanceof CPUChart) || (proceeChart = ((CPUChart)chart).getProcessChart()) == null) continue;
            proceeChart.getChart().getPlot().clearMarkerTime();
        }
        GLFrameRateChart.getInstance().chart.getPlot().clearMarkerTime();
        for (double time : markerTimeList) {
            for (TimelineChart chart : chartList) {
                DAChartBoardHeightChangeableItem proceeChart;
                chart.getChart().getPlot().addMarkerTime(time);
                if (!(chart instanceof CPUChart) || (proceeChart = ((CPUChart)chart).getProcessChart()) == null) continue;
                proceeChart.getChart().getPlot().addMarkerTime(time);
            }
            GLFrameRateChart.getInstance().chart.getPlot().addMarkerTime(time);
            this.frameRateChartBoard.getTimeline().addMarker(time);
        }
    }

    public void updateView() {
        this.updateScale();
        this.updateProcessCombo();
        this.updateMarker();
        if (this.stackLayout.topControl == this.frameTimeChartBoard) {
            this.frameTimeChartBoard.updateView();
        } else {
            this.frameRateChartBoard.updateView();
        }
    }

    public void updateView(DAViewData vdata) {
        this.updateScale();
        this.updateProcessCombo();
        this.updateMarker();
        if (vdata instanceof GLSelectionData) {
            this.updateViewFromHistory((GLSelectionData)vdata);
        } else if (vdata instanceof DASelectionData) {
            this.updateViewFromOtherPage((DASelectionData)vdata);
        }
    }

    private void updateViewFromHistory(GLSelectionData data) {
        String id = data.getViewID();
        if (!id.equals("contextHistoryID.id")) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = null;
        if (this.stackLayout.topControl == this.frameTimeChartBoard) {
            int frameIndex = data.getFrameTimeIndex();
            this.frameTimeChartBoard.setVisibleMiddleTime(frameIndex);
            intervalMarker = (DAChartPlotIntervalMarker)this.frameTimeChartBoard.getMarkers().get(0);
            intervalMarker.setInterval((double)frameIndex, (double)frameIndex);
            this.frameTimeChartBoard.updateViewFromDBData();
        } else {
            int chartIndex = data.getFrameRateIndex();
            if (chartIndex == 1) {
                chartIndex = GLDataManager.getInstance().getStartFrameRateTime();
            }
            this.frameRateChartBoard.setVisibleMiddleTime(chartIndex);
            intervalMarker = (DAChartPlotIntervalMarker)this.frameRateChartBoard.getMarkers().get(0);
            intervalMarker.setInterval((double)chartIndex, (double)chartIndex);
            this.frameRateChartBoard.updateViewFromDBData();
        }
    }

    private void updateViewFromOtherPage(DASelectionData selData) {
        if (!selData.isLogData()) {
            return;
        }
        Object obData = selData.getData();
        if (obData == null || !(obData instanceof LogData)) {
            return;
        }
        LogData ldata = (LogData)obData;
        long dataTime = ldata.getTime();
        double selectionTime = (double)dataTime / 1000000.0;
        if (selectionTime <= 1.0) {
            selectionTime = GLDataManager.getInstance().getStartFrameRateTime();
        }
        this.frameRateChartBoard.setVisibleMiddleTime(selectionTime);
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.frameRateChartBoard.getMarkers().get(0);
        intervalMarker.setInterval(selectionTime, selectionTime);
        this.frameRateChartBoard.updateViewFromDBData();
    }

    public void clear() {
        this.frameTimeChartBoard.contentsClear();
        this.frameTimeChartBoard.clear();
        this.frameRateChartBoard.contentsClear();
        this.frameRateChartBoard.clear();
        this.initializeCharts();
    }

    private void initializeCharts() {
        this.frameRateChartBoard.initializeCharts();
        this.frameTimeChartBoard.initializeCharts();
    }

    public DAChartBoard getChartBoard() {
        return this.frameRateChartBoard;
    }
}

