/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLConstantDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLES20ErrorDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLAPITable
extends DATableComposite {
    private int startFrameIndex = -1;
    private int endFrameIndex = -1;

    public GLAPITable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLAPITable.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                if (!(dataFormat.getLogData() instanceof GLAPIData)) {
                    return;
                }
                GLAPIData glAPIType = (GLAPIData)dataFormat.getLogData();
                long time = glAPIType.getTime();
                int frameIndex = glAPIType.getFrameIndex();
                long contextId = glAPIType.getContextID();
                GLDataManager.getInstance().setSelectedAPIAtTable(glAPIType.getApiName());
                GLSelectionData selData = new GLSelectionData(GLPage.apiListViewID, time, time, items, (Control)GLAPITable.this.table, frameIndex, contextId);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                AnalyzerManager.updateView(GLPage.apiListViewID, selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                DATableDataFormat dataFormat = (DATableDataFormat)ti[0].getData();
                AnalyzerUtil.addMarker(((GLAPIData)dataFormat.getLogData()).getTime());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<GLAPIData> apiList = null;
        List<FilterProperty> filterList = this.getFilterPropertyList();
        if (!filterList.isEmpty()) {
            List<String> whereClause = this.convertFilterProperty2Query(filterList);
            apiList = GLDataManager.getInstance().getCurrentAPITableData(this.startFrameIndex, this.endFrameIndex, whereClause);
        } else {
            apiList = GLDataManager.getInstance().getCurrentAPITableData(this.startFrameIndex, this.endFrameIndex, null);
        }
        if (apiList == null) {
            return null;
        }
        int size = apiList.size();
        int i = 0;
        while (i < size) {
            block16: {
                GLAPIData glApiType = apiList.get(i);
                String seq = Long.toString(glApiType.getSeq());
                String apiName = glApiType.getApiName();
                String time = String.valueOf(Formatter.toTimeFormat(glApiType.getTime()));
                String args = GLConstantDefine.convertEnumValue(glApiType.getArgs(), ",", null);
                String elapsedTime = String.valueOf(glApiType.getElapsedTime());
                String errMsg = GLES20ErrorDefine.getError(glApiType.getErrno());
                int j = 0;
                while (j < filterList.size()) {
                    switch (filterList.get(j).getColumnIndex()) {
                        case 2: {
                            if (time.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 3: {
                            if (apiName.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 4: {
                            if (args.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 6: {
                            if (elapsedTime.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break;
                            break block16;
                        }
                        case 7: {
                            if (!errMsg.toLowerCase().contains(filterList.get(j).getKeyWord().toLowerCase())) break block16;
                        }
                    }
                    ++j;
                }
                ArrayList<String> text = new ArrayList<String>();
                text.add(seq);
                text.add(Integer.toString(glApiType.getFrameIndex()));
                text.add(time);
                text.add(apiName);
                text.add(args);
                text.add(glApiType.getReturn());
                text.add(elapsedTime);
                text.add(errMsg);
                text.add(String.valueOf(glApiType.getPid()));
                text.add(String.valueOf(glApiType.getTid()));
                DATableDataFormat tableData = new DATableDataFormat(Long.parseLong(seq));
                ArrayList<Object> compareData = new ArrayList<Object>();
                int j2 = 0;
                while (j2 < text.size()) {
                    compareData.add(text.get(j2));
                    ++j2;
                }
                tableData.setLogData(glApiType);
                tableData.setData(compareData);
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(glApiType);
                tableInput.setData(tableData);
                if (!GLES20ErrorDefine.getError(glApiType.getErrno()).contains("SUCCESS")) {
                    tableInput.setFailed(true);
                }
                if (GLDataManager.getInstance().getSelectedAPIAtTable().equals(glApiType.getApiName())) {
                    tableInput.setSecondSelection(true);
                }
                input.add(tableInput);
            }
            ++i;
        }
        return input;
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 1: {
                columnName = "FRAME_INDEX";
                break;
            }
            case 5: {
                columnName = "RETURN_VALUE";
                break;
            }
            case 8: {
                columnName = "PID";
                break;
            }
            case 9: {
                columnName = "TID";
                break;
            }
        }
        return columnName;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    public void updateTableFromChart(int startFrameIndex, int endFrameIndex) {
        if (startFrameIndex >= 0) {
            this.startFrameIndex = startFrameIndex;
        }
        this.endFrameIndex = endFrameIndex;
        this.updateTable();
        this.table.setSelection(0);
        GridItem[] items = this.table.getSelection();
        if (items == null || items.length == 0) {
            return;
        }
        DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
        if (dataFormat.getLogData() instanceof GLAPIData) {
            GLAPIData glAPIType = (GLAPIData)dataFormat.getLogData();
            long time = glAPIType.getTime();
            int frameIndex = glAPIType.getFrameIndex();
            long contextId = glAPIType.getContextID();
            GLSelectionData selData = new GLSelectionData(GLPage.apiListViewID, time, time, items, (Control)this.table, frameIndex, contextId);
            AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
        }
    }

    public void updateTableFromContext(int startFrameIndex, int endFrameIndex, String seq) {
        if (startFrameIndex >= 0) {
            this.startFrameIndex = startFrameIndex;
        }
        this.endFrameIndex = endFrameIndex;
        this.updateTable();
        int nSize = this.table.getItemCount();
        int ii = 0;
        while (ii < nSize) {
            if (this.table.getItem(ii).getText(0).equals(seq)) {
                this.table.setSelection(ii);
                this.table.getVerticalBar().setSelection(this.getScrollSelectionIndex(this.table, ii));
                this.updateTable();
            }
            ++ii;
        }
        GridItem[] items = this.table.getSelection();
        if (items == null || items.length == 0) {
            return;
        }
        DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
        if (!(dataFormat.getLogData() instanceof GLAPIData)) {
            return;
        }
        GLAPIData glAPIType = (GLAPIData)dataFormat.getLogData();
        long time = glAPIType.getTime();
        int frameIndex = glAPIType.getFrameIndex();
        long contextId = glAPIType.getContextID();
        GLSelectionData selData = new GLSelectionData(GLPage.apiListViewID, time, time, items, (Control)this.table, frameIndex, contextId);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
    }

    private int getScrollSelectionIndex(Grid table, int selection) {
        int size = table.getVerticalBar().getThumb() / 2;
        int output = selection - size;
        output = output < 0 ? 0 : output;
        return output;
    }

    @Override
    public boolean[] getColumnVisibility() {
        if (this.table == null) {
            return null;
        }
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        boolean[] columnsVisibility = new boolean[size];
        int i = 1;
        while (i < size) {
            columnsVisibility[i] = columns[i].getVisible();
            ++i;
        }
        return columnsVisibility;
    }
}

