/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLContextTable;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedPopupMenu;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLContextTableView
extends DAAdvancedViewComposite {
    GLContextTable tableComp = null;
    private Canvas titleBar = null;
    private int[] columnSizes = new int[]{150, 100, 400};
    private boolean[] columnVisibility = new boolean[]{true, true, true};
    private int[] columnAlignment = new int[]{16384, 16384, 16384};
    private int checkBoxOffSet = 20;
    private List<Object> selectedStateValueList = null;
    private String selectedSeq = "";
    private boolean isCheckedBox = true;
    private Image checkImg = ImageResources.OPENGL_SHOW_ONLY_CHANGED_SELECTED;
    private String[] columnNames = new String[]{GLPageLabels.GL_CONTEXT_VIEW_NAME, GLPageLabels.GL_CONTEXT_VIEW_DEFAULT_VALUE, GLPageLabels.GL_CONTEXT_VIEW_CURRENT_VALUE};
    int[] sortTypes = new int[]{2, 2, 2};
    private PaintListener checkBoxPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle bounds = GLContextTableView.this.titleBar.getBounds();
            int width = bounds.width;
            gc.drawImage(GLContextTableView.this.checkImg, width - GLContextTableView.this.checkBoxOffSet, 2);
        }
    };
    private Listener checkBoxMouseUpListener = new Listener(){

        public void handleEvent(Event event) {
            Rectangle bounds = GLContextTableView.this.titleBar.getBounds();
            int width = bounds.width;
            if (width - GLContextTableView.this.checkBoxOffSet > event.x || event.x > width) {
                return;
            }
            if (GLContextTableView.this.isCheckedBox) {
                GLContextTableView.this.isCheckedBox = false;
                GLContextTableView.this.checkImg = ImageResources.OPENGL_SHOW_ONLY_CHANGED_UNSELECTED;
            } else {
                GLContextTableView.this.isCheckedBox = true;
                GLContextTableView.this.checkImg = ImageResources.OPENGL_SHOW_ONLY_CHANGED_SELECTED;
            }
            GLContextTableView.this.titleBar.redraw();
            GLContextTableView.this.tableComp.setSelectedSeq(GLContextTableView.this.isCheckedBox, GLContextTableView.this.selectedSeq, GLContextTableView.this.selectedStateValueList);
            GLContextTableView.this.tableComp.updateTable();
            GLContextTableView.this.tableComp.setSelectedSeq(GLContextTableView.this.isCheckedBox, GLContextTableView.this.selectedSeq, null);
        }
    };

    public GLContextTableView(Composite parent, int style) {
        super(parent, style, false, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(GLPageLabels.GL_CONTEXT_VIEW_TITLE);
        this.titleBar = this.getTitleArea();
        this.titleBar.addPaintListener(this.checkBoxPaintListener);
        this.titleBar.addListener(4, this.checkBoxMouseUpListener);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new GLContextTable(contents, 0, 68354);
        this.tableComp.setTableName(GLPageLabels.GL_CONTEXT_VIEW_TITLE);
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.tableComp.setColumnVisibility(this.columnVisibility);
        this.tableComp.setTableToolTipEnable(false);
        contents.addControlListener((ControlListener)new TableColumnSizePackListener(this.tableComp, this.columnSizes));
        this.setTable(this.tableComp);
        this.disableAdvancedMenuItem(DAAdvancedPopupMenu.ADVANCED_MENU_ITEM.FILTER.index);
    }

    public void updateView() {
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData data = (DASelectionData)vdata;
        String id = data.getViewID();
        if (!id.equals(GLPage.apiListViewID) || !(data instanceof GLSelectionData)) {
            return;
        }
        GridItem[] gridItems = (GridItem[])data.getData();
        DATableDataFormat tableDataFormat = (DATableDataFormat)gridItems[0].getData();
        LogData logData = tableDataFormat.getLogData();
        int frameIndex = ((GLSelectionData)data).getFrameTimeIndex();
        long contextId = ((GLSelectionData)data).getContextId();
        String apiName = ((GLAPIData)logData).getApiName();
        this.selectedSeq = Long.toString(logData.getSeq());
        this.selectedStateValueList = GLDataManager.getInstance().getContextDBTableManage().getContextData(this.selectedSeq, contextId);
        if (this.selectedStateValueList == null) {
            return;
        }
        this.tableComp.setSelectedSeq(this.isCheckedBox, this.selectedSeq, this.selectedStateValueList);
        this.tableComp.updateTable();
        this.tableComp.setSelectedSeq(this.isCheckedBox, this.selectedSeq, null);
        long contextID = (Long)this.selectedStateValueList.get(GLContextNameEnum.CONTEXT_ID.ordinal());
        String curretnContextNember = "Context_" + contextID;
        this.setTitle(String.valueOf(curretnContextNember) + " ( " + apiName + " of " + frameIndex + " frame )");
        GLDataManager.getInstance().setSelectedContextID(contextID);
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

