/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.page;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.file.FileChartView;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.network.NetworkChartView;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChartView;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiListView;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfilingView;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataView;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DlogView;
import org.tizen.dynamicanalyzer.ui.toolbar.AboutDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceProgressManager;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.PreferencesDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialog;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardManager;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialog;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.scale.DAScale;

public class MenuBar {
    private static MenuBar instance = new MenuBar();
    private Shell currentShell;
    private Menu menubar = null;
    private boolean sourceView = false;
    private MenuItem fileNew;
    private MenuItem viewDetail;
    private MenuItem analyzeSearchItem;
    private SelectionListener fileMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String menuName = null;
            if (arg0.getSource() == null || !(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            if (menuName.equals(MenuBarLabels.FILE_NEW)) {
                if (MenuBar.this.showSaveWarning()) {
                    MenuBar.this.setMenuItemEnable(MenuBarLabels.FILE_SAVE, false);
                    CommonAction.clear();
                    Toolbar.INSTANCE.clearMarkerTimeList();
                    RangeDataManager.getInstance().clearMarkerTime();
                    RangeDataManager.getInstance().clearTimelineMarker();
                    Toolbar.INSTANCE.changeUIState(DAState.INIT);
                    Toolbar.INSTANCE.setScaleSelection(2);
                    FlatFeatureDialog featureDialog = new FlatFeatureDialog(MenuBar.this.currentShell);
                    featureDialog.open();
                    if (SettingDataManager.INSTANCE.isNewSetting()) {
                        MenuBar.this.resetReportItemCheck();
                    }
                }
            } else if (menuName.equals(MenuBarLabels.FILE_LOAD)) {
                if (MenuBar.this.showSaveWarning()) {
                    MenuBar.this.showLoadDialog();
                }
            } else if (menuName.equals(MenuBarLabels.FILE_SAVE)) {
                MenuBar.this.showSaveDialog();
            } else if (menuName.equals(MenuBarLabels.FILE_EXIT) && MenuBar.this.showSaveWarning()) {
                MenuBar.this.currentShell.close();
            }
        }
    };
    private SelectionListener anlysisMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String menuName = null;
            if (arg0.getSource() == null || !(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            if (menuName.equals(MenuBarLabels.ANALYZE_SEARCH)) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                Composite comp = baseView.getTopPage().getTopTable();
                SearchDialog dialog = new SearchDialog(shell, comp);
                dialog.open();
            } else if (menuName.equals(MenuBarLabels.ANALYZE_TARGET)) {
                TargetDialog targetDialog = new TargetDialog(MenuBar.this.currentShell);
                targetDialog.open();
            } else if (menuName.equals(MenuBarLabels.ANALYZE_SCREENSHOT)) {
                try {
                    if (!DACommunicator.captureScreenshot().isSuccess()) {
                        Logger.error((Object)"Failed to capture screenshot");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.warning((Object)"Interrupted during send screenshot message");
                }
                catch (UnsupportedProtocolException unsupportedProtocolException) {
                    Logger.warning((Object)"Message to capture screenshot is not supported by communicator");
                }
            } else if (menuName.equals(MenuBarLabels.ANALYZE_PREFENCES)) {
                PreferencesDialog preferencesDialog = new PreferencesDialog(MenuBar.this.currentShell);
                preferencesDialog.open();
            } else {
                menuName.equals(MenuBarLabels.ANALYZE_SET_AS_DEFAULT);
            }
        }
    };
    private SelectionListener viewMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String menuName = null;
            if (arg0.getSource() == null || !(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            MenuItem source = (MenuItem)arg0.getSource();
            if (menuName.equals(MenuBarLabels.VIEW_DETAIL)) {
                TimelinePage tlPage = (TimelinePage)AnalyzerUtil.getTabPage(TimelinePage.pageID);
                MemoryPage mmPage = (MemoryPage)AnalyzerUtil.getTabPage(MemoryPage.pageID);
                NetworkPage nwPage = (NetworkPage)AnalyzerUtil.getTabPage(NetworkPage.pageID);
                ThreadPage thPage = (ThreadPage)AnalyzerUtil.getTabPage(ThreadPage.pageID);
                FilePage fiPage = (FilePage)AnalyzerUtil.getTabPage(FilePage.pageID);
                GLPage glPage = (GLPage)AnalyzerUtil.getTabPage(GLPage.pageID);
                if (!source.getSelection()) {
                    if (tlPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        tlPage.getBaseForm().setWeights(nArray);
                        tlPage.setDetailMode(false);
                    }
                    if (mmPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        mmPage.getBaseForm().setWeights(nArray);
                        mmPage.setDetailMode(false);
                    }
                    if (nwPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        nwPage.getBaseForm().setWeights(nArray);
                        nwPage.setDetailMode(false);
                    }
                    if (thPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        thPage.getBaseForm().setWeights(nArray);
                        thPage.setDetailMode(false);
                    }
                    if (fiPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        fiPage.getBaseForm().setWeights(nArray);
                        fiPage.setDetailMode(false);
                    }
                    if (glPage != null) {
                        int[] nArray = new int[2];
                        nArray[0] = 100;
                        glPage.getBaseForm().setWeights(nArray);
                        glPage.setDetailMode(false);
                    }
                } else {
                    if (tlPage != null) {
                        tlPage.getBaseForm().setWeights(new int[]{65, 35});
                        tlPage.setDetailMode(true);
                    }
                    if (mmPage != null) {
                        mmPage.getBaseForm().setWeights(new int[]{65, 35});
                        mmPage.setDetailMode(true);
                    }
                    if (nwPage != null) {
                        nwPage.getBaseForm().setWeights(new int[]{65, 35});
                        nwPage.setDetailMode(true);
                    }
                    if (thPage != null) {
                        thPage.getBaseForm().setWeights(new int[]{65, 35});
                        thPage.setDetailMode(true);
                    }
                    if (fiPage != null) {
                        fiPage.getBaseForm().setWeights(new int[]{65, 35});
                        fiPage.setDetailMode(true);
                    }
                    if (glPage != null) {
                        glPage.getBaseForm().setWeights(new int[]{65, 35});
                        glPage.setDetailMode(true);
                    }
                }
                AnalyzerManager.getCurrentPage().updateView();
            }
        }
    };
    private SelectionListener viewReportMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String menuName = null;
            if (arg0.getSource() == null || !(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            TimelineTableView tableView = (TimelineTableView)AnalyzerUtil.getView(TimelinePage.pageID, TimelineTableView.class.getName());
            MenuItem source = (MenuItem)arg0.getSource();
            if (menuName.equals(MenuBarLabels.VIEW_FUNCTION_PROFILING)) {
                if (source.getSelection()) {
                    FunctionUsageProfilingView userFunctionProfilingView = new FunctionUsageProfilingView(tableView.getContentComposite(), 0);
                    if (Global.getProject() != null) {
                        boolean isWeb = Global.getProject().isWebApplication();
                        userFunctionProfilingView.changeTable(isWeb);
                    }
                    tableView.addView((DABaseComposite)userFunctionProfilingView);
                } else {
                    if (tableView.getTopComposite() instanceof FunctionUsageProfilingView) {
                        tableView.selectTab(DlogView.class.getName());
                    }
                    tableView.removeView(FunctionUsageProfilingView.class.getName(), false);
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_FAILED_API)) {
                if (source.getSelection()) {
                    FailedApiListView failedApiListView = new FailedApiListView(tableView.getContentComposite(), 0);
                    tableView.addView((DABaseComposite)failedApiListView);
                } else {
                    if (tableView.getTopComposite() instanceof FailedApiListView) {
                        tableView.selectTab(DlogView.class.getName());
                    }
                    tableView.removeView(FailedApiListView.class.getName(), false);
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_WARNING)) {
                if (source.getSelection()) {
                    WarningDataView warningView = new WarningDataView(tableView.getContentComposite(), 0);
                    tableView.addView((DABaseComposite)warningView);
                } else {
                    if (tableView.getTopComposite() instanceof WarningDataView) {
                        tableView.selectTab(DlogView.class.getName());
                    }
                    tableView.removeView(WarningDataView.class.getName(), false);
                }
            }
            ((TimelinePage)AnalyzerUtil.getTabPage(TimelinePage.pageID)).resizeTableButton();
        }
    };
    private SelectionListener viewNavigateMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            int i;
            String menuName = null;
            if (arg0.getSource() == null || !(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            TimelineChartView TLchartView = (TimelineChartView)AnalyzerUtil.getView(TimelinePage.pageID, TimelineChartView.class.getName());
            NetworkChartView NETchartView = (NetworkChartView)AnalyzerUtil.getView(NetworkPage.pageID, NetworkChartView.class.getName());
            ThreadChartView THRchartView = (ThreadChartView)AnalyzerUtil.getView(ThreadPage.pageID, ThreadChartView.class.getName());
            FileChartView FLchartView = (FileChartView)AnalyzerUtil.getView(FilePage.pageID, FileChartView.class.getName());
            GLChartView GLchartview = (GLChartView)AnalyzerUtil.getView(GLPage.pageID, GLChartView.class.getName());
            ArrayList<DAChartBoard> chartboards = new ArrayList<DAChartBoard>();
            ArrayList<DAChartBoardManager> boardMannagers = new ArrayList<DAChartBoardManager>();
            ArrayList<DAScale> scales = new ArrayList<DAScale>();
            int[] cfr_ignored_0 = new int[5];
            int index = 0;
            double chartDiv = 3.0;
            if (TLchartView != null) {
                chartboards.add(TLchartView.getChartBoard());
                boardMannagers.add(((DAChartBoard)chartboards.get(index)).getBoardManager());
                scales.add(((DAChartBoard)chartboards.get(index)).getScale());
                ++index;
            }
            if (NETchartView != null) {
                chartboards.add(NETchartView.getChartBoard());
                boardMannagers.add(((DAChartBoard)chartboards.get(index)).getBoardManager());
                scales.add(((DAChartBoard)chartboards.get(index)).getScale());
                ++index;
            }
            if (THRchartView != null) {
                chartboards.add(THRchartView.getChartBoard());
                boardMannagers.add(((DAChartBoard)chartboards.get(index)).getBoardManager());
                scales.add(((DAChartBoard)chartboards.get(index)).getScale());
                ++index;
            }
            if (FLchartView != null) {
                chartboards.add(FLchartView.getChartBoard());
                boardMannagers.add(((DAChartBoard)chartboards.get(index)).getBoardManager());
                scales.add(((DAChartBoard)chartboards.get(index)).getScale());
                ++index;
            }
            if (GLchartview != null) {
                chartboards.add(GLchartview.getChartBoard());
                boardMannagers.add(((DAChartBoard)chartboards.get(index)).getBoardManager());
                scales.add(((DAChartBoard)chartboards.get(index)).getScale());
                ++index;
            }
            if (menuName.equals(MenuBarLabels.VIEW_ZOOM_IN)) {
                if (Toolbar.INSTANCE.getScaleSelection() < 4) {
                    Toolbar.INSTANCE.setScaleSelection(Toolbar.INSTANCE.getScaleSelection() + 1);
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_ZOOM_OUT)) {
                if (Toolbar.INSTANCE.getScaleSelection() > 0) {
                    Toolbar.INSTANCE.setScaleSelection(Toolbar.INSTANCE.getScaleSelection() - 1);
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_MOVE_LEFT)) {
                i = 0;
                while (i < chartboards.size()) {
                    double changeScroll = 120.0 / Math.pow(2.0, Toolbar.INSTANCE.getScaleSelection());
                    double visibleStart = ((DAChartBoardManager)boardMannagers.get(i)).getVisibleStartTime();
                    ((DAChartBoardManager)boardMannagers.get(i)).startTimeChanged(visibleStart - changeScroll / chartDiv);
                    ++i;
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_MOVE_RIGHT)) {
                i = 0;
                while (i < chartboards.size()) {
                    double changeScroll = 120.0 / Math.pow(2.0, Toolbar.INSTANCE.getScaleSelection());
                    double visibleStart = ((DAChartBoardManager)boardMannagers.get(i)).getVisibleStartTime();
                    ((DAChartBoardManager)boardMannagers.get(i)).startTimeChanged(visibleStart + changeScroll / chartDiv);
                    ++i;
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_MOVE_FIRST)) {
                i = 0;
                while (i < chartboards.size()) {
                    ((DAChartBoardManager)boardMannagers.get(i)).startTimeChanged(((DAChartBoardManager)boardMannagers.get(i)).getTotalStartTime());
                    ++i;
                }
            } else if (menuName.equals(MenuBarLabels.VIEW_MOVE_END)) {
                i = 0;
                while (i < chartboards.size()) {
                    ((DAChartBoardManager)boardMannagers.get(i)).startTimeChanged(((DAChartBoardManager)boardMannagers.get(i)).getTotalEndTime());
                    ++i;
                }
            }
            BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
            baseView.getTopComposite().updateView();
        }
    };
    private SelectionListener helpMenuListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void widgetSelected(SelectionEvent arg0) {
            String menuName = null;
            if (arg0.getSource() == null) return;
            if (!(arg0.getSource() instanceof MenuItem)) {
                return;
            }
            menuName = ((MenuItem)arg0.getSource()).getText();
            if (menuName.equals(MenuBarLabels.HELP_ABOUT)) {
                AboutDialog aboutDialog = new AboutDialog(MenuBar.this.currentShell);
                aboutDialog.open();
                return;
            }
            if (menuName.equals(MenuBarLabels.HELP_BUGREPORT)) {
                try {
                    String url = MenuBarLabels.HELP_BUGREPORT_LINK;
                    if (CommonUtil.isWin()) {
                        Program.launch((String)url);
                        return;
                    }
                    if (CommonUtil.isLinux()) {
                        Runtime.getRuntime().exec("xdg-open " + url);
                        return;
                    }
                    if (!CommonUtil.isMac()) return;
                    Runtime.getRuntime().exec("/usr/bin/open " + url);
                    return;
                }
                catch (Throwable throwable) {
                    Logger.error((Object)"Failed to open developer site");
                    return;
                }
            }
            if (!menuName.equals(MenuBarLabels.HELP_HOWTO)) return;
            try {
                String url = MenuBarLabels.HELP_HOWTO_LINK;
                if (CommonUtil.isWin()) {
                    Program.launch((String)url);
                    return;
                } else if (CommonUtil.isLinux()) {
                    Runtime.getRuntime().exec("xdg-open " + url);
                    return;
                } else {
                    if (!CommonUtil.isMac()) return;
                    Runtime.getRuntime().exec("/usr/bin/open " + url);
                }
                return;
            }
            catch (Throwable throwable) {
                Logger.error((Object)"Failed to open developer site");
                return;
            }
        }
    };
    private SelectionListener saveButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            MenuBar.this.showSaveDialog();
            if (e.getSource() != null && e.getSource() instanceof Button) {
                ((Button)e.getSource()).getParent().getParent().dispose();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public MenuItem getFileNew() {
        return this.fileNew;
    }

    public MenuItem getViewDetail() {
        return this.viewDetail;
    }

    public MenuItem getAnalyzeSearch() {
        return this.analyzeSearchItem;
    }

    public MenuBar() {
        this.currentShell = WorkbenchUtil.getWorkbenchWindow().getShell();
    }

    public static MenuBar getInstance() {
        return instance;
    }

    public void makeMenuBar() {
        this.menubar = new Menu((Decorations)this.currentShell, 2);
        this.currentShell.setMenuBar(this.menubar);
        MenuItem fileItem = new MenuItem(this.menubar, 64);
        fileItem.setText(MenuBarLabels.FILE);
        MenuItem analyzeItem = new MenuItem(this.menubar, 64);
        analyzeItem.setText(MenuBarLabels.ANALYZE);
        MenuItem viewItem = new MenuItem(this.menubar, 64);
        viewItem.setText(MenuBarLabels.VIEW);
        MenuItem helpItem = new MenuItem(this.menubar, 64);
        helpItem.setText(MenuBarLabels.HELP);
        Menu fileMenu = new Menu((Decorations)this.currentShell, 4);
        fileItem.setMenu(fileMenu);
        this.fileNew = new MenuItem(fileMenu, 8);
        this.fileNew.setText(MenuBarLabels.FILE_NEW);
        this.fileNew.addSelectionListener(this.fileMenuListener);
        MenuItem fileLoad = new MenuItem(fileMenu, 8);
        fileLoad.setText(MenuBarLabels.FILE_LOAD);
        fileLoad.addSelectionListener(this.fileMenuListener);
        MenuItem fileSave = new MenuItem(fileMenu, 8);
        fileSave.setText(MenuBarLabels.FILE_SAVE);
        fileSave.setEnabled(false);
        fileSave.addSelectionListener(this.fileMenuListener);
        MenuItem fileExit = new MenuItem(fileMenu, 8);
        fileExit.setText(MenuBarLabels.FILE_EXIT);
        fileExit.addSelectionListener(this.fileMenuListener);
        Menu analyzeMenu = new Menu((Decorations)this.currentShell, 4);
        analyzeItem.setMenu(analyzeMenu);
        this.analyzeSearchItem = new MenuItem(analyzeMenu, 8);
        this.analyzeSearchItem.setText(MenuBarLabels.ANALYZE_SEARCH);
        this.analyzeSearchItem.addSelectionListener(this.anlysisMenuListener);
        MenuItem analyzeTarget = new MenuItem(analyzeMenu, 8);
        analyzeTarget.setText(MenuBarLabels.ANALYZE_TARGET);
        analyzeTarget.addSelectionListener(this.anlysisMenuListener);
        MenuItem analyzeScreenshot = new MenuItem(analyzeMenu, 8);
        analyzeScreenshot.setText(MenuBarLabels.ANALYZE_SCREENSHOT);
        analyzeScreenshot.addSelectionListener(this.anlysisMenuListener);
        analyzeScreenshot.setEnabled(false);
        MenuItem analyzePreferences = new MenuItem(analyzeMenu, 8);
        analyzePreferences.setText(MenuBarLabels.ANALYZE_PREFENCES);
        analyzePreferences.addSelectionListener(this.anlysisMenuListener);
        Menu viewMenu = new Menu((Decorations)this.currentShell, 4);
        viewItem.setMenu(viewMenu);
        this.viewDetail = new MenuItem(viewMenu, 32);
        this.viewDetail.setText(MenuBarLabels.VIEW_DETAIL);
        this.viewDetail.addSelectionListener(this.viewMenuListener);
        this.viewDetail.setSelection(true);
        MenuItem viewReport = new MenuItem(viewMenu, 64);
        viewReport.setText(MenuBarLabels.VIEW_REPORT);
        Menu viewReportMenu = new Menu((Decorations)this.currentShell, 4);
        viewReport.setMenu(viewReportMenu);
        MenuItem viewReportFunctionprofiling = new MenuItem(viewReportMenu, 32);
        viewReportFunctionprofiling.setText(MenuBarLabels.VIEW_FUNCTION_PROFILING);
        viewReportFunctionprofiling.addSelectionListener(this.viewReportMenuListener);
        MenuItem viewReportFailedAPI = new MenuItem(viewReportMenu, 32);
        viewReportFailedAPI.setText(MenuBarLabels.VIEW_FAILED_API);
        viewReportFailedAPI.addSelectionListener(this.viewReportMenuListener);
        MenuItem viewReportWarning = new MenuItem(viewReportMenu, 32);
        viewReportWarning.setText(MenuBarLabels.VIEW_WARNING);
        viewReportWarning.addSelectionListener(this.viewReportMenuListener);
        MenuItem viewNavigate = new MenuItem(viewMenu, 64);
        viewNavigate.setText(MenuBarLabels.VIEW_NAVIGATE);
        Menu viewNavigateMenu = new Menu((Decorations)this.currentShell, 4);
        viewNavigate.setMenu(viewNavigateMenu);
        MenuItem viewNavigateZoomin = new MenuItem(viewNavigateMenu, 8);
        viewNavigateZoomin.setText(MenuBarLabels.VIEW_ZOOM_IN);
        viewNavigateZoomin.addSelectionListener(this.viewNavigateMenuListener);
        MenuItem viewNavigateZoomout = new MenuItem(viewNavigateMenu, 8);
        viewNavigateZoomout.setText(MenuBarLabels.VIEW_ZOOM_OUT);
        viewNavigateZoomout.addSelectionListener(this.viewNavigateMenuListener);
        MenuItem viewNavigateMoveleft = new MenuItem(viewNavigateMenu, 8);
        viewNavigateMoveleft.setText(MenuBarLabels.VIEW_MOVE_LEFT);
        viewNavigateMoveleft.addSelectionListener(this.viewNavigateMenuListener);
        MenuItem viewNavigateMoveright = new MenuItem(viewNavigateMenu, 8);
        viewNavigateMoveright.setText(MenuBarLabels.VIEW_MOVE_RIGHT);
        viewNavigateMoveright.addSelectionListener(this.viewNavigateMenuListener);
        MenuItem viewNavigateMovefirst = new MenuItem(viewNavigateMenu, 8);
        viewNavigateMovefirst.setText(MenuBarLabels.VIEW_MOVE_FIRST);
        viewNavigateMovefirst.addSelectionListener(this.viewNavigateMenuListener);
        MenuItem viewNavigateMoveend = new MenuItem(viewNavigateMenu, 8);
        viewNavigateMoveend.setText(MenuBarLabels.VIEW_MOVE_END);
        viewNavigateMoveend.addSelectionListener(this.viewNavigateMenuListener);
        Menu helpMenu = new Menu((Decorations)this.currentShell, 4);
        helpItem.setMenu(helpMenu);
        MenuItem helpHowto = new MenuItem(helpMenu, 8);
        helpHowto.setText(MenuBarLabels.HELP_HOWTO);
        helpHowto.addSelectionListener(this.helpMenuListener);
        MenuItem helpBugreport = new MenuItem(helpMenu, 8);
        helpBugreport.setText(MenuBarLabels.HELP_BUGREPORT);
        helpBugreport.addSelectionListener(this.helpMenuListener);
        MenuItem helpAbout = new MenuItem(helpMenu, 8);
        helpAbout.setText(MenuBarLabels.HELP_ABOUT);
        helpAbout.addSelectionListener(this.helpMenuListener);
    }

    public boolean setMenuItemEnable(String menuName, boolean enable) {
        int menulength = this.menubar.getItems().length;
        int i = 0;
        while (i < menulength) {
            if (this.setMenuItemenable(this.menubar.getItems()[i], menuName, enable)) {
                return true;
            }
            ++i;
        }
        Logger.warning((Object)("Can't find menu : " + menuName));
        return false;
    }

    public boolean isMenuItemEnabled(String menuName) {
        int i = this.checkMenuitemStatus(this.menubar, menuName);
        return i == 1;
    }

    private int checkMenuitemStatus(Menu menu, String menuName) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            int res;
            MenuItem item = menuItemArray[n2];
            if (item.getText().equals(menuName)) {
                return item.isEnabled() ? 1 : 0;
            }
            if (item.getMenu() != null && (res = this.checkMenuitemStatus(item.getMenu(), menuName)) >= 0) {
                return res;
            }
            ++n2;
        }
        return -1;
    }

    private boolean setMenuItemenable(MenuItem menuitem, String menuName, boolean enable) {
        if (menuitem.getText().equals(menuName)) {
            return true;
        }
        if (menuitem.getMenu() == null) {
            return false;
        }
        int menulength = menuitem.getMenu().getItems().length;
        int i = 0;
        while (i < menulength) {
            if (this.setMenuItemenable(menuitem.getMenu().getItems()[i], menuName, enable)) {
                menuitem.getMenu().getItems()[i].setEnabled(enable);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setSourceView(boolean setview) {
        this.sourceView = setview;
    }

    public boolean getSourceView() {
        return this.sourceView;
    }

    public boolean resetReportItemCheck() {
        int i = 0;
        while (i < this.menubar.getItems().length) {
            MenuItem menuitem = this.menubar.getItem(i);
            if (menuitem.getText().equals("View")) {
                int ii = 0;
                while (ii < menuitem.getMenu().getItems().length) {
                    if (menuitem.getMenu().getItem(ii).getText().contains("Report")) {
                        MenuItem submenu = menuitem.getMenu().getItem(ii);
                        submenu.getMenu().getItem(0).setSelection(false);
                        submenu.getMenu().getItem(1).setSelection(false);
                        submenu.getMenu().getItem(2).setSelection(false);
                        return true;
                    }
                    ++ii;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean showSaveWarning() {
        boolean clear = true;
        if (Global.getProject() != null && !Global.getProject().getIsSavedData()) {
            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
            DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.SAVE, 0);
            dialog.setIcon(ImageResources.DIALOG_WARNING_ICON);
            dialog.setMessage("Tracing data is not saved.\nAre you sure to remove it?");
            dialog.setDialog();
            dialog.getSaveButton().addSelectionListener(this.saveButtonListener);
            dialog.open();
            clear = dialog.getResult();
        }
        return clear;
    }

    public void showLoadDialog() {
        FileDialog dialog = new FileDialog(this.currentShell, 4096);
        dialog.setFilterNames(new String[]{"Zip file"});
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setText(MenuBarLabels.FILE_LOAD_DIALOG_TITLE);
        dialog.setFilterPath(PathManager.DA_SAVE_PATH);
        final String result = dialog.open();
        if (result != null) {
            Toolbar.INSTANCE.clearMarkerTimeList();
            RangeDataManager.getInstance().clearMarkerTime();
            RangeDataManager.getInstance().clearTimelineMarker();
            Thread loadthread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String decompresspath = CommandAction.loadFromZip((String)result);
                    OpenTraceProgressManager.getInstance().setSavePath(decompresspath);
                    OpenTraceProgressManager.getInstance().startOpenTraceThread();
                }
            });
            loadthread.run();
        }
    }

    public void showSaveDialog() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        String savefilename = project.getSavePath().substring(project.getSavePath().lastIndexOf(File.separator) + 1);
        FileDialog dialog = new FileDialog(this.currentShell, 8192);
        dialog.setFilterNames(new String[]{"Zip file"});
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setFileName(String.valueOf(savefilename) + ".zip");
        dialog.setText(MenuBarLabels.FILE_SAVE_DIALOG_TITLE);
        dialog.setFilterPath(PathManager.DA_SAVE_PATH);
        String result = dialog.open();
        if (result != null) {
            if (!CommandAction.saveToZip(result)) {
                UIActionHolder.getUIAction().showWarning(AnalyzerLabels.SAVE_FAILED);
            } else {
                this.setMenuItemEnable(MenuBarLabels.FILE_SAVE, false);
                project.setSavedData(true);
            }
        }
    }
}

