/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.range;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.project.callstack.BaseCallstackManager;
import org.tizen.dynamicanalyzer.project.callstack.RangeCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.file.FileChartView;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.memory.MemoryChartView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.network.NetworkChartView;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChartView;
import org.tizen.dynamicanalyzer.ui.range.RangePage;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionSampleDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.RangeProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.WebProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionExitDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionExitDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class RangeDataManager
implements Runnable {
    private static RangeDataManager instance = null;
    private Thread rangeThread = null;
    private Map<Integer, WebProfileDataMaker> webProfileDataMakerMap = null;
    private Map<Integer, ProfileDataMaker> profileDataMakerMap = null;
    private BaseCallstackManager rangeCallstackManager = new RangeCallstackManager();
    private long markerStartTime = 0L;
    private long markerEndTime = 0L;
    private long analysisStartTime = 0L;
    private long analysisEndTime = 0L;
    private List<Long> markerTimeList = new ArrayList<Long>();
    private boolean isBeingAnalyzed = false;

    private RangeDataManager() {
    }

    public void clearTimelineMarker() {
        TimelineChartView TLchartView = (TimelineChartView)AnalyzerUtil.getView(TimelinePage.pageID, TimelineChartView.class.getName());
        NetworkChartView NETchartView = (NetworkChartView)AnalyzerUtil.getView(NetworkPage.pageID, NetworkChartView.class.getName());
        ThreadChartView THRchartView = (ThreadChartView)AnalyzerUtil.getView(ThreadPage.pageID, ThreadChartView.class.getName());
        FileChartView FLchartView = (FileChartView)AnalyzerUtil.getView(FilePage.pageID, FileChartView.class.getName());
        GLChartView GLchartview = (GLChartView)AnalyzerUtil.getView(GLPage.pageID, GLChartView.class.getName());
        MemoryChartView MMchartView = (MemoryChartView)AnalyzerUtil.getView(MemoryPage.pageID, MemoryChartView.class.getName());
        if (TLchartView != null) {
            TLchartView.getChartBoard().getTimeline().getMarkerList().clear();
        }
        if (NETchartView != null) {
            NETchartView.getChartBoard().getTimeline().getMarkerList().clear();
        }
        if (THRchartView != null) {
            THRchartView.getChartBoard().getTimeline().getMarkerList().clear();
        }
        if (FLchartView != null) {
            FLchartView.getChartBoard().getTimeline().getMarkerList().clear();
        }
        if (GLchartview != null) {
            GLchartview.getChartBoard().getTimeline().getMarkerList().clear();
        }
        if (MMchartView != null) {
            MMchartView.getChartBoard().getTimeline().getMarkerList().clear();
        }
    }

    public void clearRange() {
        this.rangeCallstackManager.clear();
        if (this.profileDataMakerMap != null) {
            this.profileDataMakerMap.clear();
        }
        if (this.webProfileDataMakerMap != null) {
            this.webProfileDataMakerMap.clear();
        }
        SummaryDataManager.getInstance().getLeakDataMaker().clearLeakDataForRange();
    }

    public void initRange() {
        this.clearRange();
        this.analysisStartTime = 0L;
        this.analysisEndTime = 0L;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RangeDataManager.this.isBeingAnalyzed = false;
                DATabComposite mainTab = AnalyzerUtil.getMainTab();
                if (mainTab.getView(RangePage.pageID) != null) {
                    mainTab.removeView(RangePage.pageID, true);
                }
            }
        });
    }

    public void startRangeThread() {
        this.clearRange();
        if (this.rangeThread == null || !this.rangeThread.isAlive()) {
            this.rangeThread = new Thread(null, RangeDataManager.getInstance(), "Range data manager thread");
            this.rangeThread.start();
            this.analysisStartTime = this.markerStartTime;
            this.analysisEndTime = this.markerEndTime;
            this.isBeingAnalyzed = true;
        }
    }

    public void startRangeAnalysis() {
        if (!this.isBeingAnalyzed) {
            DATabComposite mainTab = AnalyzerUtil.getMainTab();
            RangePage rangePage = new RangePage(mainTab.getContentComposite(), 0);
            DATabButton rangeTab = mainTab.addView(null, (DABaseComposite)rangePage, true, true);
            rangeTab.addCloseButtonListener(new DACustomButtonClickEventListener(){

                public void handleClickEvent(DACustomButton button) {
                    RangeDataManager.getInstance().initRange();
                }
            });
            this.startRangeThread();
        } else {
            this.startRangeThread();
        }
    }

    public void stopUpdateLogThread() {
        if (this.rangeThread != null && this.rangeThread.isAlive()) {
            this.rangeThread.interrupt();
        }
    }

    public static synchronized RangeDataManager getInstance() {
        if (instance == null) {
            instance = new RangeDataManager();
        }
        return instance;
    }

    public List<Integer> getPidsOfProfileDataMakerMap() {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        pids.addAll(this.getProfileDataMakerMap().keySet());
        return pids;
    }

    public synchronized Map<Integer, ProfileDataMaker> getProfileDataMakerMap() {
        if (this.profileDataMakerMap == null) {
            this.profileDataMakerMap = new HashMap<Integer, ProfileDataMaker>();
        }
        return this.profileDataMakerMap;
    }

    public ProfileDataMaker getProfileDataMakerByPid(int pid) {
        ProfileDataMaker profileDataMaker = this.getProfileDataMakerMap().get(pid);
        if (profileDataMaker == null) {
            profileDataMaker = new RangeProfileDataMaker(this.rangeCallstackManager);
            profileDataMaker.setPid(pid);
            this.getProfileDataMakerMap().put(pid, profileDataMaker);
        }
        return profileDataMaker;
    }

    public List<Integer> getPidsOfWebProfileDataMakerMap() {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        pids.addAll(this.getWebProfileDataMakerMap().keySet());
        return pids;
    }

    public synchronized Map<Integer, WebProfileDataMaker> getWebProfileDataMakerMap() {
        if (this.webProfileDataMakerMap == null) {
            this.webProfileDataMakerMap = new HashMap<Integer, WebProfileDataMaker>();
        }
        return this.webProfileDataMakerMap;
    }

    public WebProfileDataMaker getWebProfileDataMakerByPid(int pid) {
        WebProfileDataMaker webProfileDataMaker = this.getWebProfileDataMakerMap().get(pid);
        if (webProfileDataMaker == null) {
            webProfileDataMaker = new WebProfileDataMaker(pid);
            this.getWebProfileDataMakerMap().put(pid, webProfileDataMaker);
        }
        return webProfileDataMaker;
    }

    public void setMarkerStartTime(long startTime) {
        this.markerStartTime = startTime;
        if (startTime > this.markerEndTime) {
            this.markerEndTime = startTime;
        }
    }

    public void setMarkerEndTime(long endTime) {
        this.markerEndTime = endTime;
        if (endTime < this.markerStartTime) {
            this.markerStartTime = endTime;
        }
    }

    public void clearMarkerTime() {
        if (this.markerTimeList != null) {
            this.markerTimeList.clear();
        }
    }

    public void removeMarkerTime(long time) {
        int i = 0;
        while (i < this.markerTimeList.size()) {
            if (this.markerTimeList.get(i) == time) {
                this.markerTimeList.remove(i);
            }
            ++i;
        }
    }

    public void addMarkerTime(long time) {
        if (this.markerTimeList != null && !this.markerTimeList.contains(time)) {
            this.markerTimeList.add(time);
        }
    }

    public List<Long> getMarerTimeList() {
        return this.markerTimeList;
    }

    public void setRangeFromMarkerList(long time) {
        if (this.markerTimeList != null && this.markerTimeList.size() >= 1 && !this.markerTimeList.contains(time)) {
            int findIndex = -1;
            int i = 0;
            while (i < this.markerTimeList.size()) {
                if (this.markerTimeList.get(i) > time) {
                    findIndex = i;
                    break;
                }
                ++i;
            }
            if (findIndex == 0) {
                this.markerStartTime = 0L;
                this.markerEndTime = this.markerTimeList.get(findIndex);
            } else if (findIndex == -1) {
                this.markerStartTime = this.markerTimeList.get(this.markerTimeList.size() - 1);
                this.markerEndTime = Toolbar.INSTANCE.getTime();
            } else {
                this.markerStartTime = this.markerTimeList.get(findIndex - 1);
                this.markerEndTime = this.markerTimeList.get(findIndex);
            }
            Toolbar.INSTANCE.setDlogSelection(false);
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(TimelinePage.timelineViewID, this.markerStartTime, this.markerEndTime, null, null));
        }
    }

    public long getMarkerStartTime() {
        return this.markerStartTime;
    }

    public long getMarkerEndTime() {
        return this.markerEndTime;
    }

    public long getAnalysisStartTime() {
        return this.analysisStartTime;
    }

    public long getAnalysisEndTime() {
        return this.analysisEndTime;
    }

    public boolean isBeingAnalyzed() {
        return this.isBeingAnalyzed;
    }

    public boolean isAnalyzable() {
        return this.markerStartTime >= 0L && this.markerEndTime >= 0L && (this.markerStartTime != this.analysisStartTime || this.markerEndTime != this.analysisEndTime);
    }

    public boolean isClearable() {
        return this.markerStartTime >= 0L || this.markerEndTime >= 0L;
    }

    @Override
    public void run() {
        block28: {
            ResultSet rsEntry = null;
            ResultSet rsExit = null;
            ResultSet rsSample = null;
            PriorityQueue<ProfileData> pQueue = new PriorityQueue<ProfileData>(3, new Comparator<ProfileData>(){

                @Override
                public int compare(ProfileData pData1, ProfileData pData2) {
                    long time2;
                    long time1 = pData1.getTime();
                    if (time1 < (time2 = pData2.getTime())) {
                        return -1;
                    }
                    if (time1 > time2) {
                        return 1;
                    }
                    return 0;
                }
            });
            try {
                try {
                    String query = String.format(FunctionEntryDBTable.SELECT_QUERY, this.markerStartTime, this.markerEndTime);
                    rsEntry = SqlConnectionManager.executeQueryRS(query);
                    query = String.format(FunctionExitDBTable.SELECT_QUERY, this.markerStartTime, this.markerEndTime);
                    rsExit = SqlConnectionManager.executeQueryRS(query);
                    query = String.format(FunctionSampleDBTable.SELECT_QUERY, this.markerStartTime, this.markerEndTime);
                    rsSample = SqlConnectionManager.executeQueryRS(query);
                    if (rsEntry == null || rsExit == null || rsSample == null) {
                        Logger.error((Object)"failed to query function profiling data in range");
                    } else {
                        ProfileData top;
                        if (rsEntry.next()) {
                            ProfileData pEntry = this.makeFunctionProfileData(8, rsEntry);
                            pQueue.offer(pEntry);
                        }
                        if (rsExit.next()) {
                            ProfileData pExit = this.makeFunctionProfileData(9, rsExit);
                            pQueue.offer(pExit);
                        }
                        if (rsSample.next()) {
                            ProfileData pSample = this.makeSampleProfileData(rsSample);
                            pQueue.offer(pSample);
                        }
                        block9: while ((top = pQueue.poll()) != null) {
                            ProfileDataMaker profileDataMaker = this.getProfileDataMakerByPid(top.getPid());
                            switch (top.getMsgID()) {
                                case 8: {
                                    if (rsEntry.next()) {
                                        ProfileData pEntry = this.makeFunctionProfileData(8, rsEntry);
                                        pQueue.offer(pEntry);
                                    }
                                    this.rangeCallstackManager.makeUserCallstack(top, profileDataMaker);
                                    continue block9;
                                }
                                case 9: {
                                    if (rsExit.next()) {
                                        ProfileData pExit = this.makeFunctionProfileData(9, rsExit);
                                        pQueue.offer(pExit);
                                    }
                                    this.rangeCallstackManager.makeUserCallstack(top, profileDataMaker);
                                    continue block9;
                                }
                                case 4: {
                                    if (rsSample.next()) {
                                        ProfileData pSample = this.makeSampleProfileData(rsSample);
                                        pQueue.offer(pSample);
                                    }
                                    profileDataMaker.makeFunctionUsageProfileData(top);
                                    continue block9;
                                }
                            }
                            Logger.error((Object)"Wrong data from selecting function profiling data inside range");
                        }
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    if (rsEntry != null) {
                        SqlConnectionManager.releaseResultSet(rsEntry);
                    }
                    if (rsExit != null) {
                        SqlConnectionManager.releaseResultSet(rsExit);
                    }
                    if (rsSample != null) {
                        SqlConnectionManager.releaseResultSet(rsSample);
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (rsEntry != null) {
                    SqlConnectionManager.releaseResultSet(rsEntry);
                }
                if (rsExit != null) {
                    SqlConnectionManager.releaseResultSet(rsExit);
                }
                if (rsSample != null) {
                    SqlConnectionManager.releaseResultSet(rsSample);
                }
                throw throwable;
            }
            if (rsEntry != null) {
                SqlConnectionManager.releaseResultSet(rsEntry);
            }
            if (rsExit != null) {
                SqlConnectionManager.releaseResultSet(rsExit);
            }
            if (rsSample != null) {
                SqlConnectionManager.releaseResultSet(rsSample);
            }
        }
        this.makeWebProfileDataForRange();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        SummaryDataManager.getInstance().getLeakDataMaker().makeLeakDataForRange(this.markerStartTime, this.markerEndTime, selectedPid);
        AnalyzerUtil.changePage(RangePage.pageID);
        final DAPageComposite page = AnalyzerManager.getCurrentPage();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                page.updateView();
            }
        });
    }

    private ProfileData makeFunctionProfileData(int id, ResultSet rs) {
        ProfileData profileData = null;
        try {
            long seq = rs.getLong(Function.SEQ.index);
            int pid = rs.getInt(Function.PID.index);
            int tid = rs.getInt(Function.TID.index);
            int functionId = rs.getInt(Function.FUNCTIONID.index);
            int binaryId = rs.getInt(Function.BINARYID.index);
            long time = rs.getLong(Function.TIME.index);
            long callerPcAddr = rs.getLong(Function.CALLERPCADDR.index);
            long pcAddr = rs.getLong(Function.PCADDR.index);
            profileData = new ProfileData(id, seq, pid, tid, functionId, binaryId, time, callerPcAddr, pcAddr);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return profileData;
    }

    private ProfileData makeSampleProfileData(ResultSet rs) {
        ProfileData profileData = null;
        try {
            long time = rs.getLong(Sample.TIME.index);
            int pid = rs.getInt(Sample.PID.index);
            int tid = rs.getInt(Sample.TID.index);
            long pcAddr = rs.getLong(Sample.PCADDR.index);
            profileData = new ProfileData(time, pid, tid, pcAddr);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return profileData;
    }

    private WebProfileData makeWebProfileData(int id, ResultSet rs) {
        WebProfileData profileData = null;
        try {
            long seq = rs.getLong(1);
            int pid = rs.getInt(2);
            int tid = rs.getInt(3);
            int functionLineNumber = rs.getInt(4);
            String functionName = rs.getString(5);
            String functionURL = rs.getString(6);
            long time = rs.getLong(7);
            profileData = new WebProfileData(id, seq, pid, tid, functionLineNumber, functionName, functionURL, time);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return profileData;
    }

    private void makeWebProfileDataForRange() {
        block22: {
            ResultSet rsWebEntry = null;
            ResultSet rsWebExit = null;
            PriorityQueue<WebProfileData> pWebQueue = new PriorityQueue<WebProfileData>(3, new Comparator<WebProfileData>(){

                @Override
                public int compare(WebProfileData pData1, WebProfileData pData2) {
                    long time2;
                    long time1 = pData1.getTime();
                    if (time1 < (time2 = pData2.getTime())) {
                        return -1;
                    }
                    if (time1 > time2) {
                        return 1;
                    }
                    return 0;
                }
            });
            try {
                try {
                    String query = String.format(WebFunctionEntryDBTable.SELECT_QUERY, this.markerStartTime, this.markerEndTime);
                    rsWebEntry = SqlConnectionManager.executeQueryRS(query);
                    query = String.format(WebFunctionExitDBTable.SELECT_QUERY, this.markerStartTime, this.markerEndTime);
                    rsWebExit = SqlConnectionManager.executeQueryRS(query);
                    if (rsWebEntry == null || rsWebExit == null) {
                        Logger.error((Object)"failed to query web function profiling data in range");
                    } else {
                        WebProfileData top;
                        if (rsWebEntry.next()) {
                            WebProfileData pWebEntry = this.makeWebProfileData(21, rsWebEntry);
                            pWebQueue.offer(pWebEntry);
                        }
                        if (rsWebExit.next()) {
                            WebProfileData pWebExit = this.makeWebProfileData(22, rsWebExit);
                            pWebQueue.offer(pWebExit);
                        }
                        block8: while ((top = pWebQueue.poll()) != null) {
                            WebProfileDataMaker profiler = this.getWebProfileDataMakerByPid(top.getPID());
                            switch (top.getMsgID()) {
                                case 21: {
                                    if (rsWebEntry.next()) {
                                        WebProfileData pWebEntry = this.makeWebProfileData(21, rsWebEntry);
                                        pWebQueue.offer(pWebEntry);
                                    }
                                    profiler.makeWebFunctionUsageProfileData(top);
                                    continue block8;
                                }
                                case 22: {
                                    if (rsWebExit.next()) {
                                        WebProfileData pWebExit = this.makeWebProfileData(22, rsWebExit);
                                        pWebQueue.offer(pWebExit);
                                    }
                                    profiler.makeWebFunctionUsageProfileData(top);
                                    continue block8;
                                }
                            }
                            Logger.error((Object)"Wrong data from selecting web function profiling data inside range");
                        }
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    if (rsWebEntry != null) {
                        SqlConnectionManager.releaseResultSet(rsWebEntry);
                    }
                    if (rsWebExit != null) {
                        SqlConnectionManager.releaseResultSet(rsWebExit);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (rsWebEntry != null) {
                    SqlConnectionManager.releaseResultSet(rsWebEntry);
                }
                if (rsWebExit != null) {
                    SqlConnectionManager.releaseResultSet(rsWebExit);
                }
                throw throwable;
            }
            if (rsWebEntry != null) {
                SqlConnectionManager.releaseResultSet(rsWebEntry);
            }
            if (rsWebExit != null) {
                SqlConnectionManager.releaseResultSet(rsWebExit);
            }
        }
    }

    private static enum Function {
        SEQ(1),
        PID(2),
        TID(3),
        FUNCTIONID(4),
        BINARYID(5),
        TIME(6),
        CALLERPCADDR(7),
        PCADDR(8);

        public final int index;

        private Function(int index) {
            this.index = index;
        }
    }

    private static enum Sample {
        TIME(1),
        PID(2),
        TID(3),
        PCADDR(4);

        public final int index;

        private Sample(int index) {
            this.index = index;
        }
    }
}

