/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.LeakDetector;

public class LeakData {
    public static final int INDEX_LEAK_SEQ = 1;
    public static final int INDEX_ID = 2;
    public static final int INDEX_SEQ = 3;
    public static final int INDEX_TIME = 4;
    public static final int INDEX_API_NAME = 5;
    public static final int INDEX_PID = 6;
    public static final int INDEX_ADDR = 7;
    public static final int INDEX_CALLER_PCADDR = 8;
    public static final int INDEX_PARAMETER = 9;
    public static final int INDEX_RETURN = 10;
    public static final int INDEX_LIB_NAME = 11;
    public static final int INDEX_KEY = 12;
    public static final int INDEX_PARENT_KEY = 13;
    private static int logNum = 0;
    private int leakSeq = -1;
    private int id = -1;
    private long seq = -1L;
    private long time = -1L;
    private String apiName = null;
    private int pid = -1;
    private long addr = -1L;
    private long callerPcAddr = -1L;
    private String param = null;
    private String retValue = null;
    private String libName = null;
    private int key = -1;
    private int parentKey = -1;
    private List<LeakData> children;

    public LeakData(LogData log, LeakDetector leakDetector) {
        this.leakSeq = leakDetector.getLeakSeq();
        leakDetector.increaseLeakSeq();
        this.key = log.getKey();
        this.seq = log.getSeq();
        this.id = log.getMsgID();
        this.time = log.getTime();
        ProbeCommonData pcd = (ProbeCommonData)log;
        this.apiName = pcd.getApiName();
        this.param = pcd.getArgs();
        this.retValue = pcd.getReturn();
        this.callerPcAddr = pcd.getCallerPcAddr();
        if (log instanceof MemoryData) {
            this.addr = ((MemoryData)log).getAddress();
        }
        this.pid = log.getPid();
        this.libName = pcd.getLibName();
    }

    public LeakData(List<String> loadData) {
        this.leakSeq = Integer.parseInt(loadData.get(1));
        this.id = Integer.parseInt(loadData.get(2));
        this.seq = Long.parseLong(loadData.get(3));
        this.time = Long.parseLong(loadData.get(4));
        this.apiName = loadData.get(5);
        this.pid = Integer.parseInt(loadData.get(6));
        this.addr = Long.parseLong(loadData.get(7));
        this.callerPcAddr = Long.parseLong(loadData.get(8));
        this.param = loadData.get(9);
        this.retValue = loadData.get(10);
        this.libName = loadData.get(11);
        this.key = Integer.parseInt(loadData.get(12));
        this.parentKey = Integer.parseInt(loadData.get(13));
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public long getAddr() {
        return this.addr;
    }

    public void setAddr(long addr) {
        this.addr = addr;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getName() {
        return this.apiName;
    }

    public void setName(String name) {
        this.apiName = name;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getRet() {
        return this.retValue;
    }

    public void setRet(String ret) {
        this.retValue = ret;
    }

    public int getLeakSeq() {
        return this.leakSeq;
    }

    public void setLeakSeq(int leakSeq) {
        this.leakSeq = leakSeq;
    }

    public int getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(int parentKey) {
        this.parentKey = parentKey;
    }

    public long getCallerPc() {
        return this.callerPcAddr;
    }

    public void setCallerPc(long callerPc) {
        this.callerPcAddr = callerPc;
    }

    public List<LeakData> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<LeakData>();
        }
        return this.children;
    }

    public void setChildren(List<LeakData> children) {
        this.children = children;
    }

    public void addChild(LeakData child) {
        this.getChildren().add(child);
    }

    public void removeChild(int key) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            if (key == this.children.get(i).getKey()) {
                this.children.remove(i);
                break;
            }
            ++i;
        }
    }

    public static int getLogNum() {
        return logNum++;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public String getType() {
        return LogDataFactory.getLogFormatName(this.id);
    }
}

