/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.error.ErrorCodeManager;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.swap.model.data.SyncData;
import org.tizen.dynamicanalyzer.ui.thread.ThreadAPIListView;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncDataEvent;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAApiListTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ThreadAPIListTable
extends DAApiListTableComposite {
    public ThreadAPIListTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = ThreadAPIListTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                long startTime = 0L;
                long endTime = 0L;
                int i = 0;
                while (i < items.length) {
                    DATableDataFormat dataFormat = (DATableDataFormat)items[i].getData();
                    long itemTime = dataFormat.getLogData().getTime();
                    if (0L == startTime) {
                        startTime = itemTime;
                    }
                    if (startTime > itemTime) {
                        startTime = itemTime;
                    }
                    if (endTime < itemTime) {
                        endTime = itemTime;
                    }
                    ++i;
                }
                DASelectionData selData = new DASelectionData(ThreadPage.listViewID, startTime, endTime, items, (Control)ThreadAPIListTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = Long.parseLong((String)markerData.get(1));
                AnalyzerUtil.addMarker(markerTime);
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        ThreadAPIListView view = (ThreadAPIListView)AnalyzerManager.getCurrentPage().getView(ThreadPage.listViewID);
        if (view == null) {
            return input;
        }
        ThreadPageData data = view.getPageData();
        if (data == null) {
            return input;
        }
        int selectID = -1;
        ArrayList<ProbeCommonData> syncAPIList = new ArrayList<ProbeCommonData>();
        List<FilterProperty> filterList = this.getFilterPropertyList();
        if (data instanceof ThreadPageThreadData) {
            ThreadPageThreadData tData = (ThreadPageThreadData)data;
            selectID = tData.getThreadDataID();
        } else if (data instanceof ThreadPageSyncData) {
            ThreadPageSyncData sData = (ThreadPageSyncData)data;
            selectID = sData.getSyncDataID();
            syncAPIList.addAll(this.getSyncAPIOfNotInsert(selectID, filterList));
        } else {
            Logger.debug((Object)"failed to selectionD data in Thread Page API table");
            return null;
        }
        syncAPIList.addAll(this.selectAPIListFromDB(data, selectID, filterList));
        this.sortListByTime(syncAPIList);
        for (ProbeCommonData apiData : syncAPIList) {
            String timeText = Formatter.toTimeFormat(apiData.getTime());
            String apiName = apiData.getApiName();
            String errMsg = ErrorCodeManager.getInatance().getErrorCode(apiData.getErrno()).name();
            if (errMsg == null) {
                errMsg = "undefined error code";
            }
            if (!this.filterAfterDB(filterList, timeText, apiName, errMsg)) continue;
            ArrayList<String> contentText = new ArrayList<String>();
            ArrayList<String> contentData = new ArrayList<String>();
            contentText.add(0, String.valueOf(apiData.getSeq()));
            contentData.add(String.valueOf(apiData.getSeq()));
            contentText.add(timeText);
            contentData.add(Long.toString(apiData.getTime()));
            contentText.add(Integer.toString(apiData.getPid()));
            contentData.add(Integer.toString(apiData.getPid()));
            contentText.add(Long.toString(apiData.getTid()));
            contentData.add(Long.toString(apiData.getTid()));
            contentText.add(apiName);
            contentData.add(apiName);
            contentText.add(apiData.getArgs());
            contentData.add(apiData.getArgs());
            contentText.add(apiData.getReturn());
            contentData.add(apiData.getReturn());
            contentText.add(errMsg);
            contentData.add(errMsg);
            DATableDataFormat tableData = new DATableDataFormat(apiData.getSeq());
            tableData.setLogData(apiData);
            tableData.getData().addAll(contentData);
            TableInput tableInput = new TableInput();
            tableInput.setText(contentText);
            tableInput.setData(tableData);
            if (!errMsg.contains("SUCCESS")) {
                tableInput.setFailed(true);
            }
            input.add(tableInput);
            if (apiData.getTime() < view.getAnalysisStartTime() || apiData.getTime() > view.getAnaysisEndTime()) continue;
            tableInput.setInRange(true);
        }
        return input;
    }

    /*
     * Exception decompiling
     */
    private List<ProbeCommonData> selectAPIListFromDB(ThreadPageData data, int selectID, List<FilterProperty> filterList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ProbeCommonData> getSyncAPIOfNotInsert(int selectID, List<FilterProperty> filterList) {
        ArrayList<ProbeCommonData> returnList = new ArrayList<ProbeCommonData>();
        List<ThreadPageSyncDataEvent> notInsertList = ThreadDataManager.getInstance().getSyncDataMaker().getNotInsertSyncEventList();
        for (ThreadPageSyncDataEvent event : notInsertList) {
            SyncData probeData;
            if (event.getSyncDataID() != selectID || !this.filterInSyncData(filterList, probeData = (SyncData)event.getContents())) continue;
            returnList.add(probeData);
        }
        return returnList;
    }

    private void sortListByTime(List<ProbeCommonData> list) {
        Comparator<ProbeCommonData> comparator = new Comparator<ProbeCommonData>(){

            @Override
            public int compare(ProbeCommonData arg0, ProbeCommonData arg1) {
                if (arg0.getTime() > arg1.getTime()) {
                    return 1;
                }
                if (arg0.getTime() < arg1.getTime()) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    private ProbeCommonData makeProbeCommonData(ResultSet rs) {
        ProbeCommonData pData = null;
        try {
            long seq = rs.getLong(API.SEQ.index);
            long time = rs.getLong(API.APICALLTIME.index);
            int apiID = rs.getInt(API.APIID.index);
            int pid = rs.getInt(API.PID.index);
            int tid = rs.getInt(API.TID.index);
            String args = rs.getString(API.ARGUMENT.index);
            String returnValue = rs.getString(API.RETURN.index);
            int errorno = rs.getInt(API.ERRORNO.index);
            pData = new ProbeCommonData(seq, time, apiID, pid, tid, args, returnValue, errorno);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return pData;
    }

    @Override
    public boolean[] getColumnVisibility() {
        if (this.table == null) {
            return null;
        }
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        boolean[] columnsVisibility = new boolean[size];
        columnsVisibility[0] = false;
        int i = 1;
        while (i < size) {
            columnsVisibility[i] = columns[i].getVisible();
            ++i;
        }
        return columnsVisibility;
    }

    private boolean filterInSyncData(List<FilterProperty> filterList, ProbeCommonData apiData) {
        int i = 0;
        while (i < filterList.size()) {
            FilterProperty prop = filterList.get(i);
            String value = prop.getKeyWord().toLowerCase();
            switch (prop.getColumnIndex()) {
                case 1: {
                    String time = Formatter.toTimeFormat(apiData.getTime());
                    if (time.toLowerCase().contains(value)) break;
                    return false;
                }
                case 2: {
                    String pid = Integer.toString(apiData.getPid());
                    if (pid.contains(value)) break;
                    return false;
                }
                case 3: {
                    String tid = Integer.toString(apiData.getTid());
                    if (tid.toLowerCase().contains(value)) break;
                    return false;
                }
                case 4: {
                    String apiName = apiData.getApiName();
                    if (apiName.toLowerCase().contains(value)) break;
                    return false;
                }
                case 5: {
                    String parameter = apiData.getArgs();
                    if (parameter.toLowerCase().contains(value)) break;
                    return false;
                }
                case 6: {
                    String returnValue = apiData.getReturn();
                    if (returnValue.toLowerCase().contains(value)) break;
                    return false;
                }
                case 7: {
                    String errMsg = ErrorCodeManager.getInatance().getErrorCode(apiData.getErrno()).name();
                    if (errMsg.toLowerCase().contains(value)) break;
                    return false;
                }
                default: {
                    Logger.warning((Object)("unsupported filter column : " + prop.getColumnIndex() + ", " + value));
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean filterAfterDB(List<FilterProperty> filterList, String time, String apiName, String errMsg) {
        int i = 0;
        while (i < filterList.size()) {
            FilterProperty prop = filterList.get(i);
            String value = prop.getKeyWord().toLowerCase();
            switch (prop.getColumnIndex()) {
                case 1: {
                    if (time.toLowerCase().contains(value)) break;
                    return false;
                }
                case 4: {
                    if (apiName.toLowerCase().contains(value)) break;
                    return false;
                }
                case 7: {
                    if (errMsg.toLowerCase().contains(value)) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private String convertFilterProperty2WhereQuery(List<FilterProperty> filterList) {
        String filterCondition = "";
        int i = 0;
        while (i < filterList.size()) {
            FilterProperty prop = filterList.get(i);
            String queryPrefix = this.getFilteredColumnName(prop.getColumnIndex());
            if (queryPrefix != null) {
                filterCondition = String.valueOf(filterCondition) + " and " + this.makeFilterWhereClause(queryPrefix, prop.getKeyWord());
            }
            ++i;
        }
        return filterCondition;
    }

    @Override
    protected String getFilteredColumnName(int index) {
        String columnName = null;
        switch (index) {
            case 2: {
                columnName = "PID";
                break;
            }
            case 3: {
                columnName = "TID";
                break;
            }
            case 5: {
                columnName = this.addLowerOperation("ARGUMENT");
                break;
            }
            case 6: {
                columnName = this.addLowerOperation("RETURN_VALUE");
                break;
            }
        }
        return columnName;
    }

    private static enum API {
        SEQ(1),
        APICALLTIME(2),
        APIID(3),
        PID(4),
        TID(5),
        ARGUMENT(6),
        RETURN(7),
        ERRORNO(8);

        public final int index;

        private API(int index) {
            this.index = index;
        }
    }
}

