/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread;

import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ThreadDetailInfoView
extends DAViewComposite {
    private Composite contents = null;
    private Text detailText = null;
    private static final String leftFormAttachment = "  ";
    private static final String heightFormAttachment = "\n\n";
    public static final int LEFT_MARGIN = 10;
    public static final int HEIGHT_MARGIN = 20;
    private String tid = AnalyzerLabels.EMPTY_STRING;
    private String type = AnalyzerLabels.EMPTY_STRING;
    private String funcName = AnalyzerLabels.EMPTY_STRING;
    private String className = AnalyzerLabels.EMPTY_STRING;
    private String startTime = AnalyzerLabels.EMPTY_STRING;
    private String endTime = AnalyzerLabels.EMPTY_STRING;
    private String attrType = AnalyzerLabels.EMPTY_STRING;
    private ThreadPageData item = null;

    private void init() {
        this.tid = AnalyzerLabels.EMPTY_STRING;
        this.type = AnalyzerLabels.EMPTY_STRING;
        this.funcName = AnalyzerLabels.EMPTY_STRING;
        this.className = AnalyzerLabels.EMPTY_STRING;
        this.startTime = AnalyzerLabels.EMPTY_STRING;
        this.endTime = AnalyzerLabels.EMPTY_STRING;
        this.attrType = AnalyzerLabels.EMPTY_STRING;
        this.detailText.setText("");
    }

    public ThreadDetailInfoView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(ThreadPageLabels.THREAD_DETAILS_TITLE);
        Composite detailCom = this.getContentArea();
        detailCom.setBackground(ColorResources.VIEW_BG_COLOR);
        detailCom.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.bottom = new FormAttachment(100, 0);
        detailCom.setLayoutData((Object)labelData);
        this.contents = detailCom;
        this.contents.setBackground(ColorResources.VIEW_BG_COLOR);
        this.contents.setLayout((Layout)new FormLayout());
        this.detailText = new Text(this.contents, 2816);
        this.detailText.setBackground(ColorResources.VIEW_BG_COLOR);
        this.detailText.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.detailText.setFont(FontResources.DETAIL_INFO_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)this.contents, 0);
        buttonData.left = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.detailText.setLayoutData((Object)buttonData);
    }

    private void updateDetails() {
        this.init();
        if (this.item instanceof ThreadPageThreadData) {
            this.tid = Integer.toString(this.item.getTid());
            this.type = ((ThreadPageThreadData)this.item).getTypeString();
            String str = ((ThreadPageThreadData)this.item).getThreadFuncName();
            if (str != null && !str.equals("")) {
                this.funcName = str;
            }
            if ((str = ((ThreadPageThreadData)this.item).getThreadClassName()) != null && !str.equals("")) {
                this.className = str;
            }
            if ((str = ((ThreadPageThreadData)this.item).getStartTimeString()) != null && !str.equals("")) {
                this.startTime = str;
            }
            if ((str = ((ThreadPageThreadData)this.item).getEndTimeString()) != null && !str.equals("")) {
                this.endTime = str;
            }
            if ((str = this.item.getAttrType()) != null && !str.equals("")) {
                this.attrType = str;
            }
        } else if (this.item instanceof ThreadPageSyncData) {
            String str;
            this.type = ((ThreadPageSyncData)this.item).getTypeString();
            ThreadPageSyncData syncItem = (ThreadPageSyncData)this.item;
            List<ThreadPageSyncData> children = syncItem.getChildren();
            int childrenSize = children.size();
            if (childrenSize == 0) {
                this.tid = Integer.toString(this.item.getTid());
            }
            if ((str = this.item.getAttrType()) != null && !str.equals("")) {
                this.attrType = str;
            }
        }
        StringBuffer strDetailView = new StringBuffer("\n");
        this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_TYPE) + this.type);
        if (this.tid != null && !this.tid.equals("")) {
            this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_TID) + this.tid);
        }
        if (this.type.equals(ThreadPageLabels.THREAD_ITEM_TYPE_TIZEN)) {
            if (this.className != null && !this.className.equals("")) {
                this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_CLASSNAME) + this.className);
            }
        } else if (this.funcName != null && !this.funcName.equals("")) {
            this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_FUNCNAME) + this.funcName);
        }
        if (this.startTime != null && !this.startTime.equals("")) {
            this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_STARTTIME) + this.startTime);
        }
        if (this.endTime != null && !this.endTime.equals("")) {
            this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_ENDTIME) + this.endTime);
        }
        if (this.attrType != null && !this.attrType.equals("")) {
            this.addDetailInfo(strDetailView, String.valueOf(ThreadPageLabels.THREAD_DETAILS_ATTRTYPE) + this.attrType);
        }
        this.detailText.setText(strDetailView.toString());
        this.detailText.redraw();
    }

    private void addDetailInfo(StringBuffer strDetailView, String info) {
        strDetailView.append(leftFormAttachment + info + heightFormAttachment);
    }

    private boolean isChange() {
        if (this.item instanceof ThreadPageThreadData) {
            if (this.item.getTid() != -1 && !this.tid.equals(Integer.toString(this.item.getTid()))) {
                return true;
            }
            if (!this.type.equals(((ThreadPageThreadData)this.item).getTypeString())) {
                return true;
            }
            if (!this.funcName.equals(((ThreadPageThreadData)this.item).getThreadFuncName())) {
                return true;
            }
            if (!this.className.equals(((ThreadPageThreadData)this.item).getThreadClassName())) {
                return true;
            }
            if (!this.startTime.equals(((ThreadPageThreadData)this.item).getStartTimeString())) {
                return true;
            }
            if (!this.endTime.equals(((ThreadPageThreadData)this.item).getEndTimeString())) {
                return true;
            }
            if (!this.attrType.equals(this.item.getAttrType())) {
                return true;
            }
        } else if (this.item instanceof ThreadPageSyncData) {
            if (!this.tid.equals(Integer.toString(this.item.getTid()))) {
                return true;
            }
            if (!this.attrType.equals(this.item.getAttrType())) {
                return true;
            }
        }
        return false;
    }

    public void updateView() {
        if (this.isChange()) {
            this.updateDetails();
        }
    }

    public void updateView(DAViewData vdata) {
        if (vdata.getViewID().equals(TimelinePage.timelineViewID)) {
            return;
        }
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData data = (DASelectionData)vdata;
        String id = data.getViewID();
        if (!id.equals(ThreadPage.chartViewID)) {
            return;
        }
        this.item = data.getData() instanceof ThreadPageData ? (ThreadPageData)data.getData() : null;
        this.updateDetails();
    }

    public Control getControl() {
        return this.contents;
    }

    public void clear() {
        this.init();
        this.item = null;
        this.detailText.redraw();
    }
}

