/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline;

import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallstackView;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.toolbar.replay.data.ReplayDataManager;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class TimelinePage
extends DAPageComposite {
    public static final String pageID = TimelinePage.class.getName();
    public static final String timelineViewID = TimelineChartView.class.getName();
    public static final String calltraceViewID = CallTraceView.class.getName();
    SashForm baseForm;
    SashForm topForm;
    SashForm bottomForm;
    TimelineChartView timelineChartView;
    TimelineTableView timelineTableView;
    boolean isDetailMode = true;
    int tableHeight = -1;
    int tableWeight = 65;
    boolean wasSashCreated = false;

    public TimelinePage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_TIMELINE);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_TIMELINE_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setForeground(ColorResources.WHITE);
        this.baseForm.setBackground(ColorResources.WHITE);
        this.topForm = new SashForm((Composite)this.baseForm, 512);
        this.timelineChartView = new TimelineChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)this.timelineChartView);
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        SashForm bottomLeftForm = new SashForm((Composite)this.bottomForm, 0);
        bottomLeftForm.setForeground(ColorResources.WHITE);
        bottomLeftForm.setLayout((Layout)new FillLayout());
        SashForm bottomRightForm = new SashForm((Composite)this.bottomForm, 0);
        bottomRightForm.setForeground(ColorResources.WHITE);
        bottomRightForm.setLayout((Layout)new FillLayout());
        this.timelineTableView = new TimelineTableView((Composite)bottomLeftForm, 0);
        this.addView((DABaseComposite)this.timelineTableView);
        DATabComposite timelineCallStackTableView = new DATabComposite((Composite)bottomRightForm, 0, false, true);
        CallstackView callstack = new CallstackView(timelineCallStackTableView.getContentComposite(), 0);
        timelineCallStackTableView.addView((DABaseComposite)callstack, false);
        this.addView((DABaseComposite)callstack);
        this.addView((DABaseComposite)timelineCallStackTableView);
        this.topForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        bottomLeftForm.setSashWidth(2);
        bottomRightForm.setSashWidth(2);
        this.bottomForm.setWeights(new int[]{this.tableWeight, 100 - this.tableWeight});
        this.addTableWeightListener();
    }

    private void addHeightWeightListener() {
        if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    TimelinePage.this.tableHeight = TimelinePage.this.baseForm.getWeights()[1] * TimelinePage.this.baseForm.getSize().y / 1000;
                }
            });
            this.wasSashCreated = true;
        }
    }

    private void addTableWeightListener() {
        ((SashForm)this.bottomForm.getChildren()[0]).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TimelinePage.this.resizeTableButton();
            }
        });
    }

    public Composite getTopTable() {
        DAViewComposite view = (DAViewComposite)this.timelineTableView.getTopComposite();
        Composite comp = (Composite)view.getControl();
        return comp;
    }

    public TimelineChartView getTimelineChartView() {
        return this.timelineChartView;
    }

    public TimelineTableView getTimelineTableView() {
        return this.timelineTableView;
    }

    public SashForm getBaseForm() {
        return this.baseForm;
    }

    public void setDetailMode(boolean mode) {
        this.isDetailMode = mode;
    }

    protected void onResized(int width, int height) {
        if (!this.wasSashCreated) {
            this.addHeightWeightListener();
        }
        this.resizePageButton();
        this.resizeTableButton();
        if (!this.isDetailMode) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.baseForm.setWeights(nArray);
        } else {
            int hrate;
            int n = hrate = this.tableHeight == -1 ? (int)(23500.0 / (double)height) : this.tableHeight * 100 / height;
            if (hrate > 100) {
                return;
            }
            this.baseForm.setWeights(new int[]{100 - hrate, hrate});
        }
    }

    private void resizePageButton() {
        int width = WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width;
        int pageCount = PageInfoRegistry.getPageNamesByTarget(SettingDataManager.INSTANCE.getConnectedTarget().getTargetName()).size();
        int newWidth = width / pageCount > 190 ? 190 : width / pageCount;
        ((BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).getMainTab().updateTabButtonsWidth(newWidth);
    }

    public void resizeTableButton() {
        int tabCount;
        double weight = (double)this.bottomForm.getWeights()[0] / 1000.0;
        int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
        int newWidth = width / (tabCount = this.timelineTableView.getTabButtons().size()) > 190 ? 190 : width / tabCount;
        this.timelineTableView.updateTabButtonsWidth(newWidth);
    }

    public void clear() {
        super.clear();
        if (Global.isGUIMode()) {
            TimelineChartManager.getInstance().clear();
        }
        TimelineDataManager.getInstance().clear();
        ReplayDataManager.getInstance().clear();
        CallTraceDataManager.getInstance().clear();
        InteractiveDataManager.getInstance().clear();
        ScreenshotDataManager.getInstance().clear();
        FunctionUsageProfiler.getInstance().clear();
        SummaryDataManager.getInstance().clear();
    }

    public void updateView() {
        for (Map.Entry entry : this.childMap.entrySet()) {
            ((DABaseComposite)entry.getValue()).updateView();
        }
        if (!this.isDetailMode) {
            if (this.baseForm.getChildren().length > 2) {
                ((Sash)this.baseForm.getChildren()[2]).setVisible(false);
            }
        } else if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).setVisible(true);
        }
    }
}

