/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionExitDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionExitDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallTraceDataManager
extends PageDataManager {
    private static CallTraceDataManager instance = new CallTraceDataManager();
    private FunctionEntryDBTable functionEntryTable = new FunctionEntryDBTable();
    private FunctionExitDBTable functionExitTable = new FunctionExitDBTable();
    private WebFunctionEntryDBTable webFunctionEntryTable = new WebFunctionEntryDBTable();
    private WebFunctionExitDBTable webFunctionExitTable = new WebFunctionExitDBTable();

    private CallTraceDataManager() {
    }

    public FunctionEntryDBTable getFunctionEntryTable() {
        return this.functionEntryTable;
    }

    public FunctionExitDBTable getFunctionExitTable() {
        return this.functionExitTable;
    }

    public WebFunctionEntryDBTable getWebFunctionEntryTable() {
        return this.webFunctionEntryTable;
    }

    public WebFunctionExitDBTable getWebFunctionExitTable() {
        return this.webFunctionExitTable;
    }

    public static CallTraceDataManager getInstance() {
        return instance;
    }

    public void clear() {
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.makeNativeData(pack);
        this.makeWebData(pack);
    }

    private void makeNativeData(LogPackage pack) {
        Logs exitLogs;
        Logs entryLogs = pack.getLogs(8);
        if (entryLogs != null && entryLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = entryLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                block13: {
                    ProfileData pData;
                    ArrayList<Object> insertRowData;
                    block12: {
                        insertRowData = new ArrayList<Object>();
                        pData = (ProfileData)inputs.get(i);
                        try {
                            if (pData.getProbeType() != 4) break block12;
                            break block13;
                        }
                        catch (UnsupportedProtocolException unsupportedProtocolException) {}
                    }
                    try {
                        insertRowData.add(new Long(pData.getSeq()));
                        insertRowData.add(new Integer(pData.getPid()));
                        insertRowData.add(new Integer(pData.getTid()));
                        insertRowData.add(new Integer(pData.getApiId()));
                        insertRowData.add(new Integer(pData.getBinaryId()));
                        insertRowData.add(new Long(pData.getTime()));
                        insertRowData.add(new Long(pData.getCallerPcAddr()));
                        insertRowData.add(new Long(pData.getPcAddr()));
                        insertRowData.add(new String(pData.getArgs()));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Logger.exception((Throwable)e);
                    }
                    insertData.add(insertRowData);
                    ProcessInformation process = Global.getProject().getProcessInformation(pData.getPid());
                    process.addFunctionEntryLogCount();
                }
                ++i;
            }
            if (insertData.size() > 0) {
                this.functionEntryTable.insertData(insertData);
            }
        }
        if ((exitLogs = pack.getLogs(9)) != null && exitLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = exitLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ArrayList<Object> insertRowData = new ArrayList<Object>();
                ProfileData pData = (ProfileData)inputs.get(i);
                try {
                    insertRowData.add(new Long(pData.getEntrySeq()));
                    insertRowData.add(new Long(pData.getSeq()));
                    insertRowData.add(new Long(pData.getTime()));
                    insertRowData.add(new String(pData.getReturn()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertData.add(insertRowData);
                ++i;
            }
            if (insertData.size() > 0) {
                this.functionExitTable.insertData(insertData);
            }
        }
    }

    private void makeWebData(LogPackage pack) {
        Logs exitLogs;
        Logs entryLogs = pack.getLogs(21);
        if (entryLogs != null && entryLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = entryLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ArrayList<Object> insertRowData = new ArrayList<Object>();
                WebProfileData pData = (WebProfileData)inputs.get(i);
                try {
                    insertRowData.add(new Long(pData.getSeq()));
                    insertRowData.add(new Integer(pData.getPID()));
                    insertRowData.add(new Integer(pData.getTID()));
                    insertRowData.add(new Integer(pData.getFunctionLineNumber()));
                    insertRowData.add(pData.getFunctionName());
                    insertRowData.add(pData.getFunctionURL());
                    insertRowData.add(new Long(pData.getTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertData.add(insertRowData);
                ProcessInformation process = Global.getProject().getProcessInformation(pData.getPID());
                process.addFunctionEntryLogCount();
                ++i;
            }
            if (insertData.size() > 0) {
                this.webFunctionEntryTable.insertData(insertData);
            }
        }
        if ((exitLogs = pack.getLogs(22)) != null && exitLogs.getRawLogs().size() != 0) {
            List<LogData> inputs = exitLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ArrayList<Long> insertRowData = new ArrayList<Long>();
                WebProfileData pData = (WebProfileData)inputs.get(i);
                try {
                    insertRowData.add(new Long(pData.getEntrySeq()));
                    insertRowData.add(new Long(pData.getSeq()));
                    insertRowData.add(new Long(pData.getTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertData.add(insertRowData);
                ++i;
            }
            if (insertData.size() > 0) {
                this.webFunctionExitTable.insertData(insertData);
            }
        }
    }
}

