/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DAWindowingTableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.WindowingTableColumnSizePackListener;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class CallTraceTable
extends DAWindowingTableComposite {
    private String[] columnNames = new String[]{TimelinePageLabels.CALL_TRACE_VIEW_TIME, TimelinePageLabels.CALL_TRACE_VIEW_TID, TimelinePageLabels.CALL_TRACE_VIEW_PID, TimelinePageLabels.CALL_TRACE_VIEW_NAME, TimelinePageLabels.CALL_TRACE_VIEW_BINARY_PATH};
    private int[] columnSizes = new int[]{65, 45, 45, 300, 300};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true};
    private int[] sortTypes = new int[]{1, 1, 1, 2, 2};

    public CallTraceTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setSortTypes(this.sortTypes);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.setItemHeightSize(16);
        parent.addControlListener((ControlListener)new WindowingTableColumnSizePackListener(this, this.columnSizes));
        this.setDataType(FunctionEntryDBTable.COLUMN.START_TIME.index);
        this.setContextMenu(2);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                int size = ti.length;
                List<Object> startData = ((DATableDataFormat)ti[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)ti[size - 1].getData()).getData();
                long startTime = (Long)startData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                long endTime = (Long)endData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                Toolbar.INSTANCE.setChartDragStartTime(startTime);
                Toolbar.INSTANCE.setChartDragEndTime(endTime);
                Toolbar.INSTANCE.setDlogSelection(false);
                DASelectionData data = new DASelectionData(TimelinePage.calltraceViewID, startTime, endTime, ti, (Control)CallTraceTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = (Long)markerData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
                AnalyzerUtil.addMarker(markerTime);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<List<Object>> queriedData = this.getQueriedObjectData();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        int size = queriedData.size();
        int i = 0;
        while (i < size) {
            List<Object> rowData = queriedData.get(i);
            ArrayList<String> text = new ArrayList<String>();
            long time = (Long)rowData.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
            String strTime = Formatter.toTimeFormat(time);
            text.add(strTime);
            text.add(rowData.get(FunctionEntryDBTable.COLUMN.TID.index).toString());
            text.add(rowData.get(FunctionEntryDBTable.COLUMN.PID.index).toString());
            int functionId = (Integer)rowData.get(FunctionEntryDBTable.COLUMN.FUNCTION_ID.index);
            text.add(Global.getFunctionName(functionId));
            int binaryId = (Integer)rowData.get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
            BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryId);
            text.add(binInfo.getTargetBinaryPath());
            DATableDataFormat tableData = new DATableDataFormat((Long)rowData.get(FunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.index));
            tableData.getData().addAll(rowData);
            tableData.setType(32);
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            tableInput.setData(tableData);
            input.add(tableInput);
            if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                if (time >= analysisStartTime && time <= analysisEndTime) {
                    tableInput.setInRange(true);
                }
            }
            ++i;
        }
        return input;
    }

    @Override
    protected String getDBTableName() {
        return CallTraceDataManager.getInstance().getFunctionEntryTable().getTableName();
    }

    @Override
    protected List<String> getDBTableColumnNames() {
        ArrayList<String> columnName = new ArrayList<String>();
        columnName.add("*");
        return columnName;
    }

    @Override
    public int getItemCountByPid() {
        if (Global.getProject() == null) {
            return 0;
        }
        int itemCount = 0;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            ProcessInformation process = Global.getProject().getProcessInformation(selectedPid);
            itemCount = process.getFunctionEntryLogCount();
        } else {
            itemCount = Global.getProject().getTotalFunctionEntryCount();
        }
        return itemCount;
    }

    @Override
    protected String getSelectQueryOption() {
        StringBuffer query = new StringBuffer();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            query.append("pid =" + selectedPid);
        }
        return query.toString();
    }

    @Override
    protected String getSelectQueryCountOption() {
        StringBuffer query = new StringBuffer();
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            query.append("pid =" + selectedPid);
        }
        return query.toString();
    }

    @Override
    protected String getTimeColumnName() {
        return FunctionEntryDBTable.COLUMN.START_TIME.name;
    }
}

