/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WebFunctionExitDBTable
extends DBTable {
    public static final String TABLE_NAME = "WEB_FUNCTION_EXIT";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.EXIT_SEQUENCE_NUMBER.getName()) + "," + WebFunctionEntryDBTable.COLUMN.PID.getName() + "," + WebFunctionEntryDBTable.COLUMN.TID.getName() + "," + WebFunctionEntryDBTable.COLUMN.FUNCTION_LINE_NUMBER.getName() + "," + WebFunctionEntryDBTable.COLUMN.FUNCTION_NAME.getName() + "," + WebFunctionEntryDBTable.COLUMN.FUNCTION_URL.getName() + "," + COLUMN.END_TIME.getName();
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "WEB_FUNCTION_EXIT" + "," + "WEB_FUNCTION_ENTRY" + " where " + COLUMN.ENTRY_SEQUENCE_NUMBER.getName() + "=" + WebFunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.getName() + " and " + COLUMN.access$2(COLUMN.END_TIME) + " between %s and %s";

    public WebFunctionExitDBTable() {
        this.addColumn(new DBColumn(COLUMN.ENTRY_SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.EXIT_SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
        this.setIndexColumn(COLUMN.END_TIME.index);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.ENTRY_SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.ENTRY_SEQUENCE_NUMBER.index));
                prep.setLong(COLUMN.EXIT_SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.EXIT_SEQUENCE_NUMBER.index));
                prep.setLong(COLUMN.END_TIME.index + 1, (Long)rowData.get(COLUMN.END_TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(rs.getLong(3));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public List<List<Object>> getWebFunctionExitFromDB() {
        return this.selectAllColumnData(null);
    }

    public static enum COLUMN {
        ENTRY_SEQUENCE_NUMBER(0, "ENTRY_SEQUENCE_NUMBER"),
        EXIT_SEQUENCE_NUMBER(1, "EXIT_SEQUENCE_NUMBER"),
        END_TIME(2, "END_TIME");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

