/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class ProcessesChartRenderer
extends DAChartRenderer {
    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            this.drawSeries(gc, (DAChartSeries)this.seriesList.get(i), i);
            ++i;
        }
        this.drawAxis(gc);
    }

    private void drawSeries(GC gc, DAChartSeries series, int seriesIndex) {
        int seriesSize = this.seriesList.size();
        Rectangle rect = new Rectangle(this.r.x, this.r.y + this.r.height * seriesIndex / seriesSize, this.r.width, this.r.height / seriesSize);
        if (seriesIndex != 0) {
            gc.setForeground(ColorResources.CHART_SEPERATE_LINE);
            gc.drawLine(rect.x, this.r.height * seriesIndex / seriesSize, rect.width, this.r.height * seriesIndex / seriesSize);
        }
        gc.setForeground(ColorResources.SERIES_NAME_ANNOTATION);
        Font oriFont = gc.getFont();
        Font nameAnnotationFont = series.getFont();
        gc.setFont(nameAnnotationFont);
        gc.drawText(series.getName(), rect.x + 3, rect.y + rect.height / 2 - gc.stringExtent((String)series.getName()).y / 2, true);
        gc.setFont(oriFont);
        List seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        DAChartSeriesItem seriesItem = (DAChartSeriesItem)seriesItems.get(0);
        double maxY = this.getMaxYToDraw(series, index);
        int oldPixelX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
        double oldY = seriesItem.getY();
        if (seriesItemSize == 1) {
            if (oldPixelX < this.r.x) {
                return;
            }
            Color color = seriesItem.getColor();
            if (color == null) {
                color = series.getColor();
            }
            gc.setForeground(color);
            gc.drawPoint(oldPixelX, this.plot.getYPixelFromY(maxY, seriesItem.getY(), this.r));
            return;
        }
        gc.setAlpha(204);
        gc.setLineStyle(1);
        gc.setAntialias(1);
        seriesItem = (DAChartSeriesItem)seriesItems.get(index);
        double currentX = seriesItem.getX();
        int newPixelX = this.plot.getXPixelFromX(currentX, this.r);
        double newY = seriesItem.getY();
        int i = index;
        while (i < seriesItemSize) {
            seriesItem = (DAChartSeriesItem)seriesItems.get(i);
            currentX = seriesItem.getX();
            oldPixelX = newPixelX;
            oldY = newY;
            newPixelX = this.plot.getXPixelFromX(currentX, this.r);
            newY = seriesItem.getY();
            gc.drawLine(oldPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - oldY / maxY)), newPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - newY / maxY)));
            if (currentX > this.plot.getVisibleEndX()) {
                return;
            }
            ++i;
        }
    }

    protected void drawTooltip(GC gc) {
        DAChartPlotTooltip tooltip = this.plot.getTooltip();
        if (tooltip == null || !tooltip.shouldBeDrawn() || tooltip.getStartVal() == -1.0) {
            return;
        }
        gc.setFont(tooltip.getFont());
        ArrayList<String> tooltipTexts = new ArrayList<String>();
        ArrayList<String> tooltipTimes = new ArrayList<String>();
        ArrayList<Color> tooltipColor = new ArrayList<Color>();
        int textWidthMax = 0;
        int textHeightMax = 0;
        double realXVal = tooltip.getStartVal();
        int tooltipSize = 0;
        int i = 0;
        while (i < this.seriesList.size()) {
            Color color;
            DAChartSeries series = (DAChartSeries)this.seriesList.get(i);
            ++tooltipSize;
            int index = series.getPrevIndexByXvalue(realXVal);
            String text = "";
            String time = "";
            if (index >= 0) {
                double xVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
                text = String.valueOf(text) + series.getName() + ": ";
                time = String.valueOf(time) + this.toTimeFormat(xVal);
                text = series.isSummarizeTooltip() && this.checkOverlapFromPrevItem(series, index) ? String.valueOf(text) + series.getSummarizeString() : String.valueOf(text) + ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getTooltipText();
                gc.setForeground(tooltip.getLineColor());
                gc.setLineStyle(3);
                gc.setLineWidth(1);
                gc.drawLine(this.plot.getXPixelFromX(xVal), 0, this.plot.getXPixelFromX(xVal), this.r.height);
                gc.setLineStyle(6);
                color = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getColor();
            } else {
                text = series.getName();
                color = null;
            }
            tooltipTexts.add(text);
            tooltipTimes.add(time);
            tooltipColor.add(color);
            int textWidth = gc.textExtent((String)text).x + 20 + gc.textExtent((String)time).x;
            int textHeight = gc.textExtent((String)text).y;
            if (textWidthMax < textWidth) {
                textWidthMax = textWidth;
            }
            if (textHeightMax < textHeight) {
                textHeightMax = textHeight;
            }
            ++i;
        }
        int preTextWidthMargin = 14;
        int startX = this.getTooltipStartX(realXVal, textWidthMax + preTextWidthMargin, 4);
        int totalHeight = tooltipSize * textHeightMax + 4 + 4;
        int startY = this.r.y + this.r.height / 2 - totalHeight / 2;
        gc.setAlpha(150);
        gc.setBackground(ColorResources.WHITE);
        gc.setForeground(ColorResources.WHITE);
        gc.fillGradientRectangle(startX, startY, preTextWidthMargin + textWidthMax + 4, totalHeight, true);
        gc.setAlpha(255);
        gc.setForeground(ColorResources.POINT);
        gc.drawRoundRectangle(startX, this.r.y, preTextWidthMargin + textWidthMax + 4, this.r.height, 5, 5);
        gc.setFont(tooltip.getFont());
        tooltipSize = -1;
        int i2 = 0;
        while (i2 < this.seriesList.size()) {
            block14: {
                DAChartSeries series;
                block13: {
                    block12: {
                        if (!(this.plot instanceof DAUIEventChartPlot)) break block12;
                        series = (DAChartSeries)this.seriesList.get((int)((double)this.seriesList.size() * tooltip.getYPosRatio()));
                        break block13;
                    }
                    series = (DAChartSeries)this.seriesList.get(i2);
                    if (series.isDisableTooltip()) break block14;
                    ++tooltipSize;
                }
                int yPosition = this.r.y + this.r.height * i2 / this.seriesList.size() + this.r.height / this.seriesList.size() / 2 - textHeightMax / 2;
                Color col = (Color)tooltipColor.get(i2);
                if (col == null) {
                    gc.setBackground(series.getColor());
                } else {
                    gc.setBackground(col);
                }
                gc.fillRoundRectangle(startX + 4, yPosition + textHeightMax / 2 - 3, 6, 6, 6, 6);
                gc.setBackground(tooltip.getBackgroundColor());
                gc.setForeground(tooltip.getTextColor());
                gc.drawText((String)tooltipTexts.get(i2), startX + 4 + 6 + 4, yPosition, 3);
                gc.setForeground(tooltip.getTimeColor());
                String timeStr = (String)tooltipTimes.get(i2);
                gc.drawText((String)tooltipTimes.get(i2), startX + 4 + 6 + 4 + textWidthMax - 4 - gc.textExtent((String)timeStr).x, yPosition, 3);
            }
            ++i2;
        }
    }
}

