/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class ProcessExplorer
extends Composite {
    protected Grid table = null;
    protected DATextBox findText = null;
    protected DACustomButton findButton = null;
    protected DACustomButton refreshButton = null;
    protected DeviceInfo device = null;
    protected Map<Integer, String> initialProcesses = null;
    protected int findIndex = -1;
    private DACustomButtonClickEventListener findButtonClickListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            String findStr = ProcessExplorer.this.findText.getText();
            if (findStr != null && findStr.length() >= 1) {
                GridItem item;
                int found = -1;
                int itemcount = ProcessExplorer.this.table.getItemCount();
                int i = ProcessExplorer.this.findIndex + 1;
                while (i < itemcount) {
                    item = ProcessExplorer.this.table.getItem(i);
                    if (item.getText(2).contains(findStr)) {
                        found = i;
                        break;
                    }
                    ++i;
                }
                if (found == -1 && ProcessExplorer.this.findIndex != -1) {
                    i = 0;
                    while (i <= ProcessExplorer.this.findIndex) {
                        item = ProcessExplorer.this.table.getItem(i);
                        if (item.getText(2).contains(findStr)) {
                            found = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (found != -1) {
                    ProcessExplorer.this.findIndex = found;
                    ProcessExplorer.this.table.setSelection(found);
                    ProcessExplorer.this.table.showSelection();
                } else {
                    ProcessExplorer.this.table.deselectAll();
                    ProcessExplorer.this.table.setTopIndex(0);
                }
            }
        }
    };
    private DACustomButtonClickEventListener refreshButtonClickListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            ProcessExplorer.this.findIndex = -1;
            ProcessExplorer.this.updateData();
        }
    };

    ProcessExplorer(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.table = new DAGrid(this, 2818);
        this.table.setHeaderVisible(true);
        this.table.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.setColumn();
        this.table.setItemHeight(20);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((e.detail & 0x20) != 32) {
                    ProcessExplorer.this.findIndex = ((Grid)e.widget).getSelectionIndex();
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -36);
        this.table.setLayoutData((Object)data);
        this.findText = new DATextBox((Composite)this, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)this.table, 10);
        data.left = new FormAttachment(0, 10);
        data.height = 20;
        data.width = 250;
        this.findText.setLayoutData(data);
        this.findText.setBackground(ColorResources.WHITE);
        this.findButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.table, 10);
        data.left = new FormAttachment((Control)this.findText.getControl(), 5);
        data.height = 25;
        data.width = 60;
        this.findButton.setLayoutData((Object)data);
        this.findButton.setText("Find");
        this.findButton.addClickListener(this.findButtonClickListener);
        this.refreshButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.table, 10);
        data.left = new FormAttachment((Control)this.findButton, 20);
        data.right = new FormAttachment(100, -10);
        data.height = 25;
        this.refreshButton.setLayoutData((Object)data);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addClickListener(this.refreshButtonClickListener);
    }

    private void setColumn() {
        GridColumn checkColumn = new GridColumn(this.table, 32);
        DATableCellRenderer checkCellRenderer = new DATableCellRenderer();
        checkCellRenderer.setLeftMargin(6);
        checkColumn.setCellRenderer((GridCellRenderer)checkCellRenderer);
        final DATableHeaderRenderer checkHeaderRenderer = new DATableHeaderRenderer(16416);
        checkColumn.setHeaderRenderer((GridHeaderRenderer)checkHeaderRenderer);
        checkColumn.setText("");
        checkColumn.setWidth(25);
        checkColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                checkHeaderRenderer.setSelected();
                boolean checked = checkHeaderRenderer.getChecked();
                GridItem[] items = ProcessExplorer.this.table.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(0, checked);
                    ++i;
                }
            }
        });
        GridColumn pidColumn = new GridColumn(this.table, 0);
        DATableCellRenderer pidCellRenderer = new DATableCellRenderer();
        pidCellRenderer.setTextTopMargin(4);
        pidColumn.setCellRenderer((GridCellRenderer)pidCellRenderer);
        pidColumn.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer(16384));
        pidColumn.setText("PID");
        pidColumn.setAlignment(16384);
        pidColumn.setWidth(50);
        GridColumn nameColumn = new GridColumn(this.table, 0);
        DATableCellRenderer nameCellRenderer = new DATableCellRenderer();
        nameCellRenderer.setTextTopMargin(4);
        nameColumn.setCellRenderer((GridCellRenderer)nameCellRenderer);
        nameColumn.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer(16384));
        nameColumn.setText("Process Name");
        nameColumn.setAlignment(16384);
        nameColumn.setWidth(355);
    }

    public void setDeviceInfo(DeviceInfo dev) {
        this.device = dev;
    }

    public void updateData() {
        if (this.device == null) {
            Logger.warning((Object)"Device is empty");
            return;
        }
        this.table.removeAll();
        Map<Integer, String> processes = DACommunicator.getProcessList();
        if (processes == null) {
            return;
        }
        int size = 0;
        int maxnamelen = 0;
        for (Map.Entry<Integer, String> entry : processes.entrySet()) {
            String name = entry.getValue();
            if (!name.startsWith("/")) continue;
            int namelen = name.length();
            if (maxnamelen < namelen) {
                maxnamelen = namelen;
            }
            GridItem item = new GridItem(this.table, 0);
            item.setCheckable(0, false);
            item.setText(1, entry.getKey().toString());
            if (name.contains(" ")) {
                int cut_index = name.indexOf(" ");
                item.setText(2, name.substring(0, cut_index));
            } else {
                item.setText(2, name);
            }
            if (this.initialProcesses != null && this.initialProcesses.containsKey(entry.getKey())) {
                item.setChecked(0, true);
            }
            ++size;
        }
        if (maxnamelen > 55) {
            this.table.getColumn(2).setWidth((int)((double)maxnamelen * 6.5));
        } else {
            this.table.getColumn(2).setWidth(355);
        }
        this.table.getVerticalBar().setMaximum(size);
        this.table.getVerticalBar().setSelection(0);
        this.table.getHorizontalBar().setSelection(0);
        this.table.update();
    }

    public Map<Integer, String> getSelectedProcess() {
        TreeMap<Integer, String> selected = new TreeMap<Integer, String>();
        int itemcount = this.table.getItemCount();
        int i = 0;
        while (i < itemcount) {
            GridItem item = this.table.getItem(i);
            if (item.getChecked(0)) {
                int pid = Integer.parseInt(item.getText(1));
                String[] splitcmd = item.getText(2).split(" ", 2);
                selected.put(pid, splitcmd[0]);
            }
            ++i;
        }
        if (selected.size() == 0) {
            return null;
        }
        return selected;
    }

    public void setSelectedProcess(Map<Integer, String> proc) {
        this.initialProcesses = proc;
    }
}

