/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;

public class FlatFeatureDialogSelectedFeaturePage
extends DAPageComposite {
    private FlatFeatureDialog featureDialog = null;
    private Composite selectedComp = null;
    private ScrolledComposite selecetedScrolledComp = null;
    private Composite selectedInputComp = null;
    private Label selectedFeatureLabel = null;
    private Label selectedIcon = null;
    private Label selectedNameLabel = null;
    private Label noItemLabel = null;
    private DACustomToggleButton delToggle = null;
    private Cursor daCursor = null;
    private int TITLE_FONT_SIZE = 0;
    private int ICON_SIZE = 0;
    private int WIDTH = 0;
    private int HEIGHT = 0;
    private int LINE = 0;
    private int ITEM_LEFT = 0;
    private int TITLE_HEIGHT = 0;
    private int TITLE_TOP = 0;
    private int BODY_HEIGHT = 0;
    private int BODY_TOP = 0;
    private int BODY_TOP_MARGIN = 0;
    private int ITEM_DIST = 0;
    private int ICON_TITLE_DIST = 0;
    private int ITEM_TITLE_TOP = 0;
    private int ITEM_TITLE_LEFT = 0;
    private int ITEM_TITLE_WIDTH = 0;
    private int CANCEL_SIZE = 0;
    private int CANCEL_TOP = 0;
    private int CANCEL_RIGHT = 0;
    private int NOITEM_UPPER_MARGIN = 0;
    private int NOITEM_LEFT_MARGIN = 0;
    private int VSCROLL_MARGIN = -3;
    private Listener cursorListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomToggleButton toggleButton = (DACustomToggleButton)event.widget;
                toggleButton.setFocus();
                if (event.type == 6) {
                    FlatFeatureDialogSelectedFeaturePage.this.daCursor = new Cursor((Device)FlatFeatureDialogSelectedFeaturePage.this.getShell().getDisplay(), 21);
                } else if (event.type == 7) {
                    FlatFeatureDialogSelectedFeaturePage.this.daCursor = new Cursor((Device)FlatFeatureDialogSelectedFeaturePage.this.getShell().getDisplay(), 0);
                } else {
                    return;
                }
                FlatFeatureDialogSelectedFeaturePage.this.getShell().setCursor(FlatFeatureDialogSelectedFeaturePage.this.daCursor);
            }
        }
    };
    private Listener clickListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomToggleButton toggleButton = (DACustomToggleButton)event.widget;
            TargetData target = SettingDataManager.INSTANCE.getTarget(null);
            target.removeSelectedFlatFeature(toggleButton.getText());
            FlatFeatureDialogSelectedFeaturePage.this.featureDialog.getFeatureListPage().featureToggleUnselect(toggleButton.getText());
            FlatFeatureDialogSelectedFeaturePage.this.createSelectedFeatureComposite();
        }
    };

    public FlatFeatureDialogSelectedFeaturePage(Composite parent, FlatFeatureDialog parentObject, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.selectedComp = parent;
        this.featureDialog = parentObject;
        this.TITLE_FONT_SIZE = 16;
        this.ICON_SIZE = 40;
        this.CANCEL_SIZE = 15;
        this.WIDTH = this.featureDialog.SELECTED_WIDTH;
        ((Object)((Object)this.featureDialog)).getClass();
        this.HEIGHT = 527;
        this.LINE = this.featureDialog.LINE;
        this.ITEM_LEFT = 20;
        this.TITLE_HEIGHT = this.featureDialog.TITLE_HEIGHT;
        this.TITLE_TOP = (this.TITLE_HEIGHT - this.TITLE_FONT_SIZE) / 2;
        this.BODY_TOP = this.TITLE_HEIGHT + this.LINE + 1;
        this.BODY_HEIGHT = this.HEIGHT - this.TITLE_HEIGHT - this.LINE;
        this.BODY_TOP_MARGIN = 30;
        this.ITEM_DIST = 23;
        this.ICON_TITLE_DIST = 15;
        this.ITEM_TITLE_TOP = (this.ICON_SIZE - this.TITLE_FONT_SIZE) / 2;
        this.ITEM_TITLE_LEFT = this.ITEM_LEFT + this.ICON_SIZE + this.ICON_TITLE_DIST;
        this.ITEM_TITLE_WIDTH = 158;
        this.CANCEL_TOP = (this.ICON_SIZE - this.CANCEL_SIZE) / 2;
        this.CANCEL_RIGHT = -30;
        this.NOITEM_UPPER_MARGIN = (this.BODY_HEIGHT - this.TITLE_FONT_SIZE) / 2;
        this.NOITEM_LEFT_MARGIN = 15;
        this.createSelectedFeatureComposite();
    }

    private void initSelectedFeatureCompositeWidget() {
        if (this.selecetedScrolledComp != null) {
            this.selecetedScrolledComp.dispose();
            this.selecetedScrolledComp = null;
        }
        if (this.selectedInputComp != null) {
            this.selectedInputComp.dispose();
            this.selectedInputComp = null;
        }
        if (this.selectedFeatureLabel != null) {
            this.selectedFeatureLabel.dispose();
            this.selectedFeatureLabel = null;
        }
        if (this.selectedIcon != null) {
            this.selectedIcon.dispose();
            this.selectedIcon = null;
        }
        if (this.selectedNameLabel != null) {
            this.selectedNameLabel.dispose();
            this.selectedNameLabel = null;
        }
        if (this.noItemLabel != null) {
            this.noItemLabel.dispose();
            this.noItemLabel = null;
        }
    }

    private DACustomToggleButton createToggleButton(Composite composit, Image image, Point imagePoint, String title, Point fontPoint, int width, int height, int topPosition, int leftPosition) {
        DACustomToggleButton toggle = new DACustomToggleButton(composit, 0);
        toggle.setColors(ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR);
        toggle.setButtonImages(image, image, image, image, image, image, image);
        toggle.setButtonImagePoint(imagePoint);
        toggle.setTitle(title);
        toggle.setFontPoint(fontPoint);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, topPosition);
        data.left = new FormAttachment(0, leftPosition);
        data.width = width;
        data.height = height;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    public DACustomToggleButton getDelToggle() {
        return this.delToggle;
    }

    public void createSelectedFeatureComposite() {
        this.initSelectedFeatureCompositeWidget();
        this.selectedFeatureLabel = new Label(this.selectedComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.TITLE_TOP);
        data.left = new FormAttachment(0, this.ITEM_LEFT);
        data.width = this.WIDTH - this.ITEM_LEFT;
        data.height = this.TITLE_HEIGHT - this.TITLE_TOP - this.TITLE_FONT_SIZE + 6;
        this.selectedFeatureLabel.setLayoutData((Object)data);
        this.selectedFeatureLabel.setText(ConfigureLabels.SETTING_DIALOG_SELECTED_TITLE);
        this.selectedFeatureLabel.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        this.selectedFeatureLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.selectedFeatureLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.selectedFeatureLabel.setAlignment(16384);
        this.selectedComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_LINE);
                e.gc.drawLine(0, FlatFeatureDialogSelectedFeaturePage.this.TITLE_HEIGHT + FlatFeatureDialogSelectedFeaturePage.this.LINE, FlatFeatureDialogSelectedFeaturePage.this.WIDTH, FlatFeatureDialogSelectedFeaturePage.this.TITLE_HEIGHT + FlatFeatureDialogSelectedFeaturePage.this.LINE);
            }
        });
        this.selecetedScrolledComp = new ScrolledComposite(this.selectedComp, 512);
        this.selecetedScrolledComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, this.BODY_TOP);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, this.VSCROLL_MARGIN);
        data.bottom = new FormAttachment(100, 0);
        this.selecetedScrolledComp.setLayoutData((Object)data);
        this.selecetedScrolledComp.setExpandHorizontal(true);
        this.selecetedScrolledComp.setExpandVertical(true);
        this.selecetedScrolledComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.selecetedScrolledComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_FEATURELISTCOMP_LINE);
                e.gc.drawLine(0, 0, FlatFeatureDialogSelectedFeaturePage.this.WIDTH, 0);
            }
        });
        this.selectedInputComp = new Composite((Composite)this.selecetedScrolledComp, 0);
        this.selecetedScrolledComp.setContent((Control)this.selectedInputComp);
        this.selecetedScrolledComp.setMinSize(this.selectedInputComp.computeSize(-1, -1));
        this.selecetedScrolledComp.setShowFocusedControl(true);
        this.selectedInputComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, this.VSCROLL_MARGIN);
        data.bottom = new FormAttachment(100, 0);
        this.selectedInputComp.setLayoutData((Object)data);
        this.selectedInputComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.selectedInputComp.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                FlatFeatureDialogSelectedFeaturePage.this.selectedInputComp.setFocus();
            }
        });
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        List<FlatFeature> featureList = target.getSelectedFlatFeatureList();
        if (featureList.size() > 0) {
            this.featureDialog.getOKButton().setEnabled(true);
        } else {
            this.featureDialog.getOKButton().setEnabled(false);
            this.noItemLabel = new Label(this.selectedInputComp, 0x40000000);
            data = new FormData();
            data.top = new FormAttachment(0, this.NOITEM_UPPER_MARGIN);
            data.left = new FormAttachment(0, this.NOITEM_LEFT_MARGIN);
            data.width = this.WIDTH - this.NOITEM_LEFT_MARGIN;
            data.height = this.TITLE_HEIGHT;
            this.noItemLabel.setLayoutData((Object)data);
            this.noItemLabel.setText(ConfigureLabels.SETTING_DIALOG_NO_ITEM_SELECTED);
            this.noItemLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.noItemLabel.setForeground(ColorResources.GRAY_130);
            this.noItemLabel.setFont(FontResources.SETTING_TITLE_FONT);
        }
        int topPosition = this.BODY_TOP_MARGIN;
        int leftPosition = this.ITEM_LEFT;
        int i = featureList.size() - 1;
        while (i >= 0) {
            FlatFeature feature = featureList.get(i);
            this.selectedIcon = new Label(this.selectedInputComp, 0x40000000);
            this.selectedIcon.setImage(feature.getSmallImage());
            data = new FormData();
            data.top = new FormAttachment(0, topPosition);
            data.left = new FormAttachment(0, leftPosition);
            data.width = this.ICON_SIZE;
            data.height = this.ICON_SIZE;
            this.selectedIcon.setLayoutData((Object)data);
            this.selectedIcon.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.selectedNameLabel = new Label(this.selectedInputComp, 0x40000000);
            data = new FormData();
            data.top = new FormAttachment(0, topPosition + this.ITEM_TITLE_TOP);
            data.left = new FormAttachment(0, this.ITEM_TITLE_LEFT);
            data.width = this.ITEM_TITLE_WIDTH;
            data.height = this.TITLE_FONT_SIZE;
            this.selectedNameLabel.setLayoutData((Object)data);
            this.selectedNameLabel.setText(feature.getName());
            this.selectedNameLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.selectedNameLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
            this.selectedNameLabel.setFont(FontResources.SETTING_TITLE_FONT);
            Point delImagePoint = new Point(0, 0);
            this.delToggle = this.createToggleButton(this.selectedInputComp, ImageResources.DELETE, delImagePoint, feature.getName(), null, this.CANCEL_SIZE, this.CANCEL_SIZE, topPosition + this.CANCEL_TOP, this.WIDTH - this.CANCEL_SIZE + this.CANCEL_RIGHT);
            this.delToggle.addListener(4, this.clickListener);
            this.delToggle.addListener(6, this.cursorListener);
            this.delToggle.addListener(7, this.cursorListener);
            topPosition += this.ICON_SIZE + this.ITEM_DIST;
            --i;
        }
        this.selectedComp.layout(true);
        this.selectedInputComp.layout();
        this.selecetedScrolledComp.setMinSize(this.selectedInputComp.computeSize(-1, -1));
        this.selecetedScrolledComp.getVerticalBar().setIncrement(this.ICON_SIZE / 2);
        this.selecetedScrolledComp.getVerticalBar().setPageIncrement(this.ICON_SIZE * 2);
        if (!DAState.isStartable()) {
            this.selectedComp.setEnabled(false);
        }
    }
}

