/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedPopupMenu;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;

public class DAAdvancedTabComposite
extends DATabComposite {
    private DAAdvancedPopupMenu advancedMenu = null;
    private PaintListener tabCompositePaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Composite comp = (Composite)e.widget;
            Rectangle rect = comp.getClientArea();
            e.gc.drawImage(ImageResources.ADVANCED_MENU_BUTTON_NORMAL, rect.width - 19, 3);
        }
    };
    private Listener advancedMenuButtonMouseUpListener = new Listener(){

        public void handleEvent(Event event) {
            Rectangle bounds = DAAdvancedTabComposite.this.tabComposite.getBounds();
            int width = bounds.width;
            if (event.x < width - 16 || event.x > width - 6) {
                return;
            }
            if (event.button == 1) {
                Point loc = DAAdvancedTabComposite.this.getLocation();
                Point p = DAAdvancedTabComposite.this.contentsComposite.toDisplay(loc);
                int x = 0;
                int y = 0;
                x = p.x - loc.x + ((DAAdvancedTabComposite)DAAdvancedTabComposite.this).contentsComposite.getBounds().width - 87;
                y = p.y - loc.y;
                DAAdvancedTabComposite.this.setPopupMenu();
                DAAdvancedTabComposite.this.advancedMenu.open(DAAdvancedTabComposite.this.advancedMenu.getTopShell(), x, y);
            }
        }
    };

    public DAAdvancedTabComposite(Composite parent, int style) {
        super(parent, style);
        this.setAdvancedFeature();
    }

    public DAAdvancedTabComposite(Composite parent, int style, boolean istoplevel) {
        super(parent, style, istoplevel);
        this.setAdvancedFeature();
    }

    private void setAdvancedFeature() {
        this.advancedMenu = new DAAdvancedPopupMenu(this.contentsComposite);
        this.tabComposite.addPaintListener(this.tabCompositePaintListener);
        this.tabComposite.addListener(4, this.advancedMenuButtonMouseUpListener);
    }

    private void setPopupMenu() {
        DABaseComposite baseComp = this.getTopComposite();
        if (baseComp instanceof DAAdvancedViewComposite) {
            this.clearPopupMenuItemsEnableSetting();
            DAAdvancedViewComposite comp = (DAAdvancedViewComposite)baseComp;
            this.advancedMenu.setTable(comp.getTable());
            List<Integer> disableMenuIndexes = comp.getDisabledMenuIndexes();
            if (disableMenuIndexes == null || disableMenuIndexes.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < disableMenuIndexes.size()) {
                this.advancedMenu.getItem(disableMenuIndexes.get(i)).setEnabled(false);
                ++i;
            }
        } else {
            Logger.debug((Object)"This view is not DAAdvancedViewComposite !!");
            int i = 0;
            while (i < this.advancedMenu.getItems().size()) {
                ((DAPopupMenuItem)this.advancedMenu.getItems().get(i)).setEnabled(false);
                ++i;
            }
        }
    }

    private void clearPopupMenuItemsEnableSetting() {
        int i = 0;
        while (i < this.advancedMenu.getItems().size()) {
            ((DAPopupMenuItem)this.advancedMenu.getItems().get(i)).setEnabled(true);
            ++i;
        }
    }
}

