/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.model.FindProperty;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckBox;
import org.tizen.dynamicanalyzer.widgets.button.checkbox.DACheckboxSelectionListener;
import org.tizen.dynamicanalyzer.widgets.button.radio.DARadioButton;
import org.tizen.dynamicanalyzer.widgets.button.radio.DARadioGroup;
import org.tizen.dynamicanalyzer.widgets.button.radio.DARadioSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class FindDialog
extends DAMessageBox {
    private static final int ENTER_KEY_CODE = 13;
    private DATextBox textBox = null;
    private DAButton findButton = null;
    private DARadioButton forwardButton = null;
    private DARadioButton backwardButton = null;
    private DACheckBox caseButton = null;
    private DACheckBox wholeWordButton = null;
    private FindProperty findProperty = null;
    private Grid table = null;
    private String viewName = null;
    private Composite composite = null;
    private DACustomButtonClickEventListener fnidButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            FindDialog.this.findProperty.setLastSearch(FindDialog.this.textBox.getText());
            FindDialog.this.executeFindCommand();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (FindDialog.this.textBox.getText() != null && !FindDialog.this.textBox.getText().isEmpty()) {
                FindDialog.this.findButton.setButtonEnabled(true);
                if (e.keyCode == 13) {
                    FindDialog.this.findProperty.setLastSearch(FindDialog.this.textBox.getText());
                    FindDialog.this.executeFindCommand();
                }
            } else {
                FindDialog.this.findButton.setButtonEnabled(false);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private DARadioSelectionListener forwardButtonListener = new DARadioSelectionListener(){

        public void handleSelectionEvent(DARadioButton radio) {
            FindDialog.this.findProperty.setBackward(false);
            if (!FindDialog.this.backwardButton.isEnabled()) {
                FindDialog.this.backwardButton.setEnabled(true);
            }
            FindDialog.this.forwardButton.setEnabled(false);
        }
    };
    private DARadioSelectionListener backwardButtonListener = new DARadioSelectionListener(){

        public void handleSelectionEvent(DARadioButton radio) {
            FindDialog.this.findProperty.setBackward(true);
            if (!FindDialog.this.forwardButton.isEnabled()) {
                FindDialog.this.forwardButton.setEnabled(true);
            }
            FindDialog.this.backwardButton.setEnabled(false);
        }
    };
    private DACheckboxSelectionListener caseButtonListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            FindDialog.this.findProperty.setCaseSensitive(!FindDialog.this.findProperty.isCaseSensitive());
            FindDialog.this.caseButton.setChecked(FindDialog.this.findProperty.isCaseSensitive());
        }
    };
    private DACheckboxSelectionListener wholeWordButtonListener = new DACheckboxSelectionListener(){

        public void handleSelectionEvent(DACheckBox checkbox) {
            FindDialog.this.findProperty.setWholeWord(!FindDialog.this.findProperty.isWholeWord());
            FindDialog.this.wholeWordButton.setChecked(FindDialog.this.findProperty.isWholeWord());
        }
    };

    public FindDialog(Shell parentShell, Composite comp) {
        super(parentShell);
        if (comp instanceof DATableComposite) {
            this.table = ((DATableComposite)comp).getTable();
            this.viewName = ((DATableComposite)comp).getTableName();
        } else if (comp instanceof DATreeComposite) {
            this.table = ((DATreeComposite)comp).getTable();
            this.viewName = ((DATreeComposite)comp).getTableName();
        } else {
            this.table = null;
            return;
        }
        this.composite = comp;
        this.findProperty = DATableComposite.getFindProferty();
        this.findProperty.setIndex(this.table.getSelectionIndex());
    }

    protected boolean run() {
        if (this.table == null) {
            return false;
        }
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(340, 130);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.setText(String.valueOf(AnalyzerLabels.FIND_DLG_TITLE_PREFIX) + " " + this.viewName + " " + AnalyzerLabels.FIND_DLG_TITLE_POSTFIX);
        this.textBox = new DATextBox((Composite)this.shell, 4);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 9);
        data.height = 22;
        data.width = 200;
        this.textBox.setLayoutData(data);
        this.textBox.setBackground(ColorResources.VIEW_BG_COLOR);
        this.textBox.getControl().addKeyListener(this.keyListener);
        this.textBox.setText(this.findProperty.getLastSearch());
        this.textBox.getControl().setSelection(0, this.findProperty.getLastSearch().length());
        this.findButton = new DAButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.textBox.getControl(), 9);
        data.height = 25;
        data.width = 86;
        this.findButton.setLayoutData((Object)data);
        this.findButton.setText(AnalyzerLabels.FIND_DLG_FIND_BUTTON);
        this.findButton.addClickListener(this.fnidButtonListener);
        Label directionLabel = new Label((Composite)this.shell, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.textBox.getControl(), 11);
        data.left = new FormAttachment(0, 15);
        data.height = 20;
        data.width = 66;
        directionLabel.setLayoutData((Object)data);
        directionLabel.setForeground(ColorResources.BLACK);
        directionLabel.setText(AnalyzerLabels.FIND_DLG_DIRECTION);
        directionLabel.setBackground(ColorResources.DIALOG_BG_UPPER);
        DARadioGroup radioGroup = new DARadioGroup();
        this.forwardButton = new DARadioButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.textBox.getControl(), 10);
        data.left = new FormAttachment((Control)directionLabel, 0);
        data.height = 20;
        data.width = 106;
        this.forwardButton.setLayoutData((Object)data);
        this.forwardButton.setForeground(ColorResources.BLACK);
        this.forwardButton.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.forwardButton.setText(AnalyzerLabels.FIND_DLG_DIRECTION_FORWARD);
        this.forwardButton.addSelectionListener(this.forwardButtonListener);
        radioGroup.addChild(this.forwardButton);
        this.backwardButton = new DARadioButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.textBox.getControl(), 10);
        data.left = new FormAttachment((Control)this.forwardButton, 1);
        data.height = 20;
        data.width = 86;
        this.backwardButton.setLayoutData((Object)data);
        this.backwardButton.setForeground(ColorResources.BLACK);
        this.backwardButton.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.backwardButton.setText(AnalyzerLabels.FIND_DLG_DIRECTION_BACKWARD);
        this.backwardButton.addSelectionListener(this.backwardButtonListener);
        radioGroup.addChild(this.backwardButton);
        Label optionLabel = new Label((Composite)this.shell, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)directionLabel, 5);
        data.left = new FormAttachment(0, 15);
        data.height = 20;
        data.width = 66;
        optionLabel.setLayoutData((Object)data);
        optionLabel.setForeground(ColorResources.BLACK);
        optionLabel.setText(AnalyzerLabels.FIND_DLG_OPTION);
        optionLabel.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.caseButton = new DACheckBox((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.forwardButton, 5);
        data.left = new FormAttachment((Control)optionLabel, 0);
        data.height = 20;
        data.width = 106;
        this.caseButton.setLayoutData((Object)data);
        this.caseButton.setForeground(ColorResources.BLACK);
        this.caseButton.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.caseButton.setText(AnalyzerLabels.FIND_DLG_CASE_SENSITIVE);
        this.caseButton.addSelectionListener(this.caseButtonListener);
        this.caseButton.setChecked(this.findProperty.isCaseSensitive());
        this.wholeWordButton = new DACheckBox((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.forwardButton, 5);
        data.left = new FormAttachment((Control)this.caseButton, 1);
        data.height = 20;
        data.width = 86;
        this.wholeWordButton.setLayoutData((Object)data);
        this.wholeWordButton.setForeground(ColorResources.BLACK);
        this.wholeWordButton.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.wholeWordButton.setText(AnalyzerLabels.FIND_DLG_WHOLE_WORD);
        this.wholeWordButton.addSelectionListener(this.wholeWordButtonListener);
        this.wholeWordButton.setChecked(this.findProperty.isWholeWord());
        return true;
    }

    private boolean executeFindCommand() {
        int index = this.findProperty.getIndex();
        GridItem[] items = this.table.getItems();
        int itemCount = items.length;
        if (itemCount != 0) {
            index = this.findProperty.isBackward() ? (index - 1 < 0 ? itemCount - 1 : index - 1) : (index + 1 > itemCount - 1 ? 0 : index + 1);
            int findIndex = -1;
            this.findProperty.setIndex(index);
            if (this.composite instanceof DATableComposite) {
                findIndex = ((DATableComposite)this.composite).searchString(this.findProperty);
            } else if (this.composite instanceof DATreeComposite) {
                findIndex = ((DATreeComposite)this.composite).searchString(this.findProperty);
            } else {
                return false;
            }
            this.findProperty.setIndex(findIndex);
            return true;
        }
        return false;
    }
}

