/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.model.FindProperty;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.dropdown.DACustomDropdown;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class SearchDialog
extends DAMessageBox {
    private static final int ENTER_KEY_CODE = 13;
    private final int WIDTH = 430;
    private final int HEIGHT = 223;
    private DACustomDropdown categoryDropdown = null;
    private Text textBox = null;
    private DAButton cancelButton = null;
    private DAButton backButton = null;
    private DAButton nextButton = null;
    private Button caseButton = null;
    private Label caseButtonLabel = null;
    private Button wholeWordButton = null;
    private Label wholeWordButtonLabel = null;
    private FindProperty findProperty = null;
    private Grid table = null;
    private String viewName = null;
    private Composite composite = null;
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SearchDialog.this.shell.close();
        }
    };
    private DACustomButtonClickEventListener backButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SearchDialog.this.findProperty.setBackward(true);
            SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
            SearchDialog.this.executeFindCommand();
        }
    };
    private DACustomButtonClickEventListener nextButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SearchDialog.this.findProperty.setBackward(false);
            SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
            SearchDialog.this.executeFindCommand();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (SearchDialog.this.textBox.getText() != null && !SearchDialog.this.textBox.getText().isEmpty()) {
                SearchDialog.this.nextButton.setButtonEnabled(true);
                if (e.keyCode == 13) {
                    if ((e.stateMask & 0x20000) != 0) {
                        SearchDialog.this.findProperty.setBackward(true);
                        SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
                        SearchDialog.this.executeFindCommand();
                        SearchDialog.this.findProperty.setBackward(false);
                    } else {
                        SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
                        SearchDialog.this.executeFindCommand();
                    }
                }
            } else {
                SearchDialog.this.nextButton.setButtonEnabled(false);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private SelectionListener caseButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SearchDialog.this.findProperty.setCaseSensitive(!SearchDialog.this.findProperty.isCaseSensitive());
            if (SearchDialog.this.findProperty.isCaseSensitive()) {
                SearchDialog.this.caseButton.setSelection(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SearchDialog.this.findProperty.setCaseSensitive(!SearchDialog.this.findProperty.isCaseSensitive());
            if (SearchDialog.this.findProperty.isCaseSensitive()) {
                SearchDialog.this.caseButton.setSelection(true);
            }
        }
    };
    private Listener caseButtonLabelListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 4) {
                SearchDialog.this.findProperty.setCaseSensitive(!SearchDialog.this.findProperty.isCaseSensitive());
                if (SearchDialog.this.findProperty.isCaseSensitive()) {
                    SearchDialog.this.caseButton.setSelection(true);
                } else {
                    SearchDialog.this.caseButton.setSelection(false);
                }
            }
        }
    };
    private SelectionListener wholeWordButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SearchDialog.this.findProperty.setWholeWord(!SearchDialog.this.findProperty.isWholeWord());
            if (SearchDialog.this.findProperty.isWholeWord()) {
                SearchDialog.this.wholeWordButton.setSelection(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SearchDialog.this.findProperty.setWholeWord(!SearchDialog.this.findProperty.isWholeWord());
            if (SearchDialog.this.findProperty.isWholeWord()) {
                SearchDialog.this.wholeWordButton.setSelection(true);
            }
        }
    };
    private Listener wholeWordButtonLabelListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 4) {
                SearchDialog.this.findProperty.setWholeWord(!SearchDialog.this.findProperty.isWholeWord());
                if (SearchDialog.this.findProperty.isWholeWord()) {
                    SearchDialog.this.wholeWordButton.setSelection(true);
                } else {
                    SearchDialog.this.wholeWordButton.setSelection(false);
                }
            }
        }
    };
    private Listener dropdownListener = new Listener(){

        public void handleEvent(Event event) {
        }
    };

    public SearchDialog(Shell parentShell, Composite comp) {
        super(parentShell);
        if (comp instanceof DATableComposite) {
            this.table = ((DATableComposite)comp).getTable();
            this.viewName = ((DATableComposite)comp).getTableName();
        } else if (comp instanceof DATreeComposite) {
            this.table = ((DATreeComposite)comp).getTable();
            this.viewName = ((DATreeComposite)comp).getTableName();
        } else {
            this.table = null;
            return;
        }
        this.composite = comp;
        this.findProperty = DATableComposite.getFindProferty();
        this.findProperty.setIndex(this.table.getSelectionIndex());
    }

    protected boolean run() {
        if (this.table == null) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 223) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(430, 223);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.SEARCH_DLG_TITLE);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.DIALOG_TOP_LINE_COLOR);
                e.gc.drawLine(0, 0, 430, 0);
                e.gc.setForeground(ColorResources.DIALOG_BUTTON_LINE_COLOR);
                e.gc.drawLine(0, 139, 430, 139);
            }
        });
        Composite contentComp = new Composite((Composite)this.shell, 0);
        FormLayout contentLayout = new FormLayout();
        contentComp.setLayout((Layout)contentLayout);
        contentComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment(0, 0);
        data.width = 430;
        data.height = 138;
        contentComp.setLayoutData((Object)data);
        Label descriptionLabel = new Label(contentComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 30);
        data.left = new FormAttachment(0, 20);
        data.height = 26;
        data.width = 410;
        descriptionLabel.setLayoutData((Object)data);
        descriptionLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        descriptionLabel.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
        descriptionLabel.setText(String.valueOf(AnalyzerLabels.SEARCH_DLG_DESC_PREFIX) + " " + this.viewName + " " + AnalyzerLabels.SEARCH_DLG_DESC_POSTFIX);
        this.categoryDropdown = this.makeDACustomDropdown(contentComp);
        data = new FormData();
        data.top = new FormAttachment(0, 56);
        data.left = new FormAttachment(0, 20);
        data.bottom = new FormAttachment(0, 80);
        data.right = new FormAttachment(0, 116);
        this.categoryDropdown.setLayoutData((Object)data);
        this.categoryDropdown.addListener(13, this.dropdownListener);
        this.textBox = new Text(contentComp, 2052);
        data = new FormData();
        data.top = new FormAttachment(0, 56);
        data.left = new FormAttachment(0, 126);
        data.bottom = new FormAttachment(0, 80);
        data.right = new FormAttachment(0, 410);
        this.textBox.setLayoutData((Object)data);
        this.textBox.setFont(new Font((Device)this.textBox.getDisplay(), "Arial", 10, 0));
        this.textBox.addKeyListener(this.keyListener);
        Label optionLabel = new Label(contentComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 96);
        data.left = new FormAttachment(0, 20);
        data.height = 18;
        data.width = 106;
        optionLabel.setLayoutData((Object)data);
        optionLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        optionLabel.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
        optionLabel.setText(AnalyzerLabels.SEARCH_DLG_OPTION);
        this.caseButton = new Button(contentComp, 32);
        data = new FormData();
        data.top = new FormAttachment(0, 96);
        data.left = new FormAttachment((Control)optionLabel, 0);
        data.width = 18;
        data.height = 18;
        this.caseButton.setLayoutData((Object)data);
        this.caseButton.addSelectionListener(this.caseButtonListener);
        if (this.findProperty.isCaseSensitive()) {
            this.caseButton.setSelection(true);
        }
        this.caseButtonLabel = new Label(contentComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 96);
        data.left = new FormAttachment((Control)this.caseButton, 4);
        data.height = 18;
        data.width = 100;
        this.caseButtonLabel.setLayoutData((Object)data);
        this.caseButtonLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.caseButtonLabel.setText(AnalyzerLabels.SEARCH_DLG_CASE_SENSITIVE);
        this.caseButtonLabel.addListener(4, this.caseButtonLabelListener);
        this.wholeWordButton = new Button(contentComp, 32);
        data = new FormData();
        data.top = new FormAttachment(0, 96);
        data.left = new FormAttachment((Control)this.caseButtonLabel, 38);
        data.width = 18;
        data.height = 18;
        this.wholeWordButton.setLayoutData((Object)data);
        this.wholeWordButton.addSelectionListener(this.wholeWordButtonListener);
        if (this.findProperty.isWholeWord()) {
            this.wholeWordButton.setSelection(true);
        }
        this.wholeWordButtonLabel = new Label(contentComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 96);
        data.left = new FormAttachment((Control)this.wholeWordButton, 4);
        data.height = 18;
        data.width = 130;
        this.wholeWordButtonLabel.setLayoutData((Object)data);
        this.wholeWordButtonLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.wholeWordButtonLabel.setText(AnalyzerLabels.SEARCH_DLG_WHOLE_WORD);
        this.wholeWordButtonLabel.addListener(4, this.wholeWordButtonLabelListener);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        FormLayout buttonLayout = new FormLayout();
        buttonComp.setLayout((Layout)buttonLayout);
        buttonComp.setBackground(ColorResources.DIALOG_BUTTON_BACKGROUND);
        data = new FormData();
        data.top = new FormAttachment(0, 140);
        data.left = new FormAttachment(0, 0);
        data.width = 430;
        data.height = 60;
        buttonComp.setLayoutData((Object)data);
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(100, -298);
        data.height = 25;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(AnalyzerLabels.SEARCH_DLG_CANCEL_BUTTON);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setOutlineColors(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        this.backButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(100, -202);
        data.height = 25;
        data.width = 86;
        this.backButton.setLayoutData((Object)data);
        this.backButton.setText(AnalyzerLabels.SEARCH_DLG_BACK_BUTTON);
        this.backButton.addClickListener(this.backButtonListener);
        this.backButton.setOutlineColors(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        this.nextButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(100, -106);
        data.height = 25;
        data.width = 86;
        this.nextButton.setLayoutData((Object)data);
        this.nextButton.setText(AnalyzerLabels.SEARCH_DLG_NEXT_BUTTON);
        this.nextButton.addClickListener(this.nextButtonListener);
        this.nextButton.setOutlineColors(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        this.updateCategoryDropdown();
        this.textBox.setFocus();
        return true;
    }

    private boolean executeFindCommand() {
        int index = this.findProperty.getIndex();
        GridItem[] items = this.table.getItems();
        int itemCount = items.length;
        this.categoryDropdown.getText();
        if (itemCount != 0) {
            index = this.findProperty.isBackward() ? (index - 1 < 0 ? itemCount - 1 : index - 1) : (index + 1 > itemCount - 1 ? 0 : index + 1);
            int findIndex = -1;
            this.findProperty.setIndex(index);
            if (this.composite instanceof DATableComposite) {
                findIndex = ((DATableComposite)this.composite).searchString(this.findProperty);
            } else if (this.composite instanceof DATreeComposite) {
                findIndex = ((DATreeComposite)this.composite).searchString(this.findProperty);
            } else {
                return false;
            }
            this.findProperty.setIndex(findIndex);
            return true;
        }
        return false;
    }

    public DACustomDropdown getCategoryDropdown() {
        return this.categoryDropdown;
    }

    private boolean selectCategoryDropdown(String item) {
        boolean ret = false;
        List categoryList = this.categoryDropdown.getItems();
        int size = categoryList.size();
        int i = 0;
        while (i < size) {
            if (ret) {
                this.categoryDropdown.select(i);
                if (!item.isEmpty()) {
                    this.categoryDropdown.setToolTipText(item);
                }
            }
            ++i;
        }
        return ret;
    }

    public boolean setCategory(String text) {
        return true;
    }

    public boolean updateCategoryDropdown() {
        this.categoryDropdown.add("All");
        this.categoryDropdown.select(0);
        this.redrawDropdown(this.categoryDropdown);
        return true;
    }

    private void redrawDropdown(final DACustomDropdown dropdown) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                dropdown.redraw();
            }
        });
    }

    private DACustomDropdown makeDACustomDropdown(Composite parent) {
        DACustomDropdown dropdown = new DACustomDropdown(parent, 0);
        dropdown.setDropdownGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        dropdown.setOutlineColors(ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130);
        dropdown.setDropdownImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        dropdown.setDropdownImagePoint(new Point(70, 10));
        dropdown.setDropdownButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        dropdown.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        dropdown.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        dropdown.setFontPoint(new Point(5, 5));
        dropdown.setFont(new Font((Device)dropdown.getDisplay(), "Arial", 10, 0));
        dropdown.setEnabled(true);
        dropdown.setDropdownFont(FontResources.COMBO);
        dropdown.setItemFont(FontResources.DROPDOWN);
        dropdown.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return dropdown;
    }

    public boolean updateCategoryDropdown(String newItem) {
        this.categoryDropdown.add(newItem);
        return true;
    }
}

