/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.text.DecimalFormat;
import org.tizen.dynamicanalyzer.util.Logger;

public class Formatter {
    public static String toHexString(String decimal) {
        block4: {
            if (decimal == null || decimal.isEmpty()) {
                return null;
            }
            try {
                if (!decimal.isEmpty()) break block4;
                return null;
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
                return decimal;
            }
        }
        long data = 0L;
        data = Long.parseLong(decimal);
        return String.format("0x%08X", data);
    }

    public static String toDoubleFormat1(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.1f", data);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return value;
        }
    }

    public static String toByteToMbNumberFormat2(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            long num = Long.parseLong(value);
            double kb = (double)(num /= 1024L) / 1024.0;
            String str = Formatter.toDoubleFormat2(Double.toString(kb));
            return str;
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return "0";
        }
    }

    public static String toDoubleFormat2(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.2f", data);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            return value;
        }
    }

    public static String toTimeFormat(Object time) {
        String strMs;
        String strSecond;
        long longTime = -1L;
        if (time instanceof Long || time instanceof Integer) {
            longTime = (Long)time;
        } else if (time instanceof String) {
            longTime = Long.parseLong((String)time);
        } else {
            return null;
        }
        long ms = (longTime /= 1000L) % 1000L;
        long second = (longTime /= 1000L) % 60L;
        long minute = (longTime /= 60L) % 60L;
        String strMinute = Long.toString(minute);
        if (strMinute.length() < 2) {
            strMinute = "0" + strMinute;
        }
        if ((strSecond = Long.toString(second)).length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strMinute) + ":" + strSecond + "." + strMs;
        return output;
    }

    public static String toOpentraceTimeFormat(Object time) {
        String strMs;
        String strSecond;
        String strMinute;
        long longTime = -1L;
        if (time instanceof Long || time instanceof Integer) {
            longTime = (Long)time;
        } else if (time instanceof String) {
            longTime = Long.parseLong((String)time);
        } else {
            return null;
        }
        long ms = (longTime /= 1000L) % 1000L;
        long second = (longTime /= 1000L) % 60L;
        long minute = (longTime /= 60L) % 60L;
        long hour = (longTime /= 60L) % 60L;
        String strHour = Long.toString(hour);
        if (strHour.length() < 2) {
            strHour = "0" + strHour;
        }
        if ((strMinute = Long.toString(minute)).length() < 2) {
            strMinute = "0" + strMinute;
        }
        if ((strSecond = Long.toString(second)).length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strHour) + ":" + strMinute + ":" + strSecond + "." + strMs;
        return output;
    }

    public static String toTimeFormat2(Object time) {
        String strMs;
        long longTime = -1L;
        if (time instanceof Long || time instanceof Integer) {
            longTime = (Long)time;
        } else if (time instanceof String) {
            longTime = Long.parseLong((String)time);
        } else {
            return null;
        }
        long ms = longTime % 1000L;
        long second = longTime /= 1000L;
        String strSecond = Long.toString(second);
        if (strSecond.length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strSecond) + "." + strMs;
        return output;
    }

    public static String toTimeFormat3(String time) {
        String strSecond;
        long longTime = Long.parseLong(time);
        long second = (longTime /= 1000000L) % 60L;
        long minute = (longTime /= 60L) % 60L;
        String strMinute = Long.toString(minute);
        if (strMinute.length() < 2) {
            strMinute = "0" + strMinute;
        }
        if ((strSecond = Long.toString(second)).length() < 2) {
            strSecond = "0" + strSecond;
        }
        String output = String.valueOf(strMinute) + ":" + strSecond;
        return output;
    }

    public static String toTimeFormat4(Object time) {
        String strMs;
        long longTime = -1L;
        if (time instanceof Long || time instanceof Integer) {
            longTime = (Long)time;
        } else if (time instanceof String) {
            longTime = Long.parseLong((String)time);
        } else {
            return null;
        }
        long ms = (longTime /= 1000L) % 1000L;
        long second = longTime /= 1000L;
        String strSecond = Long.toString(second);
        if (strSecond.length() < 2) {
            strSecond = "0" + strSecond;
        }
        if ((strMs = Long.toString(ms)).length() == 2) {
            strMs = "0" + strMs;
        } else if (strMs.length() == 1) {
            strMs = "00" + strMs;
        }
        String output = String.valueOf(strSecond) + "." + strMs;
        return output;
    }

    public static String toPercentageFormat(Double input) {
        String ret = String.format("%.2f", input);
        ret = String.valueOf(ret) + " %";
        return ret;
    }

    public static String toDoubleFormat(Double input) {
        return String.format("%.2f", input);
    }

    public static String toNumberFormat(long input) {
        String value;
        int reminder = 0;
        long quotient = input;
        String output = "";
        while (true) {
            reminder = (int)(quotient % 1000L);
            value = Integer.toString(reminder);
            if ((quotient /= 1000L) <= 0L) break;
            if (value.length() < 2) {
                value = "00" + value;
            } else if (value.length() < 3) {
                value = "0" + value;
            }
            output = String.valueOf(value) + output;
            output = "," + output;
        }
        output = String.valueOf(value) + output;
        return output;
    }

    public static String toNumberFormat(double input) {
        return Formatter.toNumberFormat((long)input);
    }

    public static String toByteFormat(long input) {
        int reminder = 0;
        long quotient = input;
        int count = 0;
        String value = "";
        boolean minus = false;
        if (quotient < 0L) {
            minus = true;
            quotient *= -1L;
        }
        while (quotient >= 1024L) {
            reminder = (int)(quotient % 1024L);
            quotient /= 1024L;
            ++count;
        }
        value = Long.toString(quotient);
        String remStr = Integer.toString(reminder);
        if (count > 0) {
            value = remStr.length() < 3 ? String.valueOf(value) + ".0" : String.valueOf(value) + "." + remStr.substring(0, 1);
        }
        value = String.valueOf(value) + " " + Formatter.getByteMeasure(count);
        if (minus) {
            value = "-" + value;
        }
        return value;
    }

    public static String toByteFormat(double input) {
        return Formatter.toByteFormat((long)input);
    }

    public static String toHzFormat(long input) {
        int reminder = 0;
        long quotient = input;
        int count = 0;
        String value = "";
        while (quotient >= 1000L) {
            reminder = (int)(quotient % 1000L);
            quotient /= 1000L;
            ++count;
        }
        value = Long.toString(quotient);
        String remStr = Integer.toString(reminder);
        if (count > 0) {
            value = remStr.length() < 3 ? String.valueOf(value) + ".0" : String.valueOf(value) + "." + remStr.substring(0, 1);
        }
        value = String.valueOf(value) + " " + Formatter.getHzMeasure(count);
        return value;
    }

    public static String toHzFormat(double input) {
        return Formatter.toHzFormat((long)input);
    }

    public static String toBpsFormat(long nByte, long startTime, long endTime) {
        String value = "";
        DecimalFormat df1 = new DecimalFormat("#,##0.00");
        double Bps = nByte;
        if (endTime - startTime >= 1000000L) {
            Bps = (double)nByte * (1000000.0 / (double)(endTime - startTime));
        }
        value = String.valueOf(value) + df1.format(Bps) + " Bps";
        return value;
    }

    public static String toBpsFormat(double nByte, long startTime, long endTime) {
        return Formatter.toBpsFormat((long)nByte, startTime, endTime);
    }

    private static String getByteMeasure(int count) {
        if (count == 4) {
            return "TiB";
        }
        if (count == 3) {
            return "GiB";
        }
        if (count == 2) {
            return "MiB";
        }
        if (count == 1) {
            return "KiB";
        }
        return "B";
    }

    private static String getHzMeasure(int count) {
        if (count == 4) {
            return "THz";
        }
        if (count == 3) {
            return "GHz";
        }
        if (count == 2) {
            return "MHz";
        }
        if (count == 1) {
            return "KHz";
        }
        return "Hz";
    }

    public static String toByteFormatValue(long input) {
        int reminder = 0;
        long quotient = input;
        int count = 0;
        String value = "";
        while (quotient >= 1024L) {
            reminder = (int)(quotient % 1024L);
            quotient /= 1024L;
            ++count;
        }
        value = Long.toString(quotient);
        String remStr = Integer.toString(reminder);
        if (count > 0) {
            value = remStr.length() < 3 ? String.valueOf(value) + ".0" : String.valueOf(value) + "." + remStr.substring(0, 1);
        }
        return value;
    }

    public static String toByteFormatMeasure(long input) {
        long quotient = input;
        int count = 0;
        String value = null;
        while (quotient >= 1024L) {
            quotient /= 1024L;
            ++count;
        }
        value = Formatter.getByteMeasure(count);
        return value;
    }

    public static double longTimeToDoubleTime(long time) {
        return (double)time / 1000000.0;
    }
}

