/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguageMappingChangeEvent;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class LanguageMappingChangeListener
implements ILanguageMappingChangeListener {
    private IIndexManager fManager;

    public LanguageMappingChangeListener(IIndexManager manager) {
        this.fManager = manager;
    }

    public void handleLanguageMappingChangeEvent(ILanguageMappingChangeEvent event) {
        CModelManager manager = CModelManager.getDefault();
        if (event.getType() == 0) {
            try {
                ICProject[] cProjects = manager.getCModel().getCProjects();
                int i = 0;
                while (i < cProjects.length) {
                    ICProject project = cProjects[i];
                    this.fManager.reindex(project);
                    ++i;
                }
            }
            catch (CModelException e) {
                CCorePlugin.log((Throwable)((Object)e));
            }
        } else if (event.getType() == 1) {
            ICProject cProject = manager.getCModel().getCProject((IResource)event.getProject());
            this.fManager.reindex(cProject);
        } else if (event.getType() == 2) {
            IFile file = event.getFile();
            ICProject cProject = manager.getCModel().getCProject((IResource)file);
            ICElement element = manager.create(file, cProject);
            try {
                this.fManager.update(new ICElement[]{element}, 1);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
    }
}

