/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class DAChartPlotTooltip {
    public static final int TOOLTIP_MARGIN = 4;
    public static final int TOOLTIP_TIME_MARGIN = 20;
    public static final int TOOLTIP_HEIGHT = 18;
    public static final int TOOLTIP_SERIES_RECT_LENGTH = 6;
    public static final int TOOLTIP_SHOW_MIN = 50;
    public static final int TOOLTIP_TEXT_HEIGHT = 10;
    public static final int TOOLTIP_TEXT_MARGIN = 8;
    public static final int TOOLTIP_BOTTOM_MARGIN = 5;
    private boolean drawTooltip = false;
    private double startVal;
    private double yPosRatio;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color lineColor;
    private Color textColor;
    private Color timeColor;
    private Font font;
    private List<DAChart> charts = new ArrayList<DAChart>();

    public DAChartPlotTooltip(double start) {
        this.setStartVal(start);
    }

    public List<DAChart> getRegisteChartList() {
        return this.charts;
    }

    public void registerChart(DAChart chart) {
        this.charts.add(chart);
    }

    public void unRegisterChart(DAChart chart) {
        int i = 0;
        while (i < this.charts.size()) {
            if (((Object)((Object)this.charts.get(i))).equals((Object)chart)) {
                this.charts.remove(i);
            }
            ++i;
        }
    }

    private void redrawRegisteredChart() {
        int i = 0;
        while (i < this.charts.size()) {
            if (this.charts.get(i).isDisposed()) {
                this.charts.remove(i);
            } else {
                this.charts.get(i).redraw();
            }
            ++i;
        }
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = ColorResources.CHART_TOOLTIP_BACKGROUND;
        }
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public Color getForegroundColor() {
        if (this.foregroundColor == null) {
            this.foregroundColor = ColorResources.CHART_TOOLTIP_FOREGROUND;
        }
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public Color getLineColor() {
        if (this.lineColor == null) {
            this.lineColor = ColorResources.CHART_TOOLTIP_LINE;
        }
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public Color getTextColor() {
        if (this.textColor == null) {
            this.textColor = ColorResources.CHART_TOOLTIP_TEXT;
        }
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public Color getTimeColor() {
        if (this.timeColor == null) {
            this.timeColor = ColorResources.CHART_TOOLTIP_TIME;
        }
        return this.timeColor;
    }

    public void setTimeColor(Color timeColor) {
        this.timeColor = timeColor;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = FontResources.TIMELINE_FONT;
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public double getStartVal() {
        return this.startVal;
    }

    public void setStartVal(double startVal) {
        this.startVal = startVal;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public double getYPosRatio() {
        return this.yPosRatio;
    }

    public void setYPosRatio(double yPosRatio) {
        this.yPosRatio = yPosRatio;
        if (this.drawTooltip) {
            this.redrawRegisteredChart();
        }
    }

    public boolean shouldBeDrawn() {
        return this.drawTooltip;
    }

    public void setTooltip(boolean show) {
        this.drawTooltip = show;
        this.redrawRegisteredChart();
    }
}

