/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.combo;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.combo.IDACustomComboPopupRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class DACustomComboPopupRenderer
implements IDACustomComboPopupRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, List<Rectangle> rects, int selection, List<String> items, Font font, Color itemFontColor) {
        int itemSize;
        int size = rects.size();
        if (size != (itemSize = items.size())) {
            Logger.debug((Object)("invalid parameter in popup renderer : Rect size " + size + "item size :" + itemSize));
            return;
        }
        int i = 0;
        while (i < size) {
            Rectangle r = rects.get(i);
            if (selection == i) {
                gc.setBackground(ColorResources.POINT);
                gc.fillRectangle(r);
                gc.setForeground(ColorResources.DEVICE_APPLICATION_ITEM_SELECT_TOP);
                gc.drawLine(r.x, r.y, r.x + r.width, r.y);
                gc.setForeground(ColorResources.DEVICE_APPLICATION_ITEM_SELECT_BOTTOM);
                gc.drawLine(r.x, r.y + r.height - 1, r.x + r.width, r.y + r.height - 1);
            } else {
                gc.setBackground(ColorResources.WHITE);
                gc.fillRectangle(r);
                gc.setForeground(ColorResources.DEVICE_APPLICATION_ITEM_NORMAL_TOP);
                gc.drawLine(r.x, r.y, r.x + r.width, r.y);
                gc.setForeground(ColorResources.DEVICE_APPLICATION_ITEM_NORMAL_BOTTOM);
                gc.drawLine(r.x, r.y + r.height - 1, r.x + r.width, r.y + r.height - 1);
            }
            if (itemFontColor != null) {
                gc.setForeground(itemFontColor);
            } else {
                gc.setForeground(ColorResources.DEVICE_APPLICATION_DROPDOWN_TEXT);
            }
            if (font == null) {
                gc.setFont(FontResources.DROPDOWN);
            } else {
                gc.setFont(font);
            }
            gc.drawString(items.get(i), 10, 6 + i * r.height, true);
            Rectangle rect = canvas.getClientArea();
            gc.setForeground(ColorResources.DEVICE_APPLICATION_POPUP_OUTER_1);
            gc.drawLine(rect.x, rect.y, rect.x, rect.height);
            gc.drawLine(rect.width - 1, rect.y, rect.width - 1, rect.height);
            gc.setForeground(ColorResources.DEVICE_APPLICATION_POPUP_OUTER_2);
            gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 2);
            ++i;
        }
    }
}

