/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timeline;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;
import org.tizen.dynamicanalyzer.widgets.helper.ImageResources;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineMarker;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineRenderer;

public class DATimelineTimeRenderer
extends DATimelineRenderer {
    protected final Image balloon = ImageResources.TIMELINE_DETAILED_TIME_BALLOON;
    protected final int balloonHalfWidth;
    protected final int balloonHalfHeight;
    protected static final int TIME_LINE_MID_LINE_HEIGHT = 1;
    protected static final int TICK_LINE_HEIGHT_TALL = 6;
    protected static final int TICK_LINE_HEIGHT_SMALL = 4;
    protected static final int TIME_STRING_PIXEL_Y = 4;
    protected static final int MARKER_START_Y = 5;
    protected int startTime;
    protected int scale;

    public DATimelineTimeRenderer() {
        this.balloonHalfWidth = this.balloon.getBounds().width / 2;
        this.balloonHalfHeight = this.balloon.getBounds().height / 2;
    }

    protected void drawRangeMarkers(GC gc, DATimeline timeline) {
        List<DATimelineMarker> markerList = timeline.getMarkerList();
        for (DATimelineMarker marker : markerList) {
            if (!(marker.getTime() >= 0.0)) continue;
            Image markerImage = marker.getImage();
            double markerTime = marker.getTime() - timeline.getStartTime();
            int pixelStartX = (int)Math.round(markerTime * (double)this.scale * 5.0) - markerImage.getBounds().width / 2;
            gc.drawImage(markerImage, pixelStartX - 1, 5);
        }
    }

    protected void drawTimeString(GC gc, int totalSecond, int pixelX, int pixelY) {
        String timeString = Formatter.toTimelineFormat(totalSecond);
        Point p = gc.textExtent(timeString, 8);
        gc.setForeground(ColorResources.TIMELINE_NUMBER_COLOR);
        gc.drawText(timeString, pixelX - p.x / 2, pixelY, true);
        gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
    }

    @Override
    public void draw(GC gc, DATimeline timeline) {
        Rectangle rt = timeline.getClientArea();
        gc.setFont(this.timeTickFont);
        gc.setBackground(ColorResources.GRAY_245);
        gc.fillRectangle(rt);
        gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
        gc.drawLine(0, 0, rt.width, 0);
        gc.drawLine(0, rt.height - 1, rt.width, rt.height - 1);
        int pixelX = 0;
        this.scale = timeline.getScale();
        int secondInterval = this.scale * 5;
        this.startTime = (int)timeline.getStartTime();
        pixelX = (int)((double)pixelX - (timeline.getStartTime() - (double)this.startTime) * (double)secondInterval);
        while (pixelX < rt.width) {
            if (this.startTime % 10 == 0) {
                this.drawTimeString(gc, this.startTime, pixelX, 4);
                gc.drawLine(pixelX, rt.height - 6, pixelX, rt.height - 1);
            } else if (this.startTime % 5 == 0) {
                if (this.scale >= 4) {
                    this.drawTimeString(gc, this.startTime, pixelX, 4);
                }
                gc.drawLine(pixelX, rt.height - 6, pixelX, rt.height - 1);
            } else {
                if (this.scale >= 8) {
                    this.drawTimeString(gc, this.startTime, pixelX, 4);
                }
                gc.drawLine(pixelX, rt.height - 4, pixelX, rt.height - 1);
            }
            ++this.startTime;
            pixelX += secondInterval;
        }
        this.drawRangeMarkers(gc, timeline);
        if (timeline.getDrawDetailedTime()) {
            gc.drawImage(this.balloon, 0, 0, this.balloon.getBounds().width, this.balloon.getBounds().height, timeline.getDetailedTimePosition() - this.balloonHalfWidth, 0, this.balloon.getBounds().width, timeline.getBounds().height - 1);
            String time = Formatter.toTimeFormat((long)(timeline.getDetailedTime() * 1000000.0));
            gc.setForeground(ColorResources.BLACK);
            gc.setFont(this.timeBalloonFont);
            gc.drawString(time, timeline.getDetailedTimePosition() - gc.stringExtent((String)time).x / 2, gc.stringExtent((String)time).y / 2 - 4, true);
        }
    }
}

