/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.toggle;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomToggleButton
extends DACustomButton {
    public static final int STATE_TOGGLE = 4;
    public static final int STATE_TOGGLE_HOVER = 5;
    public static final int STATE_TOGGLE_PUSH = 6;
    private boolean toggle = false;
    private boolean toggleByButton = false;
    private Listener toggleButtonMouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (DACustomToggleButton.this.state == 3) {
                return;
            }
            if (event.type == 6) {
                if (DACustomToggleButton.this.toggle) {
                    DACustomToggleButton.this.changeButtonState(5);
                } else {
                    DACustomToggleButton.this.changeButtonState(2);
                }
            }
            if (event.type == 7) {
                if (DACustomToggleButton.this.toggle) {
                    DACustomToggleButton.this.changeButtonState(4);
                } else {
                    DACustomToggleButton.this.changeButtonState(0);
                }
            }
            if (event.type == 3) {
                if (DACustomToggleButton.this.toggle) {
                    if (DACustomToggleButton.this.attr.getImage(6) != null) {
                        DACustomToggleButton.this.changeButtonState(6);
                    } else {
                        DACustomToggleButton.this.changeButtonState(1);
                    }
                } else {
                    DACustomToggleButton.this.changeButtonState(1);
                }
            }
            if (event.type == 4) {
                DACustomToggleButton.this.toggle = !DACustomToggleButton.this.toggle;
                DACustomToggleButton.this.toggleByButton = !DACustomToggleButton.this.toggleByButton;
                if (DACustomToggleButton.this.toggle) {
                    DACustomToggleButton.this.changeButtonState(5);
                } else {
                    DACustomToggleButton.this.changeButtonState(2);
                }
            }
        }
    };

    public DACustomToggleButton(Composite parent, Image normal, Image push, Image hover, Image disable, Image toggle, Image toggleHover) {
        super(parent, normal, push, hover, disable);
        this.buttonRenderer = new DACustomToggleButtonRenderer();
        this.attr.setImage(4, toggle);
        this.attr.setImage(5, toggleHover);
        this.addToggleListeners();
    }

    public DACustomToggleButton(Composite parent, Image normal, Image push, Image hover, Image disable, Image toggle, Image toggleHover, Image togglePush) {
        this(parent, normal, push, hover, disable, toggle, toggleHover);
        this.buttonRenderer = new DACustomToggleButtonRenderer();
        this.attr.setImage(6, togglePush);
    }

    public DACustomToggleButton(Composite parent, int style) {
        super(parent, style);
        this.buttonRenderer = new DACustomToggleButtonRenderer();
        this.attr.setColor(4, ColorResources.BLUE);
        this.attr.setColor(5, ColorResources.WHITE);
        this.addToggleListeners();
    }

    public DACustomToggleButton(Composite parent, Color normalStart, Color normalEnd, Color pushStart, Color pushEnd, Color hoverStart, Color hoverEnd, Color disableStart, Color disableEnd, Color toggleStart, Color toggleEnd, Color toggleHoverStart, Color toggleHoverEnd, Color togglePushStart, Color togglePushEnd) {
        this(parent, 0);
        this.attr.setColor(0, normalStart);
        this.attr.setColor(1, normalEnd);
        this.attr.setColor(2, pushStart);
        this.attr.setColor(3, pushEnd);
        this.attr.setColor(4, hoverStart);
        this.attr.setColor(5, hoverEnd);
        this.attr.setColor(6, disableStart);
        this.attr.setColor(7, disableEnd);
        this.attr.setColor(8, toggleStart);
        this.attr.setColor(9, toggleEnd);
        this.attr.setColor(10, toggleHoverStart);
        this.attr.setColor(11, toggleHoverEnd);
        this.attr.setColor(12, togglePushStart);
        this.attr.setColor(13, togglePushEnd);
        this.attr.setDrawType(2);
    }

    public void setColors(Color normal, Color push, Color hover, Color disable, Color toggle, Color toggleHover, Color togglePush) {
        this.setColors(normal, push, hover, disable);
        this.attr.setColor(4, toggle);
        this.attr.setColor(5, toggleHover);
        this.attr.setColor(6, togglePush);
    }

    public void setButtonImages(Image normal, Image push, Image hover, Image disable, Image toggle, Image toggleHover, Image togglePush) {
        this.setButtonImages(normal, push, hover, disable);
        this.attr.setButtonImage(4, toggle);
        this.attr.setButtonImage(5, toggleHover);
        this.attr.setButtonImage(6, togglePush);
    }

    public void setOutlineColors(Color normal, Color push, Color hover, Color disable, Color toggle, Color toggleHover, Color togglePush) {
        this.setOutlineColors(normal, togglePush, toggleHover, disable);
        this.attr.setOutlineColor(4, toggle);
        this.attr.setOutlineColor(5, toggleHover);
        this.attr.setOutlineColor(6, togglePush);
    }

    public void setOutlineInColors(Color normal, Color push, Color hover, Color disable, Color toggle, Color toggleHover, Color togglePush) {
        this.setOutlineInColors(normal, togglePush, toggleHover, disable);
        this.attr.setOutlineInColor(4, toggle);
        this.attr.setOutlineInColor(5, toggleHover);
        this.attr.setOutlineInColor(6, togglePush);
    }

    private void addToggleListeners() {
        if (this.toggleButtonMouseListener != null) {
            this.addListener(6, this.toggleButtonMouseListener);
            this.addListener(7, this.toggleButtonMouseListener);
            this.addListener(3, this.toggleButtonMouseListener);
            this.addListener(4, this.toggleButtonMouseListener);
        }
    }

    public void setToggled(boolean toggled) {
        this.toggle = toggled;
        if (toggled) {
            this.changeButtonState(4);
        } else {
            this.changeButtonState(0);
        }
    }

    public void setToggled2(boolean toggled) {
        if (!this.toggleByButton) {
            this.toggle = toggled;
            if (toggled) {
                this.changeButtonState(4);
            } else {
                this.changeButtonState(0);
            }
        }
    }

    public boolean isToggled() {
        return this.toggle;
    }
}

