/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenResourceManager {
    private static TizenResourceManager instance;
    public static final Color GRAY_COLOR;
    public static final Color WHITE_COLOR;
    public static final Color BLACK_COLOR;
    public static final Color BLUE_COLOR;
    public static final Color LINE_NORMAL;
    public static final Color LINE_SELECT;
    public static final Color PROGRESS_BAR_COLOR;
    public static final Color RADIO_BUTTON_NORMAL_FONT_COLOR;
    public static final Color RADIO_BUTTON_SELECT_COLOR;
    public static final Color RADIO_BUTTON_DIMMED_FONT_COLOR;
    public static final Color PUSH_BUTTON_NORMAL_FONT_COLOR;
    public static final Color PUSH_BUTTON_PUSH_COLOR;
    public static final Color PUSH_BUTTON_HOVER_COLOR;
    public static final Color PUSH_BUTTON_DISABLE_FONT_COLOR;
    public static final Color PUSH_BUTTON_FOCUS_FONT_COLOR;
    public static final Color PUSH_BUTTON_NORMAL_BG_COLOR;
    public static final Color PUSH_BUTTON_SELECT_BG_COLOR;
    public static final Color PUSH_BUTTON_HOVER_BG_COLOR;
    public static final Color PUSH_BUTTON_DISABLE_BG_COLOR;
    public static final Color PUSH_BUTTON_FOCUS_BG_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_NORMAL_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_PUSH_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_HOVER_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_DISABLE_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_FOCUS_COLOR;
    public static final Color ARROW_BUTTON_NORMAL_COLOR;
    public static final Color ARROW_BUTTON_PUSH_COLOR;
    public static final Color ARROW_BUTTON_HOVER_COLOR;
    public static final Color ARROW_BUTTON_DISABLE_COLOR;
    public static final Color COMBO_LINE_NORMAL_COLOR;
    public static final Color COMBO_LINE_PUSH_COLOR;
    public static final Color COMBO_LINE_HOVER_COLOR;
    public static final Color COMBO_LINE_DISABLE_COLOR;
    public static final Color COMBO_BG_NORMAL_COLOR;
    public static final Color COMBO_BG_PUSH_COLOR;
    public static final Color COMBO_BG_HOVER_COLOR;
    public static final Color COMBO_BG_DISABLE_COLOR;
    public static final Color COMBO_FONT_NORMAL_COLOR;
    public static final Color COMBO_FONT_PUSH_COLOR;
    public static final Color COMBO_FONT_HOVER_COLOR;
    public static final Color COMBO_FONT_DISABLE_COLOR;
    public static String DEFAULT_FONT_NAME;
    public static Font NORMAL_FONT;
    static final ClassLoader loader;
    public Image checkBoxSelected = TizenResourceManager.getImageSafely("images/pro_checkbox_sel.png");
    public Image checkBoxSelectedHover = TizenResourceManager.getImageSafely("images/pro_checkbox_sel.png");
    public Image checkBoxUnelectedHover = TizenResourceManager.getImageSafely("images/pro_checkbox_bg.png");
    public Image checkBoxUnselected = TizenResourceManager.getImageSafely("images/pro_checkbox_bg.png");
    public Image checkBoxUnselectedDisable = TizenResourceManager.getImageSafely("images/pro_checkbox_bg.png");
    public Image checkBoxSelectedDisable = TizenResourceManager.getImageSafely("images/pro_checkbox_sel.png");
    public Image radioSelected = TizenResourceManager.getImageSafely("images/pro_button_icon_sel.png");
    public Image radioSelectedHover = TizenResourceManager.getImageSafely("images/pro_button_icon_sel.png");
    public Image radioUnelectedHover = TizenResourceManager.getImageSafely("images/pro_button_icon_bg.png");
    public Image radioUnselected = TizenResourceManager.getImageSafely("images/pro_button_icon_bg.png");
    public Image radioUnselectedDisable = TizenResourceManager.getImageSafely("images/pro_button_icon_bg.png");
    public Image radioSelectedDisable = TizenResourceManager.getImageSafely("images/pro_button_icon_sel.png");

    static {
        GRAY_COLOR = TizenResourceManager.getColorSafely(177, 177, 177);
        WHITE_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        BLACK_COLOR = TizenResourceManager.getColorSafely(0, 0, 0);
        BLUE_COLOR = TizenResourceManager.getColorSafely(0, 0, 255);
        LINE_NORMAL = TizenResourceManager.getColorSafely(170, 170, 170);
        LINE_SELECT = TizenResourceManager.getColorSafely(0, 150, 221);
        PROGRESS_BAR_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        RADIO_BUTTON_NORMAL_FONT_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        RADIO_BUTTON_SELECT_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        RADIO_BUTTON_DIMMED_FONT_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        PUSH_BUTTON_NORMAL_FONT_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        PUSH_BUTTON_PUSH_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        PUSH_BUTTON_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_DISABLE_FONT_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        PUSH_BUTTON_FOCUS_FONT_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_NORMAL_BG_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        PUSH_BUTTON_SELECT_BG_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_HOVER_BG_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        PUSH_BUTTON_DISABLE_BG_COLOR = TizenResourceManager.getColorSafely(206, 206, 206);
        PUSH_BUTTON_FOCUS_BG_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        PUSH_BUTTON_OUTLINE_NORMAL_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        PUSH_BUTTON_OUTLINE_PUSH_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        PUSH_BUTTON_OUTLINE_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        PUSH_BUTTON_OUTLINE_DISABLE_COLOR = TizenResourceManager.getColorSafely(115, 115, 115);
        PUSH_BUTTON_OUTLINE_FOCUS_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        ARROW_BUTTON_NORMAL_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        ARROW_BUTTON_PUSH_COLOR = TizenResourceManager.getColorSafely(163, 163, 163);
        ARROW_BUTTON_HOVER_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        ARROW_BUTTON_DISABLE_COLOR = TizenResourceManager.getColorSafely(206, 206, 206);
        COMBO_LINE_NORMAL_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        COMBO_LINE_PUSH_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        COMBO_LINE_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        COMBO_LINE_DISABLE_COLOR = TizenResourceManager.getColorSafely(177, 177, 177);
        COMBO_BG_NORMAL_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        COMBO_BG_PUSH_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        COMBO_BG_HOVER_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        COMBO_BG_DISABLE_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        COMBO_FONT_NORMAL_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        COMBO_FONT_PUSH_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        COMBO_FONT_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 150, 221);
        COMBO_FONT_DISABLE_COLOR = TizenResourceManager.getColorSafely(177, 177, 177);
        DEFAULT_FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
        NORMAL_FONT = TizenResourceManager.getDefaultFontSafely();
        loader = TizenResourceManager.class.getClassLoader();
    }

    public static TizenResourceManager getInstance() {
        if (instance == null) {
            instance = new TizenResourceManager();
        }
        return instance;
    }

    public static Image getImageSafely(String file) {
        final Image img = new Image((Device)Display.getCurrent(), TizenResourceManager.class.getResourceAsStream(file));
        Display display = Display.getCurrent();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!img.isDisposed()) {
                    img.dispose();
                }
            }
        });
        return img;
    }

    public static Color getColorSafely(int r, int g, int b) {
        Display display = Display.getCurrent();
        final Color color = new Color(display, r, g, b);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!color.isDisposed()) {
                    color.dispose();
                }
            }
        });
        return color;
    }

    public static Font getFontSafely(String fontName, int size) {
        final Font font = new Font((Device)Display.getCurrent(), fontName, size, 0);
        Display.getCurrent().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        return font;
    }

    public static Font getDefaultFontSafely() {
        int nSize = 11;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            nSize = 9;
        }
        final Font font = new Font((Device)Display.getCurrent(), DEFAULT_FONT_NAME, nSize, 0);
        Display.getCurrent().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        return font;
    }
}

