/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.dynamicanalyzer.util.CommonUtil;

public class InternalLogger {
    private static InternalLogger instance;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int CHECK = 3;
    public static final int DEBUG = 4;
    public static final int PERFORMANCE = 5;
    private static final int PERFORMANCE_TEST_COUNT = 20;
    private static final String PERFORMANCE_TEST_NAME = "DA performance test";
    private static final String TABSPACE = "    ";
    private static final String SEPARATOR_PIPE = " | ";
    private static final String SEPARATOR_COLON = ": ";
    private static final String SEPARATOR_DASH = " - ";
    private int logLevel;
    private SimpleDateFormat dateFormat;
    private File outputFile = null;
    private FileWriter fileWriter = null;
    private BufferedWriter bufWriter = null;
    private PrintWriter printWriter = null;
    private String defaultSaveFilename = "DA_Autotest_Result.xsd";
    private HashMap<String, List<Long>> startTimeMap;
    private HashMap<String, Integer> testCountMap;
    private HashMap<String, Integer> testTotalCountMap;
    private HashMap<String, Long> totalSpentTimeMap;
    private HashMap<String, List<Long>> subThreadStartTimeMap;
    private HashMap<String, Integer> subThreadStartCountMap;

    public InternalLogger() {
        this.init();
    }

    public static synchronized InternalLogger getInstance() {
        if (instance == null) {
            instance = new InternalLogger();
        }
        return instance;
    }

    private void init() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    }

    public boolean checkLevel(int currentLogLevel) {
        return this.logLevel >= currentLogLevel;
    }

    private boolean openWriter(String folderPath, String savefileName) {
        if (InstallPathConfig.getUserDataPath() == null) {
            System.out.println("user data path is null !!");
            return false;
        }
        File testFolderPath = new File(folderPath);
        if (!testFolderPath.exists() && !testFolderPath.mkdirs()) {
            System.out.println("failed to create test folder...");
            return false;
        }
        StringBuilder savePath = new StringBuilder(folderPath);
        savePath.append(File.separator);
        if (savefileName == null) {
            savePath.append(this.defaultSaveFilename);
        } else {
            savePath.append(savefileName);
        }
        this.outputFile = new File(savePath.toString());
        try {
            this.fileWriter = new FileWriter(this.outputFile);
            this.bufWriter = new BufferedWriter(this.fileWriter);
            this.printWriter = new PrintWriter(this.bufWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void closeWriter() {
        CommonUtil.tryClose(this.fileWriter, this.bufWriter, this.printWriter);
        this.outputFile = null;
        this.fileWriter = null;
        this.bufWriter = null;
        this.printWriter = null;
    }

    public void printLog() {
        System.out.println();
    }

    public void printLog(boolean applyNewLine, int logType, Object msg) {
        if (!applyNewLine) {
            System.out.print(msg);
        } else if (msg instanceof Throwable) {
            Throwable e = (Throwable)msg;
            StringBuilder exceptionMsg = new StringBuilder();
            String className = e.getClass().getName();
            if (className == null) {
                System.err.println("Throwable class name is null !!");
                return;
            }
            exceptionMsg.append(String.valueOf(className) + SEPARATOR_COLON);
            exceptionMsg.append(String.valueOf(e.getMessage()) + "\n");
            exceptionMsg.append(this.getCallstackInfo(e));
            System.err.println(exceptionMsg);
        } else if (logType == 5) {
            if (this.printWriter == null) {
                return;
            }
            this.printWriter.println(msg);
            this.printWriter.checkError();
        } else {
            StringBuilder logMsg = new StringBuilder();
            switch (logType) {
                case 0: {
                    logMsg.append("[ERROR] ");
                    break;
                }
                case 1: {
                    logMsg.append("[WARNING] ");
                    break;
                }
                case 2: {
                    logMsg.append("[INFO] ");
                    break;
                }
                case 3: {
                    logMsg.append("[CHECK] ");
                    break;
                }
                case 4: {
                    logMsg.append("[DEBUG] ");
                    break;
                }
            }
            logMsg.append(this.dateFormat.format(new Date()));
            logMsg.append(SEPARATOR_PIPE);
            if (logType != 0) {
                logMsg.append(this.getCallerInfo());
            }
            logMsg.append(String.valueOf(msg));
            if (logType == 0) {
                logMsg.append(this.getCallstackInfo());
                System.err.println(logMsg);
            } else {
                System.out.println(logMsg);
            }
        }
    }

    private String getCallerInfo() {
        String msg = null;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        if (trace.length >= 1) {
            msg = new String(String.valueOf(trace[3].getFileName()) + ":" + trace[3].getLineNumber() + SEPARATOR_DASH);
        }
        return msg;
    }

    private String getCallstackInfo() {
        String callstackMsg = new String("\n");
        StackTraceElement[] trace = new Throwable().getStackTrace();
        int i = 3;
        while (i < trace.length) {
            callstackMsg = String.valueOf(callstackMsg) + new String(TABSPACE + trace[i].toString() + "\n");
            ++i;
        }
        return callstackMsg;
    }

    private String getCallstackInfo(Throwable e) {
        String callstackMsg = new String();
        StackTraceElement[] trace = e.getStackTrace();
        int i = 0;
        while (i < trace.length) {
            callstackMsg = String.valueOf(callstackMsg) + new String(TABSPACE + trace[i].toString() + "\n");
            ++i;
        }
        return callstackMsg;
    }

    public String checkValidation(String filePath, String fileName) {
        if (filePath == null || fileName == null) {
            System.out.println("Log File Path or Log File Name is null !!");
            return null;
        }
        File log = new File(filePath);
        if (!log.exists() && !log.mkdirs()) {
            System.out.println("Failed to log directory or log file creation !!");
            return null;
        }
        return new String(String.valueOf(filePath) + File.separator + fileName);
    }

    public void performance(String key, String testStep, String description) {
        if (this.checkLevel(5)) {
            String msg = this.performanceNormal(key, description);
            if (msg != null) {
                this.printLog(true, 5, this.makeTestLog(testStep, msg));
            }
        } else {
            return;
        }
    }

    public void performance(String key, String testStep, String description, testState state) {
        block6: {
            block5: {
                if (!this.checkLevel(5)) break block5;
                switch (state) {
                    case START: {
                        this.performanceSubThreadStart(description);
                        break;
                    }
                    case END: {
                        String msg = this.performanceSubThreadEnd(key, testStep, description);
                        if (msg != null) {
                            this.printLog(true, 5, this.makeTestLog(testStep, msg));
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block6;
            }
            return;
        }
    }

    public void performanceStart(String folderPath, String savefileName, String key) {
        List<Object> startTimes;
        if (this.printWriter == null && !this.openWriter(folderPath, savefileName)) {
            return;
        }
        this.startTimeMap = new HashMap();
        this.testCountMap = new HashMap();
        this.testTotalCountMap = new HashMap();
        this.totalSpentTimeMap = new HashMap();
        this.subThreadStartTimeMap = new HashMap();
        this.subThreadStartCountMap = new HashMap();
        Integer count = this.testCountMap.get(key);
        if (count == null) {
            count = 1;
            this.testCountMap.put(key, count);
            startTimes = new ArrayList();
            this.startTimeMap.put(key, startTimes);
            this.testTotalCountMap.put(key, 0);
            this.totalSpentTimeMap.put(key, 0L);
        } else {
            this.testCountMap.put(key, count + 1);
            startTimes = this.startTimeMap.get(key);
        }
        long nanoTime = System.nanoTime();
        startTimes.add(nanoTime);
        StringBuilder msg = new StringBuilder();
        msg.append("<testsuite name=\"");
        msg.append(PERFORMANCE_TEST_NAME);
        msg.append("\">");
        this.printLog(true, 5, msg);
    }

    public String performanceNormal(String key, String description) {
        String msg = null;
        long nanoTime = System.nanoTime();
        Integer count = this.testCountMap.get(key);
        if (count == null || count == 0) {
            this.printLog(true, 5, "Can't find starting log about \"" + key + "\" key value !!");
        } else {
            List<Long> startTimes = this.startTimeMap.get(key);
            long startTime = startTimes.remove(startTimes.size() - 1);
            long spendTime = nanoTime - startTime;
            int totalCount = this.testTotalCountMap.get(key) + 1;
            long totalTime = this.totalSpentTimeMap.get(key) + spendTime;
            startTimes.add(nanoTime);
            this.testTotalCountMap.put(key, totalCount);
            this.totalSpentTimeMap.put(key, totalTime);
            double time = (double)spendTime / 1.0E9;
            msg = new String("name=\"" + description + "\" time=\"" + String.format("%.3f", time) + "\"");
        }
        return msg;
    }

    public void performanceEnd(String key) {
        long nanoTime = System.nanoTime();
        Integer count = this.testCountMap.get(key);
        if (count == null || count == 0) {
            this.printLog(true, 5, "Can't find starting log about \"" + key + "\" key value !!");
        } else {
            List<Long> startTimes = this.startTimeMap.get(key);
            long startTime = startTimes.remove(startTimes.size() - 1);
            long spendTime = nanoTime - startTime;
            long totalTime = this.totalSpentTimeMap.get(key) + spendTime;
            this.testCountMap.put(key, count - 1);
            this.totalSpentTimeMap.put(key, totalTime);
            StringBuilder msg = new StringBuilder();
            msg.append("</testsuite>");
            this.printLog(true, 5, msg);
            this.closeWriter();
        }
    }

    public void performanceSubThreadStart(String description) {
        long nanoTime = System.nanoTime();
        Integer count = this.subThreadStartCountMap.get(description);
        if (count == null || count == 0) {
            count = 1;
            this.subThreadStartCountMap.put(description, count);
            ArrayList<Long> startTimes = new ArrayList<Long>();
            this.subThreadStartTimeMap.put(description, startTimes);
            startTimes.add(nanoTime);
        }
    }

    public String performanceSubThreadEnd(String key, String testStep, String description) {
        String msg = null;
        long nanoTime = System.nanoTime();
        Integer count = this.subThreadStartCountMap.get(description);
        if (count == null || count == 0) {
            this.printLog(true, 5, "Can't find sub thread starting log about \"" + description + "\" key value !!");
        } else {
            List<Long> startTimes = this.subThreadStartTimeMap.get(description);
            long startTime = startTimes.remove(startTimes.size() - 1);
            long spendTime = nanoTime - startTime;
            this.subThreadStartCountMap.put(description, count - 1);
            double time = (double)spendTime / 1.0E9;
            msg = new String("name=\"" + description + "\" time=\"" + String.format("%.3f", time) + "\"");
        }
        return msg;
    }

    private CharSequence makeCommonLog(int logType, String logMessage) {
        StringBuilder msg = new StringBuilder();
        switch (logType) {
            case 0: {
                msg.append("[ERROR] ");
                break;
            }
            case 1: {
                msg.append("[WARNING] ");
                break;
            }
            case 3: {
                msg.append("[CHECK] ");
                break;
            }
            case 2: {
                msg.append("[INFO] ");
                break;
            }
            case 4: {
                msg.append("[DEBUG] ");
                break;
            }
        }
        msg.append(this.dateFormat.format(new Date()));
        msg.append(SEPARATOR_PIPE);
        msg.append(this.getCallerInfo());
        msg.append(logMessage);
        return msg;
    }

    public CharSequence makeTestLog(String testStep, String message) {
        StringBuilder msg = new StringBuilder();
        msg.append("<testcase step=\"");
        msg.append(testStep);
        msg.append("\" ");
        msg.append(message);
        msg.append("/>\n");
        return msg;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public static enum testState {
        START,
        END;

    }
}

