/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CStructure;

public class CCompositeTypeScope
extends CScope
implements ICCompositeTypeScope {
    public CCompositeTypeScope(ICASTCompositeTypeSpecifier compTypeSpec) {
        super(compTypeSpec, EScopeKind.eClassType);
    }

    public IBinding getBinding(char[] name) {
        return super.getBinding(1, name);
    }

    public IBinding[] find(String name) {
        CScope.CollectNamesAction action = new CScope.CollectNamesAction(name.toCharArray());
        this.getPhysicalNode().accept(action);
        IASTName[] names = action.getNames();
        Object[] result = null;
        IASTName[] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName astName = iASTNameArray[n2];
            IBinding b = astName.resolveBinding();
            if (b != null) {
                try {
                    if (b.getScope() == this) {
                        result = (IBinding[])ArrayUtil.append(IBinding.class, result, b);
                    }
                }
                catch (DOMException dOMException) {}
            }
            ++n2;
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public ICompositeType getCompositeType() {
        ICASTCompositeTypeSpecifier compSpec = (ICASTCompositeTypeSpecifier)this.getPhysicalNode();
        IBinding binding = compSpec.getName().resolveBinding();
        if (binding instanceof ICompositeType) {
            return (ICompositeType)binding;
        }
        return new CStructure.CStructureProblem((IASTNode)compSpec.getName(), 16, compSpec.getName().toCharArray());
    }

    protected void doPopulateCache() {
        ICASTCompositeTypeSpecifier compSpec = (ICASTCompositeTypeSpecifier)this.getPhysicalNode();
        Object[] specStack = null;
        int stackIdx = -1;
        IASTDeclaration[] members = compSpec.getMembers();
        while (members != null) {
            int size = members.length;
            int i = 0;
            while (i < size) {
                IASTDeclaration node = members[i];
                if (node instanceof IASTSimpleDeclaration) {
                    IASTCompositeTypeSpecifier declSpec;
                    IASTName n;
                    IASTDeclarator[] declarators;
                    IASTDeclarator[] iASTDeclaratorArray = declarators = ((IASTSimpleDeclaration)node).getDeclarators();
                    int n2 = declarators.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IASTDeclarator declarator = iASTDeclaratorArray[n3];
                        IASTName dtorName = ASTQueries.findInnermostDeclarator(declarator).getName();
                        ASTInternal.addName(this, dtorName);
                        ++n3;
                    }
                    if (declarators.length == 0 && ((IASTSimpleDeclaration)node).getDeclSpecifier() instanceof IASTCompositeTypeSpecifier && (n = (declSpec = (IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)node).getDeclSpecifier()).getName()).toCharArray().length == 0) {
                        specStack = (ICASTCompositeTypeSpecifier[])ArrayUtil.append(ICASTCompositeTypeSpecifier.class, specStack, declSpec);
                    }
                }
                ++i;
            }
            members = specStack != null && ++stackIdx < specStack.length && specStack[stackIdx] != null ? specStack[stackIdx].getMembers() : (IASTDeclaration[])null;
        }
    }
}

