/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.Serializable;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.internal.core.Messages;

public class Addr32
implements IAddress,
Serializable {
    private static final long MAX_ADDR = 0xFFFFFFFFL;
    public static final Addr32 ZERO = new Addr32(0L);
    public static final Addr32 MAX = new Addr32(0xFFFFFFFFL);
    public static final BigInteger MAX_OFFSET = BigInteger.valueOf(0xFFFFFFFFL);
    private static final int BYTES_NUM = 4;
    private static final int DIGITS_NUM = 8;
    private static final int CHARS_NUM = 10;
    private static final int BINARY_DIGITS_NUM = 32;
    private static final int BINARY_CHARS_NUM = 34;
    private final long address;

    public Addr32(byte[] addrBytes) {
        if (addrBytes.length != 4) {
            throw new NumberFormatException("Invalid address array");
        }
        this.address = ((long)addrBytes[0] << 24 & 0xFF000000L) + ((long)addrBytes[1] << 16 & 0xFF0000L) + ((long)addrBytes[2] << 8 & 0xFF00L) + ((long)addrBytes[3] & 0xFFL);
    }

    public Addr32(long rawaddress) {
        this(rawaddress, true);
    }

    public Addr32(long rawaddress, boolean truncate) {
        if (rawaddress > 0xFFFFFFFFL || rawaddress < 0L) {
            if (truncate) {
                rawaddress &= 0xFFFFFFFFL;
            } else {
                throw new NumberFormatException(Messages.Addr_valueOutOfRange);
            }
        }
        this.address = rawaddress;
    }

    public Addr32(String addr) {
        this(addr, true);
    }

    public Addr32(String addr, boolean truncate) {
        this(Long.decode(addr), truncate);
    }

    public Addr32(String addr, int radix) {
        this(addr, radix, true);
    }

    public Addr32(String addr, int radix, boolean truncate) {
        this(Long.parseLong(addr, radix), truncate);
    }

    public IAddress add(BigInteger offset) {
        return new Addr32(this.address + offset.longValue());
    }

    public IAddress add(long offset) {
        return new Addr32(this.address + offset);
    }

    public BigInteger getMaxOffset() {
        return MAX_OFFSET;
    }

    public BigInteger getValue() {
        return BigInteger.valueOf(this.address);
    }

    public BigInteger distanceTo(IAddress other) {
        return other.getValue().subtract(this.getValue());
    }

    public int compareTo(Object other) {
        if (!(other instanceof IAddress)) {
            throw new IllegalArgumentException();
        }
        return this.getValue().compareTo(((IAddress)other).getValue());
    }

    public boolean isMax() {
        return this.address == Addr32.MAX.address;
    }

    public boolean isZero() {
        return this.address == Addr32.ZERO.address;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return Long.toString(this.address, radix);
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof IAddress)) {
            return false;
        }
        return this.getValue().equals(((IAddress)x).getValue());
    }

    public int hashCode() {
        return (int)(this.address ^ this.address >> 32);
    }

    public String toHexAddressString() {
        String addressString = Long.toString(this.address, 16);
        StringBuffer sb = new StringBuffer(10);
        int count = 8 - addressString.length();
        sb.append("0x");
        int i = 0;
        while (i < count) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public String toBinaryAddressString() {
        String addressString = Long.toString(this.address, 2);
        StringBuffer sb = new StringBuffer(34);
        int count = 32 - addressString.length();
        sb.append("0b");
        int i = 0;
        while (i < count) {
            sb.append('0');
            ++i;
        }
        sb.append(addressString);
        return sb.toString();
    }

    public int getCharsNum() {
        return 10;
    }

    public int getSize() {
        return 4;
    }
}

