/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.envvar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.ICoreEnvironmentVariableSupplier;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class EnvVarCollector {
    private Map<String, EnvVarDescriptor> fMap = null;

    public void add(IEnvironmentVariable[] vars) {
        this.add(vars, null, -1, null);
    }

    public void add(IEnvironmentVariable[] vars, IEnvironmentContextInfo info, int num, ICoreEnvironmentVariableSupplier supplier) {
        if (vars == null) {
            return;
        }
        boolean isCaseInsensitive = !EnvironmentVariableManager.getDefault().isVariableCaseSensitive();
        int i = 0;
        while (i < vars.length) {
            IEnvironmentVariable var = vars[i];
            String name = var.getName();
            if (isCaseInsensitive) {
                name = name.toUpperCase();
            }
            boolean noCheck = false;
            if (this.fMap == null) {
                noCheck = true;
                this.fMap = new HashMap<String, EnvVarDescriptor>();
            }
            EnvVarDescriptor des = null;
            if (noCheck || (des = this.fMap.get(name)) == null) {
                des = new EnvVarDescriptor(var, info, num, supplier);
                this.fMap.put(name, des);
            } else {
                des.setContextInfo(info);
                des.setSupplierNum(num);
                des.setVariable(EnvVarOperationProcessor.performOperation(des.getOriginalVariable(), var));
            }
            ++i;
        }
    }

    public EnvVarDescriptor[] toArray(boolean includeRemoved) {
        if (this.fMap == null) {
            return new EnvVarDescriptor[0];
        }
        Collection<EnvVarDescriptor> values = this.fMap.values();
        ArrayList<EnvVarDescriptor> list = new ArrayList<EnvVarDescriptor>();
        for (EnvVarDescriptor des : values) {
            if (des == null || !includeRemoved && des.getOperation() == 2) continue;
            list.add(des);
        }
        return list.toArray(new EnvVarDescriptor[list.size()]);
    }

    public EnvVarDescriptor getVariable(String name) {
        if (this.fMap == null) {
            return null;
        }
        if (!EnvironmentVariableManager.getDefault().isVariableCaseSensitive()) {
            name = name.toUpperCase();
        }
        return this.fMap.get(name);
    }

    public EnvVarDescriptor[] getVariables() {
        return this.toArray(true);
    }

    public void clear() {
        if (this.fMap != null) {
            this.fMap.clear();
        }
    }
}

