/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDOMCPPEnumScope
implements ICPPScope,
IIndexScope {
    private final IPDOMCPPEnumType fBinding;

    public PDOMCPPEnumScope(IPDOMCPPEnumType binding) {
        this.fBinding = binding;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eEnumeration;
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, null);
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
        return this.getBindings(name, resolve, prefixLookup, null);
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        try {
            CharArrayMap<PDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(this.fBinding);
            return map.get(name.toCharArray());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        try {
            CharArrayMap<PDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(this.fBinding);
            if (prefixLookup) {
                ArrayList<IBinding> result = new ArrayList<IBinding>();
                char[] nc = name.toCharArray();
                IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(nc);
                for (char[] key : map.keys()) {
                    if (!matcher.match(key)) continue;
                    result.add(map.get(key));
                }
                return result.toArray(new IBinding[result.size()]);
            }
            IBinding b = map.get(name.toCharArray());
            if (b != null) {
                return new IBinding[]{b};
            }
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this.fBinding;
    }

    @Override
    public IIndexScope getParent() {
        return this.fBinding.getScope();
    }

    @Override
    public IIndexName getScopeName() {
        return this.fBinding.getScopeName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PDOMCPPEnumScope) {
            return this.fBinding.equals(((PDOMCPPEnumScope)obj).fBinding);
        }
        return false;
    }

    public int hashCode() {
        return this.fBinding.hashCode();
    }

    private static CharArrayMap<PDOMCPPEnumerator> getBindingMap(IPDOMCPPEnumType enumeration) throws CoreException {
        CharArrayMap<PDOMCPPEnumerator> map;
        Long key = enumeration.getRecord() + 0L;
        PDOM pdom = enumeration.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayMap<PDOMCPPEnumerator> charArrayMap = map = cached == null ? null : (CharArrayMap<PDOMCPPEnumerator>)cached.get();
        if (map == null) {
            map = new CharArrayMap<PDOMCPPEnumerator>();
            enumeration.loadEnumerators(map);
            pdom.putCachedResult(key, new SoftReference<CharArrayMap<PDOMCPPEnumerator>>(map));
        }
        return map;
    }

    public static void updateCache(PDOMCPPEnumeration enumType, PDOMCPPEnumerator enumItem) {
        CharArrayMap map;
        Long key = enumType.getRecord() + 0L;
        PDOM pdom = enumType.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        CharArrayMap charArrayMap = map = cached == null ? null : (CharArrayMap)cached.get();
        if (map != null) {
            map.put(enumType.getNameCharArray(), enumItem);
        }
    }

    public static IEnumerator[] getEnumerators(PDOMCPPEnumeration enumType) {
        try {
            CharArrayMap<PDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(enumType);
            ArrayList<IEnumerator> result = new ArrayList<IEnumerator>();
            for (IEnumerator iEnumerator : map.values()) {
                if (!IndexFilter.ALL_DECLARED.acceptBinding(iEnumerator)) continue;
                result.add(iEnumerator);
            }
            Collections.reverse(result);
            return result.toArray(new IEnumerator[result.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    public static void acceptViaCache(PDOMCPPEnumeration enumType, IPDOMVisitor visitor) {
        try {
            CharArrayMap<PDOMCPPEnumerator> map = PDOMCPPEnumScope.getBindingMap(enumType);
            for (PDOMCPPEnumerator enumItem : map.values()) {
                visitor.visit(enumItem);
                visitor.leave(enumItem);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

