/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableToggleRenderer;
import org.tizen.sdblib.service.FileEntry;

public class DAFileTreeExplorerToggleRenderer
extends DATableToggleRenderer {
    @Override
    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        Font font = item.getFont(0);
        if (font == null) {
            gc.setFont(FontResources.TABLE_CELL_FONT);
        } else {
            gc.setFont(font);
        }
        String text = item.getText();
        FileEntry entry = (FileEntry)item.getData();
        Image icon = this.getIcon(entry);
        if (this.hasChildren(entry)) {
            if (this.isExpanded()) {
                Rectangle r = ImageResources.TREE_OPEN.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_OPEN, x, this.getBounds().y);
                r = icon.getBounds();
                gc.drawImage(icon, x += r.width + 5, this.getBounds().y);
                x += r.width + 1;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
                }
                gc.drawText(text, x, this.getBounds().y + 2, true);
            } else {
                Rectangle r = ImageResources.TREE_FOLD.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_FOLD, this.getBounds().x + offset, this.getBounds().y);
                r = icon.getBounds();
                gc.drawImage(icon, x += r.width + 5, this.getBounds().y);
                x += r.width + 1;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
                }
                gc.drawText(text, x, this.getBounds().y + 2, true);
            }
        } else {
            Rectangle r = ImageResources.TREE_OPEN.getBounds();
            int offset = (this.getBounds().width - r.width) / 2;
            int x = this.getBounds().x + offset;
            r = icon.getBounds();
            gc.drawImage(icon, x += r.width + 5, this.getBounds().y);
            x += r.width + 1;
            if (this.isSelected()) {
                gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
            } else {
                gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            }
            gc.drawText(text, x, this.getBounds().y, true);
        }
    }

    private Image getIcon(FileEntry entry) {
        switch (entry.getType()) {
            case File: {
                return ImageResources.ICON_FILE;
            }
            case Link: {
                return ImageResources.ICON_FILE_LINK;
            }
            case Directory: {
                return ImageResources.ICON_DIR;
            }
            case DirectoryLink: {
                return ImageResources.ICON_DIR_LINK;
            }
            case RootEmulator: {
                return ImageResources.ICON_EMULATOR;
            }
            case RootDevice: {
                return ImageResources.ICON_DEVICE;
            }
        }
        return ImageResources.ICON_OTHER;
    }

    private boolean hasChildren(FileEntry entry) {
        if (entry != null && entry.getChildren().length > 0) {
            switch (entry.getType()) {
                case File: {
                    return false;
                }
                case Link: {
                    return false;
                }
                case Directory: {
                    return true;
                }
                case DirectoryLink: {
                    return false;
                }
                case RootEmulator: {
                    return true;
                }
                case RootDevice: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

