/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDataManager;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class AppStartupView
extends DAViewComposite {
    private String[] observingViews = null;
    Composite contents = null;
    private StackLayout stackLayout;
    private AppStartupTable nativeTable = null;
    private WebAppStartupTable webTable = null;

    public AppStartupView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.APP_STARTUP_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.nativeTable = new AppStartupTable(this.contents, 0, 2818);
        this.webTable = new WebAppStartupTable(this.contents, 0, 2818);
        Project currentProject = Global.getProject();
        if (currentProject == null) {
            this.stackLayout.topControl = this.nativeTable;
        } else {
            this.changeTable(currentProject.isWebApplication());
        }
        DataManagerRegistry.registerPageDataManager(AppStartupDataManager.getInstance());
    }

    public void setObservingViews(String[] viewIDs) {
        this.observingViews = viewIDs;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }

    public void changeTable(boolean isWeb) {
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.contents.layout();
    }

    public void updateView() {
        ((DATableComposite)this.stackLayout.topControl).updateTable();
    }

    public void updateView(DAViewData data) {
        ((DATableComposite)this.stackLayout.topControl).deselectAll();
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            if (this.stackLayout.topControl == this.nativeTable) {
                this.nativeTable.setSelectionByTime(start, end);
            } else {
                this.webTable.setSelectionByTime(start, end);
            }
            this.updateView();
        }
    }

    public void clear() {
        this.nativeTable.clear();
        this.webTable.clear();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }
}

