/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.data;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.InteractivePageLabels;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;

public class InteractiveUIData
implements Comparable {
    private static final long UNSET_SEQ = -1L;
    private long tableRowID;
    private long seq = -1L;
    private long time;
    private String type;
    private String name;
    private Object value;
    private boolean array = false;
    private int checkLocation;
    private InteractiveInfo interactiveInfo;
    private List<InteractiveUIData> children;

    public InteractiveUIData(InteractiveInfo interactiveInfo, int checkLocation) {
        this.interactiveInfo = interactiveInfo;
        this.type = interactiveInfo.getTypeNameWithPointer();
        this.name = interactiveInfo.getVariableName();
        this.checkLocation = checkLocation;
    }

    public long getTableRowID() {
        return this.tableRowID;
    }

    public void setTableRowID(long tableRowID) {
        this.tableRowID = tableRowID;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public String getType() {
        if (this.array) {
            this.type = String.valueOf(this.type) + " [" + this.children.size() + "]";
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        if (this.array || this.children != null) {
            return this.getComplexValue();
        }
        if (this.value == null) {
            return "This variable type is not supported.";
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<InteractiveUIData> getChildren() {
        return this.children;
    }

    public void setChildren(List<InteractiveUIData> children) {
        this.children = children;
    }

    public InteractiveInfo getVariableInfo() {
        return this.interactiveInfo;
    }

    public int getCheckLocation() {
        return this.checkLocation;
    }

    private String getComplexValue() {
        String complexValue = "[";
        int i = 0;
        while (i < this.children.size()) {
            InteractiveUIData child = this.children.get(i);
            complexValue = child == null ? String.valueOf(complexValue) + InteractivePageLabels.INTERACTIVE_CHART_INVALID_CHECK_LOCATION : (child.isArray() || child.getChildren() != null ? String.valueOf(complexValue) + child.getComplexValue() : String.valueOf(complexValue) + child.getValue());
            if (i != this.children.size() - 1) {
                complexValue = String.valueOf(complexValue) + ", ";
            }
            ++i;
        }
        return String.valueOf(complexValue) + "]";
    }

    public String getChartTooltipString() {
        if (this.array || this.children != null) {
            return this.getComplexValue();
        }
        return String.valueOf(this.getType()) + " " + this.name + " : " + this.getValue();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof InteractiveUIData) {
            return (int)(this.time - ((InteractiveUIData)arg0).time);
        }
        return 0;
    }
}

