/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class ContextSwitchingChartRenderer
extends DAChartRenderer {
    private static final int ARC = 6;
    protected Rectangle rect;

    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            this.drawChartSeries(gc, (DAChartSeries)this.seriesList.get(i), i);
            ++i;
        }
        i = 0;
        while (i < this.seriesList.size()) {
            this.drawChartSeriesArrow(gc, (DAChartSeries)this.seriesList.get(i), i);
            ++i;
        }
        this.drawAxis(gc);
    }

    protected void drawChartSeries(GC gc, DAChartSeries series, int seriesIndex) {
        List seriesItems;
        int seriesSize = this.seriesList.size();
        this.rect = new Rectangle(this.r.x, this.r.y + this.r.height * seriesIndex / seriesSize, this.r.width, this.r.height / seriesSize);
        if (seriesIndex != 0) {
            gc.setForeground(ColorResources.CHART_SEPERATE_LINE);
            gc.drawLine(this.rect.x, this.r.height * seriesIndex / seriesSize, this.rect.width, this.r.height * seriesIndex / seriesSize);
        }
        if ((seriesItems = series.getSeriesItemList()) == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        Color seriesColor = series.getColor();
        gc.setForeground(seriesColor);
        gc.setLineStyle(1);
        gc.setAntialias(1);
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int i = index;
        while (i < seriesItemSize) {
            if (!this.drawChartSeriesItem(gc, (ContextSwitchingChartSeriesItem)((Object)seriesItems.get(i)), seriesColor)) break;
            ++i;
        }
    }

    private boolean drawChartSeriesItem(GC gc, ContextSwitchingChartSeriesItem seriesItem, Color seriesColor) {
        int extentX;
        String name;
        double x = seriesItem.getX();
        if (x > this.plot.getVisibleEndX()) {
            return false;
        }
        double endX = seriesItem.getEndX();
        if (endX == -1.0) {
            endX = this.plot.getValidEndX();
        }
        int pixelX = this.plot.getXPixelFromX(x, this.r);
        int pixelEndX = this.plot.getXPixelFromX(endX, this.r);
        gc.setBackground(seriesColor);
        if (seriesItem.getColor() != null) {
            gc.setBackground(seriesItem.getColor());
        }
        Color boarderColor = seriesItem.getBorderColor();
        int leftX = pixelX + 6;
        int rightX = pixelEndX - 6;
        int upperY = this.rect.y + (int)Math.round((double)this.rect.height * 0.1);
        int underY = this.rect.y + (int)Math.round((double)this.rect.height * 0.9);
        switch (seriesItem.getStyle()) {
            case 1: {
                int gap;
                if (leftX > rightX) {
                    gap = leftX - rightX;
                    leftX -= gap / 2;
                    rightX += gap / 2;
                }
                int[] points = new int[]{leftX, upperY, pixelX, upperY + 6, pixelX, underY - 6, leftX, underY, rightX, underY, pixelEndX, underY - 6, pixelEndX, upperY + 6, rightX, upperY};
                gc.fillPolygon(points);
                if (boarderColor == null) break;
                gc.setForeground(boarderColor);
                gc.drawPolygon(points);
                break;
            }
            case 2: {
                int gap;
                if (leftX > pixelEndX) {
                    gap = leftX - pixelEndX;
                    leftX -= gap;
                }
                int[] points = new int[]{leftX, upperY, pixelX, upperY + 6, pixelX, underY - 6, leftX, underY, pixelEndX, underY, pixelEndX, upperY};
                gc.fillPolygon(points);
                if (boarderColor == null) break;
                gc.setForeground(boarderColor);
                gc.drawPolygon(points);
                break;
            }
            case 3: {
                int gap;
                if (rightX < pixelX) {
                    gap = pixelX - rightX;
                    rightX += gap;
                }
                int[] points = new int[]{pixelX, upperY, pixelX, underY, rightX, underY, pixelEndX, underY - 6, pixelEndX, upperY + 6, rightX, upperY};
                gc.fillPolygon(points);
                if (boarderColor == null) break;
                gc.setForeground(boarderColor);
                gc.drawPolygon(points);
                break;
            }
            default: {
                gc.fillRectangle(pixelX, this.rect.y + (int)((double)this.rect.height * 0.1), pixelEndX - pixelX, (int)((double)this.rect.height * 0.8));
                if (boarderColor == null) break;
                gc.setForeground(boarderColor);
                gc.drawRectangle(pixelX, this.rect.y + (int)((double)this.rect.height * 0.1), pixelEndX - pixelX, (int)((double)this.rect.height * 0.8));
            }
        }
        if ((name = seriesItem.getName()) != null && (extentX = gc.stringExtent((String)name).x) < pixelEndX - pixelX) {
            gc.setForeground(ColorResources.BLACK);
            gc.drawText(name, (pixelEndX + pixelX) / 2 - extentX / 2, this.rect.y + this.rect.height / 2 - gc.stringExtent((String)name).y / 2, true);
        }
        return true;
    }

    protected void drawChartSeriesArrow(GC gc, DAChartSeries series, int seriesIndex) {
        int seriesSize = this.seriesList.size();
        this.rect = new Rectangle(this.r.x, this.r.y + this.r.height * seriesIndex / seriesSize, this.r.width, this.r.height / seriesSize);
        List seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int i = index;
        while (i < seriesItemSize) {
            ContextSwitchingChartSeriesItem seriesItem = (ContextSwitchingChartSeriesItem)((Object)seriesItems.get(i));
            double x = seriesItem.getX();
            if (x > this.plot.getVisibleEndX()) {
                return;
            }
            int pixelEndX = this.plot.getXPixelFromX(seriesItem.getEndX(), this.r);
            int arrow = seriesItem.getArrow();
            if (arrow != 0) {
                if (seriesItem.getBorderColor() != null) {
                    gc.setForeground(seriesItem.getBorderColor());
                }
                int arrowHeadY = this.rect.y + this.rect.height / 2 + this.rect.height * arrow;
                gc.drawLine(pixelEndX, this.rect.y + this.rect.height / 2, pixelEndX, arrowHeadY);
                int y = -5;
                if (arrow < 0) {
                    y = 5;
                }
                gc.drawLine(pixelEndX, arrowHeadY, pixelEndX - 3, arrowHeadY + y);
                gc.drawLine(pixelEndX, arrowHeadY, pixelEndX + 3, arrowHeadY + y);
            }
            ++i;
        }
    }
}

