/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.GLPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChart;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLChartDBType;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class GLFrameRateChart
extends GLChart {
    private static GLFrameRateChart instance = null;
    private static final String FRAMES = GLPageLabels.GL_FRAME;
    private DAChartSeries frameRateSeries = null;

    public static GLFrameRateChart getInstance() {
        if (instance == null) {
            instance = new GLFrameRateChart();
        }
        return instance;
    }

    private GLFrameRateChart() {
        this.chartName = GLPageLabels.GL_CHART_TITLE_FRAME_RATE;
        this.chartIcon = ImageResources.FEATURE_FRAMERATE_SMALL_NOR;
        this.frameRateSeries = new DAChartSeries(this.chartName, 2, ColorResources.SERIES_COLOR_CPU_APP);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard, boolean enablePopupMenu) {
        DAChartBoardItem item = super.createBoardItem(chartBoard, enablePopupMenu);
        this.chart.addSeries(this.frameRateSeries);
        this.chart.getPlot().setSeriesHeightRange(true);
        this.chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.AUTO);
        this.chart.getPlot().setAxisUnit(FRAMES);
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.DECIMAL);
        this.chart.getPlot().setShowAxis(true);
        return item;
    }

    public void updateView(double startIndex, double endIndex) {
        this.frameRateSeries.getSeriesItemList().clear();
        List<GLChartDBType> chartDataList = GLDataManager.getInstance().getFrameRateDBTableManager().selectFrameRate(startIndex, endIndex);
        if (chartDataList == null) {
            return;
        }
        this.checkStartFrameRateTime(startIndex, chartDataList);
        int i = 0;
        while (i < chartDataList.size()) {
            GLChartDBType chartData = chartDataList.get(i);
            this.addData(chartData.getChartTime(), chartData.getFrameIndex(), chartData.getFrameCount(), chartData.isErrno());
            ++i;
        }
    }

    private void checkStartFrameRateTime(double startIndex, List<GLChartDBType> chartDataList) {
        if (startIndex != 0.0 || chartDataList.size() == 0) {
            return;
        }
        int frameRateStartTime = chartDataList.get(0).getChartTime();
        if (GLDataManager.getInstance().getStartFrameRateTime() < frameRateStartTime) {
            GLDataManager.getInstance().setStartFrameRateTime(frameRateStartTime);
        }
    }

    @Override
    public void parseLogPackage(LogPackage logPack) {
    }

    public void addData(int frameNumber, int startFrameIndex, int frameCount, boolean drawError) {
        String tooltipMessage = String.valueOf(frameCount) + " fps";
        if (drawError) {
            this.frameRateSeries.addSeriesItem(new DAChartSeriesItem((double)frameNumber, (double)frameCount, ColorResources.RED, tooltipMessage, false));
        } else {
            this.frameRateSeries.addSeriesItem(new DAChartSeriesItem((double)frameNumber, (double)frameCount, tooltipMessage, false));
        }
    }
}

