/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.leaks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.leaks.CurrentLeakData;
import org.tizen.dynamicanalyzer.util.Logger;

public class NewLeakDetector {
    Map<Integer, CurrentLeakData> leakHash;
    private int leakSeq = 0;

    public List<CurrentLeakData> getLeakDataList() {
        ArrayList<CurrentLeakData> leakList = new ArrayList<CurrentLeakData>();
        leakList.addAll(this.getLeakHash().values());
        return leakList;
    }

    public Map<Integer, CurrentLeakData> getLeakHash() {
        if (this.leakHash == null) {
            this.leakHash = new ConcurrentHashMap<Integer, CurrentLeakData>();
        }
        return this.leakHash;
    }

    private boolean isDropLog(LogData logData) {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTarget();
        ProbeCommonData pData = (ProbeCommonData)logData;
        if (!pData.isInternal()) {
            return false;
        }
        return !target.isSelectedFeature(Feature.INTERNAL_PROBE_MEMORY);
    }

    public int runLeakDetect(LogData logData) {
        ProbeCommonData log = (ProbeCommonData)logData;
        int result = -1;
        if (this.isDropLog(logData)) {
            return result;
        }
        Map<Integer, CurrentLeakData> leaks = this.getLeakHash();
        if (logData instanceof MemoryData) {
            int key;
            MemoryData mlog = (MemoryData)logData;
            if (mlog.getMemoryApiType() == 0) {
                if (mlog.getReturn().equalsIgnoreCase(String.valueOf("0x0"))) {
                    return result;
                }
                if (log.getApiName().contains("realloc")) {
                    String inputParam = log.getArgs();
                    String[] splitInputParam = inputParam.split("\\,");
                    String param = String.valueOf(splitInputParam[0]);
                    long allocatedAddr = -1L;
                    try {
                        allocatedAddr = param.contains("0x") ? Long.decode(param) : Long.parseLong(splitInputParam[0]);
                        int rmKey = this.findAllocatedKey(leaks, allocatedAddr, log.getPid());
                        if (rmKey != -1) {
                            leaks.remove(rmKey);
                        }
                    }
                    catch (NumberFormatException e) {
                        Logger.exception((Throwable)e);
                    }
                }
                this.addCurrentLeakData(leaks, logData);
            } else if (mlog.getMemoryApiType() == 1 && (key = this.findAllocatedKey(leaks, mlog.getAddress(), log.getPid())) != -1) {
                leaks.remove(key);
            }
            result = mlog.getMemoryApiType();
        }
        return result;
    }

    private void addCurrentLeakData(Map<Integer, CurrentLeakData> leaks, LogData log) {
        CurrentLeakData newLeak = new CurrentLeakData(log);
        ((ConcurrentHashMap)leaks).put(log.getKey(), newLeak);
        ++this.leakSeq;
    }

    public void addCurrentLeakData(CurrentLeakData leakData) {
        Long key = leakData.getSequenceNumber();
        this.getLeakHash().put(key.hashCode(), leakData);
        ++this.leakSeq;
    }

    private int findAllocatedKey(Map<Integer, CurrentLeakData> leaks, long addr, int pid) {
        for (Integer key : leaks.keySet()) {
            CurrentLeakData iLeakData = leaks.get(key);
            if (iLeakData.getAllocatedValue() != addr || iLeakData.getPid() != pid) continue;
            return key;
        }
        return -1;
    }

    public int getLeakSeq() {
        return this.leakSeq;
    }

    public void clear() {
        this.getLeakHash().clear();
        this.leakSeq = 0;
    }
}

