/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.callstack.BaseCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackItem;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public abstract class ProfileDataMaker {
    private Map<Integer, CallstackTree> callstackTreeByTidMap = new HashMap<Integer, CallstackTree>();
    protected int totalSampleCount = 0;
    protected BaseCallstackManager callstackManager = null;
    private int pid = 0;
    private Map<Integer, ProfilingData> profilingDataMap = null;
    private Map<String, String> symbolIDHash = null;
    private Map<String, ProfilingChildData> childListMap = null;
    private ProfilingData appBin = null;
    private ProfilingData dependentLib = null;
    private String appBinName = null;

    public ProfileDataMaker(BaseCallstackManager callstackManager) {
        this.callstackManager = callstackManager;
    }

    public void clear() {
        this.getProfilingDataMap().clear();
        this.getChildListMap().clear();
        this.appBin = null;
        this.dependentLib = null;
        this.appBinName = null;
        this.totalSampleCount = 0;
        this.getSymbolIDHash().clear();
        this.callstackTreeByTidMap.clear();
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getAppBinName() {
        return this.appBinName;
    }

    public ProfilingData getAppBin() {
        return this.appBin;
    }

    public ProfilingData getDependentLib() {
        return this.dependentLib;
    }

    public void setAppBin(ProfilingData appBin) {
        this.appBin = appBin;
    }

    public void setDependentLib(ProfilingData dependentLib) {
        this.dependentLib = dependentLib;
    }

    public void setTotalSampleCount(int count) {
        this.totalSampleCount = count;
    }

    public int getTotalSampleCount() {
        return this.totalSampleCount;
    }

    public ProfilingData getProfilingDataByKey(String key) {
        Map<String, String> hash = this.getSymbolIDHash();
        String profilingDataID = hash.get(key);
        if (profilingDataID != null) {
            return this.getProfilingDataMap().get(Integer.parseInt(profilingDataID));
        }
        return null;
    }

    public Map<Integer, ProfilingData> getProfilingDataMap() {
        if (this.profilingDataMap == null) {
            this.profilingDataMap = new ConcurrentHashMap<Integer, ProfilingData>();
        }
        return this.profilingDataMap;
    }

    public Map<String, ProfilingChildData> getChildListMap() {
        if (this.childListMap == null) {
            this.childListMap = new ConcurrentHashMap<String, ProfilingChildData>();
        }
        return this.childListMap;
    }

    public Map<String, String> getSymbolIDHash() {
        if (this.symbolIDHash == null) {
            this.symbolIDHash = new ConcurrentHashMap<String, String>();
        }
        return this.symbolIDHash;
    }

    public CallstackTree getCurrentCallstackTree(int tid) {
        CallstackTree current = this.callstackTreeByTidMap.get(tid);
        return current;
    }

    public void putCurrentCallstackTree(int tid, CallstackTree current) {
        this.callstackTreeByTidMap.put(tid, current);
    }

    public String getCpuRate(ProfilingData data, boolean exclusive) {
        int count = 0;
        double rate = 0.0;
        if (exclusive) {
            count = data.getExCount();
            rate = this.totalSampleCount == 0 ? 0.0 : (double)count / (double)this.totalSampleCount * 100.0;
        } else {
            count = data.getInCount();
            rate = this.totalSampleCount == 0 ? 0.0 : (double)count / (double)this.totalSampleCount * 100.0;
        }
        return Formatter.toDoubleFormat2(Double.toString(rate));
    }

    public String getCpuTime(ProfilingData data, boolean exclusive) {
        int count = 0;
        count = exclusive ? data.getExCount() : data.getInCount();
        return Long.toString((long)count * FunctionUsageProfiler.SAMPLE_TIME);
    }

    protected void checkUserCall(CallStackUnit csa, ProfilingData parent, ProfilingData pp, LogData log) {
        AppInfo appInfo = Global.getProject().getApplicationInfo();
        BinaryInfo binfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(appInfo.getExecBinaryPath());
        if (binfo.getTargetBinaryPath().equals(csa.getPath())) {
            if (this.appBin == null) {
                CallStackUnit appBinCsa = new CallStackUnit(-1L, FunctionUsageProfiler.APPLICATION, log);
                this.appBin = this.makeNewProfilingData(appBinCsa, true);
                this.appBin.setKey("profiling_app_bin_key");
                this.appBinName = csa.getPath();
            }
            parent.setParent(this.appBin.getName());
            this.appBin.addChild(parent);
            if (pp != null) {
                pp = this.appBin;
            }
        } else {
            if (this.dependentLib == null) {
                CallStackUnit dependentLibBinCsa = new CallStackUnit(-2L, FunctionUsageProfiler.DEPENDENT_LIB, log);
                this.dependentLib = this.makeNewProfilingData(dependentLibBinCsa, true);
                this.dependentLib.setKey("profiling_dependent_lib_key");
            }
            parent.setParent(this.dependentLib.getName());
            this.dependentLib.addChild(parent);
            if (pp != null) {
                pp = this.dependentLib;
            }
        }
    }

    public abstract void makeFunctionUsageProfileData(ProfileData var1);

    protected ProfilingData makeNewProfilingData(CallStackUnit inputData, boolean isParent) {
        ProfilingData newProfilingData = new ProfilingData(inputData, isParent, this);
        this.getProfilingDataMap().put(newProfilingData.getProfilingDataID(), newProfilingData);
        if (isParent) {
            this.getSymbolIDHash().put(inputData.getPath(), Integer.toString(newProfilingData.getProfilingDataID()));
        } else {
            this.getSymbolIDHash().put(inputData.getSymbol(), Integer.toString(newProfilingData.getProfilingDataID()));
        }
        return newProfilingData;
    }

    public void makeFupDataForCallTrace(CallStackUnit inputCallstackApiData, ProfileData log) {
        ProfilingData parent;
        long exeTime = 0L;
        int type = log.getMsgID();
        int tid = log.getTid();
        long time = log.getTime();
        List<CallStackItem> userCallstack = this.callstackManager.getUserCallstack(tid);
        int size = userCallstack.size();
        if (type == 9) {
            if (size == 0 || userCallstack.get(size - 1).getCallStackUnit().getFunctionId() != inputCallstackApiData.getFunctionId()) {
                Logger.debug((Object)("exit without entry or EXIT self is not the same as top of user callstack :" + inputCallstackApiData.getFunctionName()));
                return;
            }
            long startTime = userCallstack.get(size - 1).getStartTime();
            if (startTime != -1L) {
                exeTime += time - startTime;
            }
        }
        if ((parent = this.getProfilingDataByKey(inputCallstackApiData.getPath())) == null) {
            parent = this.makeNewProfilingData(inputCallstackApiData, true);
            this.checkUserCall(inputCallstackApiData, parent, null, log);
            ProfilingData child = this.makeNewProfilingData(inputCallstackApiData, false);
            parent.addChild(child);
            child.addElapsedTime(exeTime);
            child.setParent(parent.getName());
            if (type != 9) {
                child.addCallCount();
            }
        } else {
            ProfilingData child = this.getProfilingDataByKey(inputCallstackApiData.getSymbol());
            if (child == null) {
                child = this.makeNewProfilingData(inputCallstackApiData, false);
                parent.addChild(child);
                child.setParent(parent.getName());
            }
            child.addElapsedTime(exeTime);
            if (type != 9) {
                child.addCallCount();
            }
            CallstackTree current = this.getCurrentCallstackTree(tid);
            if (type == 9) {
                if (current == null) {
                    Logger.debug((Object)("exit without entry - range only :" + inputCallstackApiData.getFunctionName()));
                } else {
                    CallstackTree parentCt = current.getParent();
                    if (parentCt != null) {
                        parentCt.addChildExeTime(current.getThis().getLastElapsedTime());
                    }
                    child.addExclusiveElapsedTime(current.getExclusiveExeTime());
                    this.putCurrentCallstackTree(tid, current.getParent());
                }
            } else if (current == null) {
                CallstackTree ct = new CallstackTree(child, null);
                this.putCurrentCallstackTree(tid, ct);
            } else {
                CallstackTree ct = new CallstackTree(child, current);
                this.putCurrentCallstackTree(tid, ct);
            }
        }
    }

    static class CallstackTree {
        ProfilingData me;
        CallstackTree parent;
        int childExeTime = 0;

        public CallstackTree(ProfilingData me, CallstackTree parent) {
            this.me = me;
            this.parent = parent;
        }

        public void addChildExeTime(long time) {
            this.childExeTime = (int)((long)this.childExeTime + time);
        }

        public long getExclusiveExeTime() {
            return this.me.getLastElapsedTime() - (long)this.childExeTime;
        }

        public ProfilingData getThis() {
            return this.me;
        }

        public CallstackTree getParent() {
            return this.parent;
        }
    }
}

