/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceManager;
import org.tizen.dynamicanalyzer.widgets.animation.DAAnimationIcon;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;
import org.tizen.dynamicanalyzer.widgets.helper.ImageResources;

public class RemoteDeviceDialog
extends DAMessageBox {
    private final int WIDTH = 430;
    private final int HEIGHT = 190;
    private final int EDITBOX_TOP_MARGIN = 18;
    private final int EDITBOX_INTERVAL = 10;
    private final int WIDGETS_HEIGHT = 24;
    private final int EDITBOX_WIDTH = 284;
    private final int LABEL_TOP_MARGIN = 24;
    private final int LABEL_LEFT_MARGIN = 20;
    private final int LABEL_INTERVAL = 10;
    private final int LABEL_WIDTH = 79;
    private Composite mainContentsComp = null;
    private Composite buttonContentsComp = null;
    private RemoteDeviceDialog self = null;
    private DATextBox ipTextbox = null;
    private DATextBox portTextbox = null;
    private List<Image> progressImage = new ArrayList<Image>();
    private DAAnimationIcon progressIcon = null;
    private Label progressLabel = null;
    private Button connectButton = null;
    private Button cancelButton = null;
    private String address = null;
    private SelectionListener connectButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            String ip = RemoteDeviceDialog.this.ipTextbox.getText();
            String port = RemoteDeviceDialog.this.portTextbox.getText();
            if (ip.isEmpty()) {
                return;
            }
            if (port.isEmpty()) {
                port = String.valueOf(26101);
            }
            RemoteDeviceDialog.this.address = String.valueOf(ip) + ":" + port;
            RemoteDeviceDialog.this.connectButton.setEnabled(false);
            RemoteDeviceDialog.this.connectButton.redraw();
            RemoteDeviceDialog.this.ipTextbox.setEnabled(false);
            RemoteDeviceDialog.this.portTextbox.setEnabled(false);
            RemoteDeviceDialog.this.progressIcon.setVisible(true);
            RemoteDeviceDialog.this.progressLabel.setVisible(true);
            RemoteDeviceDialog.this.progressIcon.start();
            Thread managerThread = new Thread(new RemoteDeviceManager(RemoteDeviceDialog.this.self));
            managerThread.start();
        }
    };
    private SelectionListener cancelButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            RemoteDeviceDialog.this.shell.close();
        }
    };
    private KeyListener ipTextboxListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (!RemoteDeviceDialog.this.checkValidIP(RemoteDeviceDialog.this.ipTextbox.getText())) {
                RemoteDeviceDialog.this.connectButton.setEnabled(false);
            } else {
                RemoteDeviceDialog.this.connectButton.setEnabled(true);
            }
            RemoteDeviceDialog.this.connectButton.redraw();
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private KeyListener portTextboxListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (!RemoteDeviceDialog.this.checkValidPort(RemoteDeviceDialog.this.portTextbox.getText())) {
                RemoteDeviceDialog.this.connectButton.setEnabled(false);
            } else {
                RemoteDeviceDialog.this.connectButton.setEnabled(true);
            }
            RemoteDeviceDialog.this.connectButton.redraw();
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public RemoteDeviceDialog(Shell parentShell) {
        super(parentShell);
        this.self = this;
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 190) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(430, 190);
        this.shell.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        this.shell.setText(AnalyzerLabels.REMOTE_DEVICE);
        Composite marginTop = new Composite((Composite)this.shell, 0);
        this.mainContentsComp = new Composite((Composite)this.shell, 0);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        marginTop.setLayout((Layout)new FormLayout());
        FormData marginCompData = new FormData();
        marginCompData.top = new FormAttachment(0, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(0, 1);
        marginTop.setLayoutData((Object)marginCompData);
        marginTop.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.mainContentsComp.setLayout((Layout)new FormLayout());
        FormData scrollCompData = new FormData();
        scrollCompData.top = new FormAttachment((Control)marginTop, 0);
        scrollCompData.left = new FormAttachment(0, 0);
        scrollCompData.right = new FormAttachment(100, 0);
        scrollCompData.bottom = new FormAttachment(100, -61);
        this.mainContentsComp.setLayoutData((Object)scrollCompData);
        this.mainContentsComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        marginMiddle.setLayout((Layout)new FormLayout());
        marginCompData = new FormData();
        marginCompData.top = new FormAttachment((Control)this.mainContentsComp, 0);
        marginCompData.left = new FormAttachment(0, 0);
        marginCompData.right = new FormAttachment(100, 0);
        marginCompData.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)marginCompData);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.buttonContentsComp.setLayout((Layout)new FormLayout());
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)marginMiddle, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)compData);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        this.drawMainContents();
        this.drawButtons();
        this.drawProgress();
    }

    private void drawMainContents() {
        Label ipText = new Label(this.mainContentsComp, 16384);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 24);
        data.left = new FormAttachment(0, 20);
        data.height = 24;
        data.width = 79;
        ipText.setLayoutData((Object)data);
        ipText.setForeground(ColorResources.BLACK);
        ipText.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        ipText.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        ipText.setText(AnalyzerLabels.IP);
        Label portText = new Label(this.mainContentsComp, 16384);
        data = new FormData();
        data.top = new FormAttachment((Control)ipText, 10);
        data.left = new FormAttachment(0, 20);
        data.height = 24;
        data.width = 79;
        portText.setLayoutData((Object)data);
        portText.setForeground(ColorResources.BLACK);
        portText.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        portText.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        portText.setText(AnalyzerLabels.PORT);
        Label ipcolon = new Label(this.mainContentsComp, 16384);
        data = new FormData();
        data.top = new FormAttachment(0, 24);
        data.left = new FormAttachment((Control)portText, 5);
        data.height = 24;
        data.width = 3;
        ipcolon.setLayoutData((Object)data);
        ipcolon.setForeground(ColorResources.BLACK);
        ipcolon.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        ipcolon.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        ipcolon.setText(":");
        Label portcolon = new Label(this.mainContentsComp, 16384);
        data = new FormData();
        data.top = new FormAttachment((Control)ipText, 10);
        data.left = new FormAttachment((Control)portText, 5);
        data.height = 24;
        data.width = 3;
        portcolon.setLayoutData((Object)data);
        portcolon.setForeground(ColorResources.BLACK);
        portcolon.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        portcolon.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        portcolon.setText(":");
        this.ipTextbox = new DATextBox(this.mainContentsComp, 4);
        data = new FormData();
        data.top = new FormAttachment(0, 18);
        data.left = new FormAttachment((Control)ipText, 15);
        data.height = 24;
        data.width = 284;
        this.ipTextbox.setLayoutData(data);
        this.ipTextbox.setBackground(ColorResources.WHITE);
        this.ipTextbox.getControl().addKeyListener(this.ipTextboxListener);
        this.portTextbox = new DATextBox(this.mainContentsComp, 4);
        data = new FormData();
        data.top = new FormAttachment(0, 52);
        data.left = new FormAttachment((Control)portText, 15);
        data.height = 24;
        data.width = 284;
        this.portTextbox.setLayoutData(data);
        this.portTextbox.setBackground(ColorResources.WHITE);
        this.portTextbox.getControl().addKeyListener(this.portTextboxListener);
    }

    private void drawButtons() {
        this.connectButton = new Button(this.buttonContentsComp, 0);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 100;
        buttonData.height = 30;
        this.connectButton.setLayoutData((Object)buttonData);
        this.connectButton.setText(WidgetLabels.OK);
        this.connectButton.addSelectionListener(this.connectButtonListener);
        this.connectButton.setEnabled(false);
        this.cancelButton = new Button(this.buttonContentsComp, 0);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 15);
        buttonData.right = new FormAttachment((Control)this.connectButton, -8);
        buttonData.width = 100;
        buttonData.height = 30;
        this.cancelButton.setLayoutData((Object)buttonData);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addSelectionListener(this.cancelButtonListener);
    }

    private void drawProgress() {
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_01);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_02);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_03);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_04);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_05);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_06);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_07);
        this.progressImage.add(ImageResources.STOP_PROGRESS_LOADING_08);
        this.progressIcon = new DAAnimationIcon(this.buttonContentsComp, 0, this.progressImage);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment(0, 15);
        data.height = 24;
        data.width = 24;
        this.progressIcon.setLayoutData((Object)data);
        this.progressIcon.setVisible(false);
        this.progressLabel = new Label(this.buttonContentsComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(0, 20);
        data.left = new FormAttachment((Control)this.progressIcon, 12);
        data.height = 20;
        data.width = 150;
        this.progressLabel.setLayoutData((Object)data);
        this.progressLabel.setBackground(ColorResources.WHITE);
        this.progressLabel.setAlignment(16384);
        this.progressLabel.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        this.progressLabel.setForeground(ColorResources.BLACK);
        this.progressLabel.setText(AnalyzerLabels.CONNECTING);
        this.progressLabel.setVisible(false);
    }

    private boolean checkValidIP(String ipaddr) {
        String[] splitstr = ipaddr.split("\\.");
        if (splitstr == null || splitstr.length != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            int classnum = Integer.parseInt(splitstr[i]);
            if (classnum < 0 || classnum > 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkValidPort(String port) {
        if (port.isEmpty()) {
            return true;
        }
        int portnum = Integer.parseInt(port);
        return portnum >= 1 && portnum <= 65535;
    }

    public String getAddress() {
        return this.address;
    }

    public void setConnectionResult(boolean bresult) {
        if (bresult) {
            this.result = 1;
            this.shell.close();
        } else {
            this.address = null;
            this.progressIcon.setVisible(false);
            this.progressLabel.setVisible(false);
            this.connectButton.setEnabled(true);
            this.connectButton.redraw();
            this.ipTextbox.setEnabled(true);
            this.portTextbox.setEnabled(true);
        }
    }
}

