/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class ToolBarComboRenderer
implements IDACustomButtonRenderer {
    public static final int STATE_COMBO_DROP = 4;
    public static final int DEVICE_COMBO = 0;
    public static final int APP_COMBO = 1;
    public static final int PROCESS_COMBO = 2;

    public void draw(GC gc, Canvas combo, int state, DACustomButtonAttribute attr, int WhatCombo, boolean childOpen) {
        Rectangle rect = combo.getClientArea();
        if (attr.getDrawType() == 0) {
            this.drawImageButton(gc, rect, state, attr);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr, WhatCombo, childOpen);
        } else {
            Logger.debug((Object)("DACustomCombo drawType : " + state));
        }
    }

    protected void drawImageButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        Image image = attr.getImage(state);
        if (image == null) {
            return;
        }
        gc.drawImage(image, rect.x, rect.y);
        this.drawButtonText(gc, rect, attr, state);
        Rectangle clipping = new Rectangle(rect.x + rect.width - 17, rect.y, 17, rect.height);
        gc.setClipping(clipping);
        gc.drawImage(image, rect.x, rect.y);
    }

    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr, int WhatCombo, boolean isChildOpen) {
        if (WhatCombo == 0) {
            if (attr.getDrawType() == 1) {
                gc.setBackground(attr.getColor(state));
                gc.fillRectangle(rect);
            } else if (attr.getDrawType() == 2) {
                gc.setBackground(attr.getColor(state));
                gc.fillRectangle(rect);
            }
            this.drawButtonText(gc, rect, attr, state);
            Color c = gc.getForeground();
            new Rectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            if (attr.getOutlineColor(state) == null) {
                gc.setForeground(ColorResources.GRAY_170);
                return;
            }
            gc.setForeground(ColorResources.GRAY_170);
            gc.drawLine(rect.x, rect.y, rect.x + 168 + 10, rect.y);
            gc.drawLine(rect.x, rect.y + 24 - 1, rect.x + 168 + 10, rect.y + 24 - 1);
            gc.drawLine(rect.x, rect.y, rect.x, rect.y + 24);
            gc.setForeground(c);
            if (isChildOpen) {
                this.drawButtonImage(gc, rect, attr, 4);
            } else {
                this.drawButtonImage(gc, rect, attr, state);
            }
        } else if (WhatCombo == 1) {
            if (attr.getDrawType() == 1) {
                gc.setBackground(attr.getColor(state));
                gc.fillRectangle(rect);
            } else if (attr.getDrawType() == 2) {
                gc.setBackground(attr.getColor(state));
                gc.fillRectangle(rect);
            }
            this.drawButtonText(gc, rect, attr, state);
            Color c = gc.getForeground();
            new Rectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            if (attr.getOutlineColor(state) == null) {
                gc.setForeground(ColorResources.GRAY_170);
                return;
            }
            gc.setForeground(ColorResources.GRAY_170);
            gc.drawLine(rect.x, rect.y, rect.x + 168, rect.y);
            gc.drawLine(rect.x, rect.y + 24 - 1, rect.x + 168, rect.y + 24 - 1);
            gc.drawLine(rect.x + 168 - 1, rect.y, rect.x + 168 - 1, rect.y + 24);
            gc.setForeground(c);
            if (isChildOpen) {
                this.drawButtonImage(gc, rect, attr, 4);
            } else {
                this.drawButtonImage(gc, rect, attr, state);
            }
        } else if (WhatCombo == 2) {
            if (attr.getDrawType() == 1) {
                gc.setBackground(attr.getColor(state));
                gc.fillRectangle(rect);
            } else if (attr.getDrawType() == 2) {
                int index = state * 2;
                gc.setForeground(attr.getColor(index));
                gc.setBackground(attr.getColor(index + 1));
                gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
            }
            this.drawButtonText(gc, rect, attr, state);
            Color c = gc.getForeground();
            Rectangle r = new Rectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            if (attr.getOutlineColor(state) == null) {
                gc.setForeground(c);
                return;
            }
            gc.setForeground(attr.getOutlineColor(state));
            gc.drawRectangle(r);
            gc.setForeground(c);
            if (isChildOpen) {
                this.drawButtonImage(gc, rect, attr, 4);
            } else {
                this.drawButtonImage(gc, rect, attr, state);
            }
        }
    }

    protected void drawButtonImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        if (attr != null) {
            Image img = attr.getButtonImage(state);
            if (state == 4) {
                img = ImageResources.DROP_ARROW_UP_NORL;
            }
            if (img != null) {
                Point p = null;
                Rectangle imgRect = img.getBounds();
                int x = 0;
                int y = 0;
                p = attr.getButtonImagePoint();
                if (p == null) {
                    int width = rect.width - imgRect.width;
                    int height = rect.height - imgRect.height;
                    if (width > 0) {
                        x = width / 2;
                    }
                    if (height > 0) {
                        y = height / 2;
                    }
                } else {
                    x = p.x + 10;
                    y = p.y;
                }
                gc.drawImage(img, x, y);
            }
        }
    }

    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Font font = attr.getFont();
        Point fontPoint = attr.getFontPoint();
        String text = attr.getText();
        int align = attr.getAlign();
        if (font == null) {
            gc.setFont(FontResources.COMBO);
        } else {
            gc.setFont(font);
        }
        if (attr.getFontColor(state) != null) {
            gc.setForeground(attr.getFontColor(state));
        } else if (state == 3) {
            gc.setForeground(ColorResources.COMBO_DISABLE_FONT);
        } else {
            gc.setForeground(ColorResources.COMBO_ENABLE_FONT);
        }
        if (text == null) {
            text = "";
        }
        if (fontPoint == null) {
            Point p = gc.textExtent(text, 8);
            int textX = 0;
            textX = align == 16384 ? 5 : (align == 131072 ? rect.width - p.x : rect.width / 2 - p.x / 2);
            String dispText = this.cuttingTextbyRectWidth(text, gc, rect.width - 60);
            gc.drawString(dispText, textX + 10, (rect.height - p.y) / 2, true);
        } else {
            String dispText = this.cuttingTextbyRectWidth(text, gc, rect.width - 60);
            gc.drawString(dispText, fontPoint.x + 10, fontPoint.y, true);
        }
    }

    private String cuttingTextbyRectWidth(String srcText, GC gc, int srcWidth) {
        String cutText = "";
        int pixelSize = 0;
        int cutIndex = 0;
        char[] cArray = srcText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            pixelSize = gc.getCharWidth(ch) == 1 ? (pixelSize += gc.getFontMetrics().getAverageCharWidth() / 2) : (pixelSize += gc.getCharWidth(ch));
            if (pixelSize > srcWidth) {
                cutText = srcText.substring(0, cutIndex - 2);
                cutText = String.valueOf(cutText) + "...";
                return cutText;
            }
            ++cutIndex;
            ++n2;
        }
        return srcText;
    }

    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
    }
}

